<?php

    namespace App\System\Vendor;
    use Exception;

    class beTask {
        public static function beRunTask($task){
            $file = BE_APPPATH."tasks/{$task['tfilename']}.php";
            if(!file_exists($file)){
                return ["status" => false,"type" => 1,"message" => "Belirtilen görev sistem üzerinde bulunamadı!"];
            }
            require_once $file;
            $taskName = "App\System\Task\\{$task['tfilename']}Task";
            $taskClass = new $taskName();
            try {
                call_user_func_array([$taskClass,"run_task"],[$task]);
            }
            catch(Exception $error){
                return ["status" => false,"type" => 2,"message" => "Görev çalıştırılırken bir hata oluştu.","error" => $error->getMessage()];
            }
            return ["status" => true,"Görev başarılı bir şekilde çalıştırıldı!"];
        }
        public static function beGetNextRun($taskminute,$taskhour,$taskday){
            $time = BE_TIME;
            $currentminute = date("i",$time);
            $currenthour = date("H",$time);
            $currentday = date("d",$time);
            $lastday = date("d",strtotime("last day of this month",$time));
            $nextrun = $time;
            if($taskminute == "*"){
                $nextrun += 60;
            }
            else{
                $find = false;
                $minutes = explode(",",$taskminute);
                $firstminute = $minutes[0];
                foreach($minutes as $minute){
                    if($minute > $currentminute){
                        $find = true;
                        $nextrun += ($minute-$currentminute)*60;
                        break;
                    }
                }
                if($find == false){
                    if($firstminute == 0){
                        $nextrun -= $currentminute*60;
                    }
                    else{
                        $nextrun += (60-$currentminute+$firstminute)*60;
                    }
                }
            }
            if($taskhour != "*"){
                $find = false;
                $hours = explode(",",$taskhour);
                $firsthour = $hours[0];
                foreach($hours as $hour){
                    if($hour > $currenthour){
                        $find = true;
                        $nextrun += ($hour-$currenthour)*3600;
                        break;
                    }
                }
                if($find == false){
                    $nextrun += (24-$currenthour+$firsthour)*3600;
                }
            }
            if($taskday != "*"){
                $find = false;
                $days = explode(",",$taskday);
                $firstday = $days[0];
                foreach($days as $day){
                    if($day > $currentday){
                        $find = true;
                        $nextrun += ($day-$currentday)*86400;
                        break;
                    }
                }
                if($find == false){
                    $nextrun += ($lastday-$currentday+$firstday)*86400;
                }
            }
            return $nextrun;
        }
    }
?>