<?php

    namespace App\System\Vendor;

    class beModule {
        public static $beModules = [];
        public static function beLoadModule($module = ""){
            $path = BE_APPPATH."resources/modules/";
            if(!is_dir($path)){
                echo "Belirtilen modül klasörü bulunamadı!";
                exit;
            }
            $modulepath = explode(".",$module);
            $modulename = $modulepath[count($modulepath)-1];
            if(self::$beModules[$modulename]){
                return ["status" => true];
            }
            $file = str_replace(".","/",$module).".php";
            $filepath = $path.$file;
            if(!file_exists($filepath)){
                return ["status" => false,"message" => "Modül dosyası bulunamadı lütfen sistemi kontrol edin 0xA1"];
            }
            require_once $filepath;
            $moduleclassname = "App\System\Module\\{$modulename}";;
            $moduleclass = new $moduleclassname();
            self::$beModules[$modulename] = [
                "status" => 1,
                "info" => call_user_func([$moduleclass,$modulename."_info"]),
                "module" => $moduleclass
            ];
            return ["status" => true];
        }
        public static function beLoadModules($modulepath = ""){
            $allmodules = self::$beModules;
            self::$beModules = [];
            $path = BE_APPPATH."resources/modules/";
            if(!is_dir($path)){
                echo "Belirtilen modül klasörü bulunamadı!";
                exit;
            }
            if($modulepath){
                $path .= $modulepath."/";
            }
            foreach(glob($path."*.php") as $file){
                $modulename = str_replace([$path,".php"],"",$file);
                if($modulepath){
                    self::beLoadModule($modulepath.".".$modulename);
                }
                else{
                    self::beLoadModule($modulename);
                }
            }
            $loadedmodules = self::$beModules;
            self::$beModules = array_merge($allmodules,$loadedmodules);
            return $loadedmodules;
        }
        public static function beDestruct($module = ""){
            if($module){
                unset(self::$beModules[$module]);
            }
            else{
                self::$beModules = [];
            }
            return true;
        }
        public static function beModuleOrderConfig($modulename,$data = []){
            $options = self::beRunModuleFunction($modulename,"order_config");
            return $options;
        }
        public static function beModuleAddonConfig($modulename,$data = []){
            $options = self::beRunModuleFunction($modulename,"addon_config");
            return $options;
        }
        public static function beModuleProductConfig($modulename,$data = []){
            $options = self::beRunModuleFunction($modulename,"product_config");
            return $options;
        }
        public static function beCheckModuleFunction($modulename,$function){
            $module = self::$beModules[$modulename];
            if(!$module){
                echo "Modül fonksiyonu için önce modülü yüklemeniz gerek!";
                exit;
            }
            return method_exists($module["module"],$modulename."_".$function);
        }
        public static function beRunModuleFunction($modulename,$function,$data = []){
            $module = self::$beModules[$modulename];
            if(!$module){
                echo "Modül fonksiyonu için önce modülü yüklemeniz gerek!";
                exit;
            }
            return call_user_func([$module["module"],$modulename."_".$function],$data);
        }
        public static function beGetModule($modulename){
            $module = self::$beModules[$modulename];
            if(!$module){
                echo "Modül fonksiyonu için önce modülü yüklemeniz gerek!";
                exit;
            }
            return $module["module"];
        }
    }
?>