<?php

namespace App\System\Task;

use App\System\Basic\beModel;
use App\System\Model\InvoiceModel;
use App\System\Model\InvoiceItemModel;
use App\System\Model\SettingModel;
use App\System\Model\UserInfoModel;
use App\System\Vendor\Auth;
use App\System\Vendor\beModule;
use \Exception;

class InvoiceOfficialTask {
    //@ioncube.dk beEncrypt("be_diyocp","run_task") -> "a903b9989410f22c7cf61ad14daefea3" RANDOM
    public function run_task($task){
        $setting = SettingModel::beSelect("scode,svalue")->beWhere("scode","system_invoice_module")->beGet();
        if($setting["svalue"] == ""){ 
            throw new Exception("Resmi fatura modülü bulunamadı!");
        }
        $invoicemodule = $setting["svalue"];
        beModule::beLoadModule("invoice.{$invoicemodule}");
        $logindata = [];
        if(beModule::beCheckModuleFunction($invoicemodule,"login")){
            $logindata = beModule::beRunModuleFunction($invoicemodule,"login");
            if(!$logindata["status"]){
                if(!$logindata["message"]){
                    $logindata["message"] = "Resmi fatura sisteminde kullandığınız modülde giriş kısmında bir sorun yaşandı!";
                }
                throw new Exception($logindata["message"]);
            }
        }
        $checkdate = BE_TIME-86400*2;
        $invoices = InvoiceModel::beSelect("*")->beWhere("istatus","1")->beWhere("ibill","0")->beWhere("itaxprice",0,">")->beWhere("ipaydate",$checkdate,">")->beWhere("ipaymethod",["","wallet"],"NOT IN")->beLimit(2)->beGetAll();
        foreach($invoices as $invoice){
            $updatedata = [
                "ibill" => "1",
                "ibilldate" => BE_TIME
            ];
            InvoiceModel::beUpdate($updatedata)->beWhere("iid",$invoice["iid"])->beExecute();
            if(!$invoice["ipaydate"]){
                $invoice["ipaydate"] = BE_TIME;
                $updatedata["ipaydate"] = $invoice["ipaydate"];
            }
            $user = Auth::beGetUser($invoice["uid"]);
            $userinfo = UserInfoModel::beWhere("uid",$invoice["uid"])->beGet();
            if(!$userinfo){
                beModel::beInsert([
                    "uid" => $invoice["uid"],
                    "sltitle" => "Otomatik Fatura Kesim Hatası",
                    "slcontent" => "Resmi faturanın oluşturulucağın kullanıcı sistem üzerinde bilgilerini doldurmamış.",
                    "sldata" => json_encode(["iid" => $invoice["iid"]],JSON_UNESCAPED_UNICODE),
                    "sldateline" => BE_TIME
                ],"be_system_logs");
                InvoiceModel::beUpdate(["ibill" => "-1"])->beWhere("iid",$invoice["iid"])->beExecute();
                continue;
            }
            $invoiceitems = InvoiceItemModel::beWhere("iid",$invoice["iid"])->beGetAll();
            $response = beModule::beRunModuleFunction($invoicemodule,"create_invoice",array_merge($logindata,[
                "notlogout" => true,
                "invoice" => $invoice,
                "invoiceitems" => $invoiceitems,
                "user" => $user,
                "userinfo" => $userinfo,
                "datetime" => $invoice["ipaydate"]
            ]));
            if(!$response["status"]){
                beModel::beInsert([
                    "uid" => $invoice["uid"],
                    "sltitle" => "Otomatik Fatura Kesim Hatası",
                    "slcontent" => "Modül üzerinde hata oluştu: ".$response["message"],
                    "sldata" => json_encode(["iid" => $invoice["iid"]],JSON_UNESCAPED_UNICODE),
                    "sldateline" => BE_TIME
                ],"be_system_logs");
                $updatedata = ["ibill" => "0"];
                if($response["invoicedata"]["ibilldata"]){
                    $updatedata["ibilldata"] = $response["invoicedata"]["ibilldata"];
                }
                InvoiceModel::beUpdate($updatedata)->beWhere("iid",$invoice["iid"])->beExecute();
                continue;
            }
            if($response["invoicedata"]){
                foreach($response["invoicedata"] as $key => $value){
                    $updatedata[$key] = $value;
                }
            }
            InvoiceModel::beUpdate($updatedata)->beWhere("iid",$invoice["iid"])->beExecute();
        }
        if(beModule::beCheckModuleFunction($invoicemodule,"logout")){
            beModule::beRunModuleFunction($invoicemodule,"logout",$logindata);
        }
    }
}

?>