<?php

    namespace App\System\Basic;

    use App\System\Vendor\bePlugin;

    class beRouter {
        static $beRoutes = [];
        static $beRouteNames = [];
        static $beLastMethod = "",$beLastPattern = "",$bePrefix = "",$beName = "",$beUserIP = "",$beActiveName = "";
        const bePatterns = [
            "id" => "([0-9]+)",
            "id?" => "([0-9]?)",
            "str" => "([a-zA-Z0-9-_]+)",
            "str?" => "([a-zA-Z0-9-_]?)",
            "all" => "(.*)"
        ];
        //@ioncube.dk beEncrypt("be_diyocp","beRoute") -> "5f373d2706636f702ee30345cb4058a8" RANDOM
        public static function beRoute($pattern = "",$module,$method = "get") {
            $pattern = self::$bePrefix.$pattern;
            self::$beRoutes[$method][$pattern] = [
                "module" => $module
            ];
            self::$beLastMethod = $method;
            self::$beLastPattern = $pattern;
            return new self();
        }
        //@ioncube.dk beEncrypt("be_diyocp","bePrefix") -> "f05a78f55dc85c6a4985352b5870c6e4" RANDOM
        public static function bePrefix($prefix = "",$name = ""){
            self::$bePrefix = $prefix;
            self::$beName = $name;
            return new self();
        }
        //@ioncube.dk beEncrypt("be_diyocp","beMatch") -> "01ee1483fa04e4d541be9dea0a26f171" RANDOM
        public function beMatch($name,$regex){
            self::$beRoutes[self::$beLastMethod][self::$beLastPattern]["regexs"][$name] = $regex;
            return $this;
        }
        //@ioncube.dk beEncrypt("be_diyocp","beData") -> "5816bdd199b46a34c23320f44694b9ef" RANDOM
        public function beData($name,$value){
            self::$beRoutes[self::$beLastMethod][self::$beLastPattern]["data"][$name] = $value;
            return $this;
        }
        //@ioncube.dk beEncrypt("be_diyocp","beSpecial") -> "e284db954b1bde196997fa94e41ec148" RANDOM
        public function beSpecial(){
            self::$beRoutes[self::$beLastMethod][self::$beLastPattern]["special"] = 1;
            return $this;
        }
        //@ioncube.dk beEncrypt("be_diyocp","beSetName") -> "fafc6392bd5c330761d4905e9acd8472" RANDOM
        public function beSetName($name = ""){
            self::$beRouteNames[self::$beName.$name] = self::$beLastPattern;
            self::$beRoutes[self::$beLastMethod][self::$beLastPattern]["name"] = self::$beName.$name;
            return $this;
        }
        //@ioncube.dk beEncrypt("be_diyocp","beMiddleWare") -> "89bb81f1b12928cede8ed8f59bcc035b" RANDOM
        public function beMiddleWare($middleware){
            if(is_string($middleware)){
                $middleware = [$middleware];
            }
            self::$beRoutes[self::$beLastMethod][self::$beLastPattern]["middleware"] = $middleware;
            return $this;
        }
        //@ioncube.dk beEncrypt("be_diyocp","beGroup") -> "77d65b14f1e06421770ead30e434e610" RANDOM
        public function beGroup($closure){
            call_user_func($closure);
            self::$bePrefix = "";
            self::$beName = "";
            return $this;
        }
        //@ioncube.dk beEncrypt("be_diyocp","beGetRoute") -> "15cc0b2744043a1f36555f92f059daf7" RANDOM
        public static function beGetRoute($name = "",$params = []){
            $key = self::$beRouteNames[$name];
            if(empty($key)){
                return false;
            }
            foreach($params as $name => $value){
                $key = str_replace("{{$name}}",$value,$key);
            }
            return $key;
        }
        //@ioncube.dk beEncrypt("be_diyocp","beGetMethod") -> "83b1ed636d15142785d8b1a69c139eee" RANDOM
        public static function beGetMethod(){
            return strtolower($_SERVER["REQUEST_METHOD"]);
        }
        //@ioncube.dk beEncrypt("be_diyocp","beGetUrl") -> "06b36bca0cb43fbc94e14b8d47caedff" RANDOM
        public static function beGetUrl(){
            if(isset($_SERVER["HTTP_CF_CONNECTING_IP"])){
                $ipaddress = $_SERVER["HTTP_CF_CONNECTING_IP"];
            }
            else{
                $ipaddress = $_SERVER["REMOTE_ADDR"];
            }
            self::$beUserIP = $ipaddress;
            return explode("?",$_SERVER["REQUEST_URI"])[0];
        }
        //@ioncube.dk beEncrypt("be_diyocp","__call") -> "aa99f697fdad30d2c476aac32595f787" RANDOM
        public function __call($name,$arguments){
            if($name === "beName"){
                return call_user_func(array($this,"beSetName"),$arguments[0]);
            }
        }
        //@ioncube.dk beEncrypt("be_diyocp","__callStatic") -> "35d788f0a165575681884cabdc649454" RANDOM
        public static function __callStatic($name,$arguments){
            if($name === "beName"){
                self::$beName = $arguments[0];
                return new self();
            }
        }
        //@ioncube.dk beEncrypt("be_diyocp","beRedirect") -> "d3d81c388a3bd6b20b4a7a784e67a6da" RANDOM
        public static function beRedirect($url = ""){
            header("Location: {$url}");
            exit;
        }
        //@ioncube.dk beEncrypt("be_diyocp","beFindActiveRoute") -> "27c569ae91497a5f442679dd172fc14e" RANDOM
        public static function beFindActiveRoute(){
            $method = self::beGetMethod();
            $url = self::beGetUrl();
            $routes = self::$beRoutes[$method];
            foreach($routes as $pattern => $data){
                if(@$data["regexs"]){
                    foreach($data["regexs"] as $key => $regex){
                        if(@self::bePatterns[$regex]){
                            $pattern = str_replace("{{$key}}",self::bePatterns[$regex],$pattern);
                        }
                        else{
                            $pattern = str_replace("{{$key}}",$regex,$pattern);
                        }
                    }
                }
                if(preg_match("@^{$pattern}$@",$url,$matches)){
                    return $data["name"];
                }
            }
            return false;
        }
        //@ioncube.dk beEncrypt("be_diyocp","beRun") -> "0652bed278c09a360afcde9874359c76" RANDOM
        public static function beRun(){
            $method = self::beGetMethod();
            $url = self::beGetUrl();
            $routes = self::$beRoutes[$method];
            $status = false;
            foreach($routes as $pattern => $data){
                if(@$data["regexs"]){
                    foreach($data["regexs"] as $key => $regex){
                        if(@self::bePatterns[$regex]){
                            $pattern = str_replace("{{$key}}",self::bePatterns[$regex],$pattern);
                        }
                        else{
                            $pattern = str_replace("{{$key}}",$regex,$pattern);
                        }
                    }
                }
                if(preg_match("@^{$pattern}$@",$url,$matches)){
                    self::$beActiveName = $data["name"];
                    if(@$data["middleware"]){
                        $middlewares = @$data["middleware"] ?? [];
                        foreach($middlewares as $key => $middleware){
                            $middlewarename = "";
                            if(is_numeric($key)){
                                $middlewarename = $middleware;
                                $middlewaredata = null;
                            }
                            else{
                                $middlewarename = $key;
                                $middlewaredata = $middleware;
                            }
                            $controllerName = "App\System\Middleware\\{$middlewarename}Middleware";
                            $controller = new $controllerName();
                            $controller->handle($middlewaredata);
                        }
                    }
                    array_shift($matches);
                    if(@$data["data"]){
                        foreach($data["data"] as $value){
                            $matches[] = $value;
                        }
                    }
                    bePlugin::beRunHook("router_route_start_pre",["route_name" => $data["name"]]);
                    if(is_callable($data["module"])){
                        $view = call_user_func_array($data["module"],$matches);
                    }
                    else{
                        $classData = explode("@",$data["module"]);
                        if(@!$data["special"]){
                            $controllerName = "App\System\Controller\\{$classData[0]}Controller";
                        }
                        else{
                            $controllerName = "App\System\Plugin\\{$classData[0]}";
                        }
                        $controller = new $controllerName();
                        $view = call_user_func_array([$controller,$classData[1]],$matches);
                    }
                    $view = bePlugin::beRunHook("router_route_start_post",["route_name" => $data["name"],"view" => $view])["view"];
                    $status = $view;
                    break;
                }
            }
            return $status;
        }
    }

?>