@extend('layout')
@section('title')
{{ $product['pname'].' - '.beGetConfig('sitename') }}
@endsection
@section('headerinclude')
<link href="assets/servertize/css/clientarea.css?ver=19" rel="stylesheet">
<link href="assets/servertize/css/card.css?ver=12" rel="stylesheet">
<link href="assets/servertize/css/col.css?ver=42" rel="stylesheet">
<link href="assets/servertize/css/forms.css?ver=20" rel="stylesheet">
<style>
.table-summary ul {
    list-style: none;
}
.table-summary ul li i {
    margin-right: 5px;
    color: #fff;
}
.table-summary .buttons {
    display: flex;
    justify-content: center;
}
.table-summary .separator {
    height: 1px;
    margin: 15px 0;
    background-color: #fff;
    opacity: .5;
}
.table-data {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin: 16px 0px;
}
.table-summary span {
    color: #fff;
}
</style>
@endsection
@section('content')
<div class="container">
    <div class="row">
        <div class="col-9 col-md-12 mb-3">
            <div class="card">
                <div class="card-header">
                    <div>
                        <span class="card-title">{{ $product['pname'] }} Adlı Ürünün Yapılandırması</span>
                    </div>
                </div>
                <div class="card-content">
                    <form id="productForm">
                        <input type="hidden" name="pid" value="{{ $product['pid'] }}">
                        <div class="row">
                            <div class="col-12 mb-3">
                                <div class="form-group">
                                    <label for="#">Fatura Döngüsü</label>
                                    <select class="form-control configureSelect" name="period">
                                        @foreach($pperiods as $key => $option)
                                        <option value="{{ $key }}">{{ ($option['operiodtime'] == 0 ? '':$option['operiodtime'].' ').$periods[$option['operiod']].($option['oprice'] == 0 ? '':(' '.beMoneyFormat($option['oprice']).$currencies[$option['ocid']]['cicon'])) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="w-100" id="beProductAddons">

                            </div>
                        </div>
                    </form>
                </div>
            </div>
            @if($product['pdescription'])
            <div class="card p-3 mt-3">
                <div class="card-content">
                    {{ $product['pdescription'] }}
                </div>
            </div>
            @endif
        </div>
        <div class="col-3 col-md-12">
            <div class="card">
                <div class="card-header" style="border-bottom: 1px solid #fff;">
                    <span>Yapılandırma Özeti</span>
                </div>
                <div class="card-content table-summary" id="infoTable" style="background:#151b2c;display:none">
                    <ul>
                        <li id="optionInfo">

                        </li>
                        <li class="separator"></li>
                        <li>
                            <div class="table-data">
                                <span>Ara Toplam</span>
                                <span id="productPrice">0 TL</span>
                            </div>
                        </li>
                        <li>
                            <div class="table-data">
                                <span>KDV(%<div id="totalTaxRate" style="display:contents"></div>)</span>
                                <span id="ratePrice">0 TL</span>
                            </div>
                        </li>
                        <li class="separator"></li>
                        <li class="mb-2">
                            <div class="table-data">
                                <span>Toplam</span>
                                <span id="totalPrice">0 TL</span>
                            </div>
                        </li>
                        <li class="buttons">
                            <a href="#" class="btn btn-primary beCallRequest" data-url="{{ beGetRoute('cart.add.post') }}" data-form="product">Sepete Ekle</a>
                        </li>
                    </ul>
                </div>
                <div class="card-content" id="infoLoading" style="background:#151b2c;display:flex;justify-content:center;align-items:center">
                    <img src="assets/premium/img/loadingnew.gif" style="width:100px;height:100px">
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    checkPrice();
    $("#productForm").on("change",".configureSelect",function(){
        checkPrice();
    });
    var firsttime = true;
    function checkPrice(){
        var icon = "",periodtext = "";
        $("#infoTable").hide();
        $("#infoLoading").css("display","flex");
        $.ajax({
            url: "{{ beGetRoute('product.price') }}?{{ $_SERVER['QUERY_STRING'] }}",
            type: "post",
            data: $("#productForm").serialize(),
            dataType: "json",
            crossDomain: true,
            success: function(response){
                $("#optionInfo").empty();
                icon = response.icon;
                if(response.periodoptions[1] > 0){
                    periodtext = response.periodoptions[1]+" "+response.periodoptions[2];
                }
                else{
                    periodtext = response.periodoptions[2];
                }
                $("#optionInfo").append('<div class="table-data"><div><span>'+response.periodoptions[0]+'</span><span style="display:block;font-size:14px;opacity:0.7">'+periodtext+'</span></div><div><span>'+response.periodoptions[3]+icon+'</span></div></div>');
                $.each(response.addonoptions,function(index,val){
                    if(val[2] > 0){
                        periodtext = val[2]+" "+val[3];
                    }
                    else{
                        periodtext = "";
                    }
                    $("#optionInfo").append('<div class="table-data"><div><span>'+val[0]+'</span><span style="display:block;font-size:14px;opacity:0.9">Seçim: '+val[1]+'</span><span style="display:block;font-size:14px;opacity:0.7">'+periodtext+'</span></div><div><span>'+val[4]+icon+'</span></div></div>');
                });
                $("#beProductAddons").empty().append(response.addonoptionshtml);
                $("#productPrice").html(response.productprice+" "+icon);
                $("#ratePrice").html(response.totalrate+" "+icon);
                $("#totalPrice").html(response.totalprice+" "+icon);
                $("#totalTaxRate").html(response.taxrate);
                $("#infoTable").show();
                $("#infoLoading").hide();
                if(firsttime){
                    checkPrice();
                    firsttime = false;
                }
            }
        });
    }
</script>
@endsection