<div class="row g-5 g-xl-8 mb-7">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title">
                    Fatura Bilgileri
                </div>
            </div>
            <div class="card-body pb-0">
                <div class="d-flex flex-wrap py-5">
                    <div class="flex-equal me-5">
                        <table class="table table-flush fw-semibold gy-1">
                            <tbody>
                                @if($userindetity['uid'])
                                    @if($userindetity['uitype'] == 1)
                                    <tr>
                                        <td class="text-muted min-w-125px w-125px">Kayıt Tipi</td>
                                        <td class="text-gray-800">Bireysel</td>
                                    </tr>
                                    <tr>
                                        <td class="text-muted min-w-125px w-125px">Kimlik Numarası</td>
                                        <td class="text-gray-800">{{ $userindetity['uitcno'] }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-muted min-w-125px w-125px">Ad Soyad</td>
                                        <td class="text-gray-800">{{ $userindetity['uiname'].' '.$userindetity['uisurname'] }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-muted min-w-125px w-125px">Doğum Tarihi</td>
                                        <td class="text-gray-800">{{ $userindetity['uibirthdate'] }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-muted min-w-125px w-125px">Adres</td>
                                        <td class="text-gray-800">{{ $userindetity['uiaddress'] }}</td>
                                    </tr>
                                    @else
                                    <tr>
                                        <td class="text-muted min-w-125px w-125px">Kayıt Tipi</td>
                                        <td class="text-gray-800">Kurumsal</td>
                                    </tr>
                                    <tr>
                                        <td class="text-muted min-w-125px w-125px">Vergi Numarası</td>
                                        <td class="text-gray-800">{{ $userindetity['uitaxno'] }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-muted min-w-125px w-125px">Şirket Adı</td>
                                        <td class="text-gray-800">{{ $userindetity['uititle'] }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-muted min-w-125px w-125px">Vergi Dairesi</td>
                                        <td class="text-gray-800">{{ $userindetity['uitaxadmin'] }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-muted min-w-125px w-125px">Adres</td>
                                        <td class="text-gray-800">{{ $userindetity['uiaddress'] }}</td>
                                    </tr>
                                    @endif
                                @endif
                                @if($userindetityother['uid'])
                                    <tr>
                                        <td class="text-muted min-w-125px w-125px">Ad Soyad</td>
                                        <td class="text-gray-800">{{ $userindetityother['uiname'].' '.$userindetityother['uisurname'] }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-muted min-w-125px w-125px">Adres</td>
                                        <td class="text-gray-800">{{ $userindetityother['uiaddress'] }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-muted min-w-125px w-125px">Fotoğraflar</td>
                                        <td class="text-gray-800">
                                        <div class="mt-3">
                                                @foreach($userindetityother['attachments'] as $attachment)
                                                <div class="card bg-light p-3 mb-3">
                                                    <div class="d-flex align-items-center">
                                                        <span class="svg-icon svg-icon-2x svg-icon-primary me-4">
                                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <path opacity="0.3" d="M19 22H5C4.4 22 4 21.6 4 21V3C4 2.4 4.4 2 5 2H14L20 8V21C20 21.6 19.6 22 19 22Z" fill="currentColor"></path>
                                                                <path d="M15 8H20L14 2V7C14 7.6 14.4 8 15 8Z" fill="currentColor"></path>
                                                            </svg>
                                                        </span>
                                                        <a href="{{ beGetRoute('file.show',['slug' => $attachment['aslug'],'aid' => $attachment['aid']]) }}" target="_blank" class="text-gray-800 text-hover-primary">{{ $attachment['aname'] }}</a>
                                                    </div>
                                                    <div class="mt-2 d-flex justify-content-between">
                                                        <span style="opacity:.5">{{ beConvertSize($attachment['asize']) }}</span>
                                                        <span style="opacity:.5">{{ beSpecialTime($attachment['adateline']) }}</span>
                                                    </div>
                                                </div>
                                                @endforeach
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="text-muted min-w-125px w-125px">İşlemler</td>
                                        <td>
                                            <a href="#" class="btn btn-danger beSetIdentity{{ $userindetityother['uistatus'] == '-1' ? ' disabled':'' }}" data-status="-1">Reddet</a>
                                            <a href="#" class="btn btn-primary beSetIdentity{{ $userindetityother['uistatus'] == '0' ? ' disabled':'' }}" data-status="0">Beklemeye Al</a>
                                            <a href="#" class="btn btn-success beSetIdentity{{ $userindetityother['uistatus'] == '1' ? ' disabled':'' }}" data-status="1">Onayla</a>
                                        </td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="card-body p-3">
                <a class="btn btn-danger beResetIdentity">Kimlik Bilgierini Sıfırla</a>
            </div>
        </div>
    </div>
</div>
<script>
    $(".beSetIdentity").on("click",function(){
        var status = parseInt($(this).data("status"));
        $.ajax({
            url: "{{ beGetRoute('useridentity.set.status.post') }}",
            type: "post",
            data: {uid:"{{ $user['uid'] }}",status:status},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    Swal.fire("Başarılı",response.message,"success");
                    setTimeout(function(){
                        location.reload();
                    },1000);
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });	
        return false;
    });
    $(".beResetIdentity").on("click",function(){
        $.ajax({
            url: "{{ beGetRoute('useridentity.reset.user.post') }}",
            type: "post",
            data: {uid:"{{ $user['uid'] }}"},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    Swal.fire("Başarılı",response.message,"success");
                    setTimeout(function(){
                        location.reload();
                    },1000);
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });	
        return false;
    });
</script>