@extend('admin.layout')
@section('headerinclude')
<title>Gib - Modülü</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="docs-content d-flex flex-column flex-column-fluid" id="kt_docs_content">
            <div class="container" id="kt_docs_content_container">
                <div class="card card-docs flex-row-fluid mb-2">
                    <div class="card-body fs-6 py-15 px-10 py-lg-15 px-lg-15 text-gray-700">
                        <div>
                            <h1 class="anchor fw-bold mb-2" id="gulp-quick-start" data-kt-scroll-offset="50">Gib Modülü</h1>
                            <div>GIB modülüne hoşgeldiniz, bu modül ile sistem üzerindeki faturalarınızı resmileştirebilirsiniz. Resmileştirme işlemi tam uyumluluk ile sağlanmaktadır.</div>
                            <div class="mb-3">Sistemin çalışması için gerekli olan bilgileri içerir. Ayarları yapmak için "Ayarları Yap" butonuna basınız.</div>
                            <div>
                                <a data-bs-toggle="tooltip" title="Eklenti Ayarları" class="btn btn-primary" href="{{ $settingsurl }}">
                                    <span class="svg-icon svg-icon-2 mx-0">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <rect x="2" y="2" width="9" height="9" rx="2" fill="currentColor"></rect>
                                            <rect opacity="0.3" x="13" y="2" width="9" height="9" rx="2" fill="currentColor"></rect>
                                            <rect opacity="0.3" x="13" y="13" width="9" height="9" rx="2" fill="currentColor"></rect>
                                            <rect opacity="0.3" x="2" y="13" width="9" height="9" rx="2" fill="currentColor"></rect>
                                        </svg>
                                    </span>
                                    Ayarları Yapın
                                </a>
                            </div>
                            <div class="separator separator-dashed my-5"></div>
                            <div class="mb-3">Bilgilerinizi doğruladıktan sonra alttaki "Giriş Testi" alanı ile bilgilerinizi doğrulayın</div>
                            <div>
                                <a data-bs-toggle="tooltip" title="Giriş Testi" class="btn btn-primary beTestConnection" href="#">
                                    <span class="svg-icon svg-icon-2 mx-0">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <rect x="2" y="2" width="9" height="9" rx="2" fill="currentColor"></rect>
                                            <rect opacity="0.3" x="13" y="2" width="9" height="9" rx="2" fill="currentColor"></rect>
                                            <rect opacity="0.3" x="13" y="13" width="9" height="9" rx="2" fill="currentColor"></rect>
                                            <rect opacity="0.3" x="2" y="13" width="9" height="9" rx="2" fill="currentColor"></rect>
                                        </svg>
                                    </span>
                                    Giriş Testi
                                </a>
                            </div>
                            <div class="alert alert-info d-flex align-items-center p-5 mt-9">
                                <span class="svg-icon svg-icon-2hx svg-icon-info me-4">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path opacity="0.3" d="M11.8 5.2L17.7 8.6V15.4L11.8 18.8L5.90001 15.4V8.6L11.8 5.2ZM11.8 2C11.5 2 11.2 2.1 11 2.2L3.8 6.4C3.3 6.7 3 7.3 3 7.9V16.2C3 16.8 3.3 17.4 3.8 17.7L11 21.9C11.3 22 11.5 22.1 11.8 22.1C12.1 22.1 12.4 22 12.6 21.9L19.8 17.7C20.3 17.4 20.6 16.8 20.6 16.2V7.9C20.6 7.3 20.3 6.7 19.8 6.4L12.6 2.2C12.4 2.1 12.1 2 11.8 2Z" fill="currentColor"></path>
                                        <path d="M11.8 8.69995L8.90001 10.3V13.7L11.8 15.3L14.7 13.7V10.3L11.8 8.69995Z" fill="currentColor"></path>
                                    </svg>
                                </span>
                                <div class="d-flex flex-column">
                                    <span id="orderCount">Tüm işlemleri tamamladıktan sonra Ayarlar > Modül Ayarları kısmında Gib Fatura Resmileştirme modülünü seçmeyi unutmayınız</span>
                                </div>
                            </div>
                        </div>    
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
$(".beTestConnection").on("click",function(){
    $.ajax({
        url: "{{ beGetRoute('gib.test.connetcion.post') }}",
        type: "post",
        dataType: "json",
        crossDomain: true,
        success: function(response){
            if(response.status){
                Swal.fire("Başarılı",response.message,"success");
            }
            else{
                Swal.fire("Bir Hata Oluştu",response.message,"error");
            }
        }
    });	
    return false;
});
</script>
@endsection