<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-git-repository-line"></i> {{ __('manage_snapshot') }}</span>
                </div>
                <div>
                    <a href="#" class="btn btn-primary btn-sm beCallRequestx" data-method="snapshot_create"><i class="ri-add-line"></i> {{ __('snapshotpage_takesnapshot') }}</a>
                </div>
            </div>
            <div class="card-content">
                <table class="btable">
                    <thead>
                        <tr>
                            <th>{{ __('snapshotpage_snapname') }}</th>
                            <th>{{ __('snapshotpage_snapdate') }}</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @if($snapshotlist)
                        @foreach($snapshotlist as $snapshot)
                        <tr id="snapshot{{ $snapshot["ssid"] }}">
                            <td>{{ $snapshot["sname"] }}</td>
                            <td>{{ date("d.m.Y H:i",$snapshot["sdateline"]) }}</td>
                            <td style="display:flex;justift-content:center;align-items:center">
                                <a href="#" class="btn btn-primary btn-sm beCallRequestx" data-method="snapshot_deploy" data-data="ssid={{ $snapshot['ssid'] }}">
                                    <i class="ri-upload-line"></i>
                                    {{ __('snapshotpage_deploy') }}
                                </a>
                                <a href="#" class="btn btn-transparent btn-sm ml-2 beCallRequestx" data-method="snapshot_delete" data-data="ssid={{ $snapshot['ssid'] }}">
                                    <i class="ri-delete-bin-line"></i>
                                    {{ __('snapshotpage_delete') }}
                                </a>
                            </td>
                        </tr>
                        @endforeach
                        @else
                        <tr>
                            <td colspan="3">
                                <div class="beempty">
                                    <div>{{ __('snapshotpage_empty') }}</div>
                                    <div><a href="#" class="btn btn-primary beCallRequestx" data-method="snapshot_create"><i class="ri-add-line"></i> {{ __('snapshotpage_takesnapshot') }}</a></div>
                                </div>
                            </td>
                        </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script>
    var wait = false;
    $(".beCallRequestx").on("click",function(){
        if(!wait){
            wait = true;
            var item = $(this);
            var content = item.html();
            item.html('<span class="beSpinner"></span> Lütfen Bekleyiniz!');
            var method = item.data("method");
            var form = item.data("form");
            var data = item.data("data");
            var datacontent = "";
            if(form){
                datacontent = $("#"+form+"Form").serialize()+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            else{
                datacontent = data+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            $.ajax({
                url: "{{ beGetRoute('client.userproduct.userproduct.show.post') }}",
                type: "post",
                data: datacontent,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    item.html(content);
                    if(response.status){
                        $.Toast("Başarılı",response.message,"success");
                        if(response.refresh){
                            setTimeout(function(){
                                location.reload();
                            },1000);
                        }
                    }
                    else{
                        $.Toast("Bir Sorun Oluştu",response.message,"error");
                    }
                }
            });	
            return false;
        }
        else{
            $.Toast("Bir Sorun Oluştu","İşlem devam ediyor lütfen bekleyiniz","error");
        }
    });
</script>