@if(!$_COOKIE['be_cookie_allow'])
<div class="beCookie">
    <div class="cookie-text">
        {{ beGetConfig('sitename') }} sizlere daha iyi hizmet sunmak için çerezleri kullanıyor. {{ beGetConfig('sitename') }}'i kullanarak çerezleri kullanmamızı kabul etmiş olacaksınız.
        Detaylı bilgi almak için <a href="{{ beGetRoute('cookie_policie') }}" target="_blank" rel="nofollow noreferrer" title="Gizlilik ve Çerez Politikası" alt="Gizlilik ve Çerez Politikası">Gizlilik ve Çerez Politikası</a> metnimizi inceleyebilirsiniz.
    </div>
    <div>
        <button class="beCloseCookie" aria-label="Kapat">
            <i class="ri-close-line"></i>
        </button>
    </div>
</div>
@endif
<footer>
    <div class="infoarea container">
        <div class="officialinfo">
            <div class="logo">
                <a href="#" title="{{ beGetConfig('sitename') }}">
                    <img src="{{ $be->settings['system_logo_footer'] }}" width="100%" height="auto" title="{{ beGetConfig('sitename') }}" alt="{{ beGetConfig('sitename') }}" crossorigin="anonymous">
                </a>
            </div>
            <div class="infos">
                <span>{{ beGetConfig('sitename') }}</span>
                <span>{{ beGetConfig('company_address') }}</span>
                <div class="officallinks">
                    @if(!empty(beGetConfig('company_phone_number')))
                    <a target="_blank" href="tel:+{{ beGetConfig('company_phone_number') }}" title="{{ beGetConfig('company_phone_text') }}" alt="{{ beGetConfig('company_phone_text') }}" rel="nofollow noreferrer">
                        <i class="ri-phone-fill"></i>
                        {{ beGetConfig('company_phone_text') }}
                    </a>
                    @endif
                    <a href="mailto:{{ beGetConfig('company_mail') }}" title="{{ beGetConfig('company_mail') }}" alt="{{ beGetConfig('company_mail') }}" rel="nofollow noreferrer">
                        <i class="ri-mail-send-line"></i>
                        {{ str_replace('@','[@]',beGetConfig('company_mail')) }}
                    </a>
                </div>
                <span>Geleceğe giden yolda hep beraber!</span>
            </div>
        </div>
        <div class="links">
            <ul>
                @foreach($temp['menus']['footer'] as $menu)
                @if($menu['type'] == 'url')
                <li>
                    <a class="text-normal" href="{{ $menu['url'] }}" alt="{{ $menu['name'] }}" title="{{ $menu['name'] }}">{{ $menu['name'] }}</a>
                </li>
                @endif
                @if($menu['type'] == 'menu')
                <li>
                    <div>{{ $menu['name'] }}</div>
                    <ul>
                        @foreach($menu['altmenus'] as $altmenu)
                        @php if(!$altmenu) continue; @endphp
                        <li>
                            <a href="{{ $altmenu['url'] }}" alt="{{ $altmenu['name'] }}" title="{{ $altmenu['name'] }}" rel="{{ strpos($altmenu['url'],beGetConfig('siteurl')) === false ? 'noreferrer nofollow':'' }}">{{ $altmenu['name'] }}</a>
                        </li>
                        @endforeach
                    </ul>
                </li>
                @endif
                @endforeach
            </ul>
        </div>
    </div>
    <hr class="container">
    <div class="copyright container">
        <div class="logo">
            <a href="#" title="{{ beGetConfig('sitename') }}">
                <amp-img src="{{ $be->settings['system_logo_footer_mini'] }}" alt="{{ beGetConfig('sitename') }}" crossorigin="anonymous"  width="64" height="64">
                    <noscript>
                        <img src="{{ $be->settings['system_logo_footer_mini'] }}" alt="{{ beGetConfig('sitename') }}" crossorigin="anonymous"  width="64" height="64">
                    </noscript>
                </amp-img>
            </a>
        </div>
        <span>
            {{ beGetConfig('sitename') }}, Bilgi Teknolojileri ve İletişim Kurumu (BTK) lisansı ile ticari amaçla faliyet gösteren yasal yer sağlayıcı ve hosting firmasıdır.
        </span>
    </div>
    <hr class="container">
    <div class="copyrightalt container">
        <div>
            <span>{{ beGetConfig('sitename') }} - {{ date('Y') }} Tüm Hakları Saklıdır.</span>
        </div>
        <div>
        <img src="assets/servertize/img/iyzicowhite.svg?v=2" title="Iyzico" alt="Iyzico" crossorigin="anonymous"  width="400" height="32">
        </div>
    </div>
</footer>
<script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "Organization",
      "url": "{{ beGetConfig('siteurl') }}",
      "logo": "{{ beGetConfig('siteurl').'/'.beGetConfig('system_logo_header') }}"
    }
</script>
<script src="assets/servertize/js/main.min.js" defer></script>
<script src="assets/servertize/js/sweetalert.js?v=3" defer></script>
<script src="assets/plugins/toast/toast.script.js?v=2" defer></script>