@extend('clientarea.layout')
@section('title'){{ $ticket['tsubject'] }} - {{ beGetConfig('sitename') }}@endsection
@section('headerinclude')
<style>
.invoice-key {
    display: block;
    font-size: 18px;
    color: #464d51;
}
.invoice-val {
    display: block;
    font-size: 14px;
    color: #464d51;
}
</style>
@endsection
@section('content')
<div class="card mb-3">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-coupon-3-line"></i> Talep Bilgileri</span>
        </div>
    </div>
    <div class="card-content">
        <div class="row mb-5 mt-5">
            <div class="col-4 text-center my-3">
                <span class="invoice-key">Talep No</span>
                <span class="invoice-val">#{{ $ticket['tid'] }}</span>
            </div>
            <div class="col-4 text-center my-3">
                <span class="invoice-key">Talep Başlığı</span>
                <span class="invoice-val">{{ $ticket['tsubject'] }}</span>
            </div>
            <div class="col-4 text-center my-3">
                <span class="invoice-key">Departman</span>
                <span class="invoice-val">{{ $ticket['depertment']['tdname'] }}</span>
            </div>
            <div class="col-4 text-center my-3">
                <span class="invoice-key">Talep Durumu</span>
                <span class="invoice-val text-{{ $ticketstatus[$ticket['tstatus']][1] }}">{{ $ticketstatus[$ticket['tstatus']][0] }}</span>
            </div>
            <div class="col-4 text-center my-3">
                <span class="invoice-key">Cevap Durumu</span>
                <span class="invoice-val text-{{ $ticketreplystatus[$ticket['tlastreply']][1] }}">{{ $ticketreplystatus[$ticket['tlastreply']][0] }}</span>
            </div>
            <div class="col-4 text-center my-3">
                <span class="invoice-key">Oluşturulma Tarihi</span>
                <span class="invoice-val">{{ beSpecialTime($ticket['tdateline']) }}</span>
            </div>
        </div>
    </div>
</div>
<div class="card mb-3">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-coupon-3-line"></i> Talebi Cevapla</span>
        </div>
        <div>
            <i class="ri-add-line ticket-reply" role="button"></i>
        </div>
    </div>
    <div class="card-content no-p reply-ticket">
        <form id="beTicketForm">
            <div class="row p-3">
                <div class="col-12 mb-3">
                    <textarea class="form-control" name="message" id="messageArea" rows="8" placeholder="Talep içeriğini giriniz"></textarea>
                </div>
                <div class="col-12 row-center row-flex">
                    <a href="#" class="btn btn-special beSendReply">Cevapla</a>
                </div>
            </div>
        </form>
    </div>
</div>
{{ $posts }}
@endsection
@section('js')
<script src="assets/plugins/custom/tinymce/tinymce.bundle.js?v=32"></script>
<script>
    $(document).ready(function(){
        $(".reply-ticket").hide();
    });
    $(".ticket-reply").on("click",function(){
        if($(this).hasClass("ri-add-line")){
            $(this).removeClass("ri-add-line").addClass("ri-subtract-line");
            $(".reply-ticket").show("slow");
        }
        else{
            $(this).removeClass("ri-subtract-line").addClass("ri-add-line");
            $(".reply-ticket").hide("slow");
        }
    });
    var options = {
        selector: "#messageArea",
        height: "480",
        entity_encoding: "raw"
    };
    tinymce.init(options);
    $(".beSendReply").on("click", function() {
        var data = $("#beTicketForm").serialize();
        data += "&tid={{ $ticket['tid'] }}&message=" + tinymce.activeEditor.getContent();
        beClassRequestItem($(this), "{{ beGetRoute('client.ticket.postticket.post') }}", data);
        return false;
    });
</script>
@endsection