@extend('clientarea.layout')
@section('title')Yeni Destek Talebi Oluştur - {{ beGetConfig('sitename') }}@endsection
@section('content')
<div class="card">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-coupon-3-line"></i> Yeni Talep Oluştur</span>
        </div>
    </div>
    <div class="card-content">
        <form id="beTicketForm">
            <div class="row">
                <div class="col-12 mb-3">
                    <div class="form-group">
                        <label for="#">Talep Başlığı</label>
                        <input type="text" class="form-control" name="subject" required="required" placeholder="Destek Talebi Basliginiz">
                    </div>
                </div>
                <div class="col-6 mb-3">
                    <div class="form-group">
                        <label for="#">Departman</label>
                        <select class="form-control" name="depertment">
                            @foreach($depertments as $depertment)
                            <option value="{{ $depertment['tdid'] }}">{{ $depertment['tdname'] }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-6 mb-3">
                    <div class="form-group">
                        <label for="#">Hizmet</label>
                        <select class="form-control" name="userproduct">
                            <option value="0">Hizmet Seçiniz</option>
                            @foreach($userproducts as $userproduct)
                            <option value="{{ $userproduct['upid'] }}">{{ $userproduct['upname'].' # '.$userproduct['uptag'] }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-12 mb-3">
                    <div class="form-group">
                        <label for="#">Mesaj İçeriği</label>
                        <textarea class="form-control" name="message" id="messageArea" rows="8" placeholder="Talep içeriğini giriniz"></textarea>
                    </div>
                </div>
                <div class="col-12 row-center row-flex">
                    <a href="#" class="btn btn-special beSendTicket">Gönder</a>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
@section('js')
<script src="assets/plugins/custom/tinymce/tinymce.bundle.js?v=32"></script>
<script>
    var options = {
        selector: "#messageArea",
        height: "480",
        entity_encoding: "raw"
    };
    tinymce.init(options);
    $(".beSendTicket").on("click",function(){
        var data = $("#beTicketForm").serialize();
        data += "&message="+tinymce.activeEditor.getContent();
        beClassRequestItem($(this),"{{ beGetRoute('client.ticket.newticket.post') }}",data);
        return false;
    });
</script>
@endsection