@extend('clientarea.layout')
@section('title')SMS Kayıtlarım - {{ beGetConfig('sitename') }}@endsection
@section('content')
<div class="card mb-5">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-phone-line"></i> SMS Kayıtlarım</span>
        </div>
    </div>
    <div class="card-content">
        <table class="btable">
            <thead>
                <tr>
                    <th>Kayıt No</th>
                    <th>Mesaj</th>
                    <th>Tarih</th>
                </tr>
            </thead>
            <tbody>
                @if($items)
                @foreach($items as $item)
                <tr>
                    <td>
                        <span># dP-{{ $item['sid'] }}</span>
                    </td>
                    <td>
                        <div>
                            <span class="first-row">{{ $item['smessage'] }}</span>
                        </div>
                    </td>
                    <td>
                        <span class="first-row">{{ beSpecialTime($item['sdateline']) }}</span>
                    </td>
                </tr>
                @endforeach
                @else
                <tr>
                    <td colspan="6">
                        <div class="my-3">Bu kısımda gösterilicek bir veri bulunamadı!</div>
                    </td>
                </tr>
                @endif
            </tbody>
        </table>
    </div>
</div>
@if($itemcount > 15)
<div class="card row-flex row-center">
    {{ $paganation['paganation'] }}
</div>
@endif
@endsection