@extend('clientarea.layout')
@section('title')Hizmet Kayıtlarım - {{ beGetConfig('sitename') }}@endsection
@section('content')
<div class="card mb-5">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-shopping-cart-line"></i> Hizmet Kayıtlarım</span>
        </div>
    </div>
    <div class="card-content">
        <table class="btable">
            <thead>
                <tr>
                    <th>Hizmet No</th>
                    <th>Hizmet</th>
                    <th>Ücret</th>
                    <th>Kapanma Tarihi</th>
                    <th>Durum</th>
                </tr>
            </thead>
            <tbody>
                @if($items)
                @foreach($items as $item)
                <tr>
                    <td>
                        <span>#{{ $item['upid'] }}</span>
                    </td>
                    <td>
                        <div>
                            <span class="first-row">{{ $item['upname'] }}</span>
                            <span class="second-row text-sm">{{ $item['uptag'] }}</span>
                        </div>
                    </td>
                    <td>
                        <span class="first-row">{{ beMoneyFormat($item['upprice']).' '.$currencies[$item['cid']]['cicon'] }}</span>
                    </td>
                    <td>
                        <span class="first-row text-danger">{{ beSpecialTime($item['upetime']) }}</span>
                    </td>
                    <td>
                        <span class="btn btn-{{ $userproductstatus[$item['upstatus']][1] }}">
                            {{ $userproductstatus[$item['upstatus']][0] }}
                        </span>
                    </td>
                </tr>
                @endforeach
                @else
                <tr>
                    <td colspan="6">
                        <div class="my-3">Bu kısımda gösterilicek bir veri bulunamadı!</div>
                    </td>
                </tr>
                @endif
            </tbody>
        </table>
    </div>
</div>
@if($itemcount > 15)
<div class="card row-flex row-center">
    {{ $paganation['paganation'] }}
</div>
@endif
@endsection