asdasd@extend('admin.layout')
@section('headerinclude')
<link href="assets/plugins/codemirror/codemirror.css" rel="stylesheet" type="text/css"/>
<link href="assets/plugins/codemirror/material.css" rel="stylesheet" type="text/css"/>
<link href="assets/plugins/codemirror/material-darker.css" rel="stylesheet" type="text/css"/>
<link href="assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css"/>
<script src="assets/plugins/global/plugins.bundle.js"></script>
<script src="assets/plugins/codemirror/codemirror.js"></script>
<script src="assets/plugins/codemirror/active-line.js"></script>
<script src="assets/plugins/codemirror/matchbrackets.js"></script>
<script src="assets/plugins/codemirror/xml.js"></script>
<script src="assets/plugins/codemirror/css.js"></script>
<script src="assets/plugins/codemirror/htmlmixed.js"></script>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Tema Düzenle
                </div>
            </div>
            <div class="card-body">
                <form id="themePageForm">
                    <div class="row">
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Sayfa Adı</label>
                            <input type="text" class="form-control" name="tpname">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Tema</label>
                            <select class="form-control form-control-select" name="tid">
                                @foreach($themes as $tid => $tname)
                                <option value="{{ $tid }}">{{ $tname }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Sayfa Başlık(HTML)<span class="text-danger">*</span></label>
                            <textarea class="form-control html-code" name="tpheader" rows="5"></textarea>
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Sayfa Slider(HTML)<span class="text-danger">*</span></label>
                            <textarea class="form-control html-code" name="tpcontentup" rows="5"></textarea>
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Sayfa İçerik(HTML)<span class="text-danger">*</span></label>
                            <textarea class="form-control html-code" name="tpcontent" rows="5"></textarea>
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Sayfa Kodu(JavaScript)<span class="text-danger">*</span></label>
                            <textarea class="form-control html-code" name="tpjavascript" rows="5"></textarea>
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Sayfa Düzenleme Kodu(Kategori Sistemi İçin)<span class="text-danger">*</span></label>
                            <textarea class="form-control json-code" name="tppagedata" rows="5"></textarea>
                        </div>    
                        <div class="col-12 d-flex align-items-center">
                            <button class="btn btn-success d-block m-auto addThemePage">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script src="assets/plugins/custom/tinymce/tinymce.bundle.js"></script>
<script src="assets/plugins/custom/draggable/draggable.bundle.js"></script>
<script>
    var codemirrorInstance = [];
    var length = 0;
    $(document).ready(function(){
        var foundtextareasarr = document.getElementsByClassName("html-code");
        for(var i = 0; foundtextareasarr[i]; ++i) { 
            codemirrorInstance[length+i] = CodeMirror.fromTextArea(foundtextareasarr[i], {
                lineNumbers: true,
                mode: "htmlmixed",
                theme: "material-darker"   
            });
        }
        foundtextareasarr = document.getElementsByClassName("json-code");
        for(var i = 0; foundtextareasarr[i]; ++i) { 
            codemirrorInstance[length+i] = CodeMirror.fromTextArea(foundtextareasarr[i], {
                lineNumbers: true,
                mode: {name:"javascript",json:true},
                theme: "material-darker",
                lineWrapping: true,
                foldGutter: true,
            });
        }
        length = codemirrorInstance.length;
    });
    var wait = false;
    $(".addThemePage").on("click",function(){
        if(!wait){
            $(".addThemePage").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            for(var i = 0; i < length; ++i) { 
                codemirrorInstance[i].save();
            }
            $.ajax({
                url: "{{ beGetRoute('admin.theme.page.add.post') }}",
                type: "post",
                async: true,
                data: $("#themePageForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".addThemePage").html("Kaydet");
                    if(response.status){
                        setTimeout(function(){
                            window.location.href = response.url;
                        },1000);
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection