@extend('admin.layout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="d-flex justify-content-end">
            <a href="{{ beGetRoute('admin.task.add') }}" class="d-inline-flex align-items-center btn btn-primary mb-5 mx-3">
                <span class="svg-icon svg-icon-muted d-flex align-items-center">
                    <svg width="23" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"/>
                        <rect x="10.8891" y="17.8033" width="12" height="2" rx="1" transform="rotate(-90 10.8891 17.8033)" fill="currentColor"/>
                        <rect x="6.01041" y="10.9247" width="12" height="2" rx="1" fill="currentColor"/>
                    </svg>
                </span>
                Yeni Ekle
            </a>
        </div>
        @if(BE_TIME-$lastcron > 86400)
        <div class="row">
            <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                <span class="svg-icon svg-icon-2hx svg-icon-danger me-4">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path opacity="0.3" d="M11.8 5.2L17.7 8.6V15.4L11.8 18.8L5.90001 15.4V8.6L11.8 5.2ZM11.8 2C11.5 2 11.2 2.1 11 2.2L3.8 6.4C3.3 6.7 3 7.3 3 7.9V16.2C3 16.8 3.3 17.4 3.8 17.7L11 21.9C11.3 22 11.5 22.1 11.8 22.1C12.1 22.1 12.4 22 12.6 21.9L19.8 17.7C20.3 17.4 20.6 16.8 20.6 16.2V7.9C20.6 7.3 20.3 6.7 19.8 6.4L12.6 2.2C12.4 2.1 12.1 2 11.8 2Z" fill="currentColor"></path>
                        <path d="M11.8 8.69995L8.90001 10.3V13.7L11.8 15.3L14.7 13.7V10.3L11.8 8.69995Z" fill="currentColor"></path>
                    </svg>
                </span>
                <div class="w-100 d-flex align-items-center justify-content-between">
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-danger">Bir sorun mevcut?</h4>
                        <span>Görev sistemi {{ round((BE_TIME-$lastcron)/86400) }} gündür çalışmıyor. Lütfen görev sisteminin çalışması için aşağıdaki görevi dakikalık olacak şekilde hostinginize ekleyiniz.</span>
                        <span>{{ str_replace('resources/cache/views','',__DIR__).'task.php' }}</span>
                    </div>
                    
                </div>
            </div>
        </div>
        @endif
        <div class="card mb-4">
            <div class="table-responsive">
                <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                    <thead>
                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                            <th class="text-center align-middle">#</th>
                            <th class="text-center align-middle">Görev Adı</th>
                            <th class="text-center align-middle">Süresi(D/S/G)</th>
                            <th class="text-center align-middle">Durum</th>
                            <th class="text-center align-middle">Sıralama</th>
                            <th class="text-center align-middle">Son Çalışma Tarihi</th>
                            <th class="text-center align-middle">Sonraki Çalışma Tarihi</th>
                            <th class="text-center align-middle">Eklenme Tarihi</th>
                            <th class="text-center align-middle"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($tasks as $task)
                        <tr id="{{ $task['tid'] }}Row">
                            <td class="text-center align-middle">{{ $task['tid'] }}</td>
                            <td class="text-center align-middle">{{ $task['tname'] }}</td>
                            <td class="text-center align-middle">{{ $task['tcronminute'].' '.$task['tcronhour'].' '.$task['tcronday'] }}</td>
                            <td class="text-center align-middle" id="{{ $task['tid'] }}Status"><span class="badge {{ $task['tstatus'] == 1 ? 'badge-success':'badge-danger' }}">{{ $task['tstatus'] == 1 ? 'Aktif':'Pasif' }}</span></td>
                            <td class="text-center align-middle">{{ $task['tqueque'] }}</td>
                            <td class="text-center align-middle">{{ beSpecialTime($task['tlastruntime'],' H:i') }}</td>
                            <td class="text-center align-middle">{{ beSpecialTime($task['tnextruntime'],' H:i') }}</td>
                            <td class="text-center align-middle">{{ beSpecialTime($task['tdateline']) }}</td>
                            <td class="text-center align-middle">
                                <a data-bs-toggle="tooltip" title="Düzenle" href="{{ beGetRoute('admin.task.edit',['tid' => $task['tid']]) }}" class="btn btn-primary">Düzenle</a>
                                <a data-bs-toggle="tooltip" title="Durumu Düzenle" class="btn btn-warning btnStatus" data-tid="{{ $task['tid'] }}">
                                    <i class="fonticon-equalizer fs-4 me-1"></i>
                                </a>
                                <a data-bs-toggle="tooltip" title="Sil" class="btn btn-danger btnDelete" data-tid="{{ $task['tid'] }}">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor"><path fill="none" d="M0 0h24v24H0z"/><path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"/></svg>
                                </a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    $(".btnStatus").on("click",function(){
        var tid = $(this).data("tid");
        $.ajax({
            url: "{{ beGetRoute('admin.task.status.post') }}",
            type: "post",
            data: {tid:tid},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#"+tid+"Status").html(response.html);
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });	
        return false;
    });
    $(".btnDelete").on("click",function(){
        var tid = $(this).data("tid");
        Swal.fire({
            html: "Bu işlem sonucunda görev kalıcı olarak silinecektir işlemi onaylıyor musunuz?",
            icon: "info",
            buttonsStyling: false,
            showCancelButton: true,
            confirmButtonText: "Onaylıyorum",
            cancelButtonText: "Vazgeçtim",
            customClass: {
                confirmButton: "btn btn-primary",
                cancelButton: "btn btn-danger"
            }
        }).then((result) => {
            if(result.isConfirmed) {
                $.ajax({
                    url: "{{ beGetRoute('admin.task.delete.post') }}",
                    type: "post",
                    data: {tid:tid},
                    dataType: "json",
                    crossDomain: true,
                    success: function(response){
                        if(response.status){
                            $("#"+tid+"Row").remove();
                            Swal.fire("Başarılı",response.message,"success");
                        }
                        else{
                            Swal.fire("Bir Hata Oluştu",response.message,"error");
                        }
                    }
                });	
            }
        });
        return false;
    });
</script>
@endsection
