@extend('admin.layout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="d-flex justify-content-end">
            <a href="{{ beGetRoute('admin.invoice.add') }}" class="d-inline-flex align-items-center btn btn-primary mb-5 mx-3">
                <span class="svg-icon svg-icon-muted d-flex align-items-center">
                    <svg width="23" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"/>
                        <rect x="10.8891" y="17.8033" width="12" height="2" rx="1" transform="rotate(-90 10.8891 17.8033)" fill="currentColor"/>
                        <rect x="6.01041" y="10.9247" width="12" height="2" rx="1" fill="currentColor"/>
                    </svg>
                </span>
                Yeni Fatura Oluştur
            </a>
        </div>
        <div class="card mb-4">
            <div class="card-body">
                <div class="row">
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Fatura Adı</label>
                        <input type="text" class="form-control" id="searchInvoiceName" placeholder="Aramak istediğiniz faturanın adını giriniz">
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Durum</label>
                        <select class="form-control form-control-select" id="searchInvoiceStatus">
                            <option value="-2">Hepsi</option>
                            <option value="1">Ödenmiş</option>
                            <option value="0">Beklemede</option>
                            <option value="-1">İptal Edilmiş</option>
                        </select>
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Fatura Tipi</label>
                        <select class="form-control form-control-select" id="searchInvoiceType">
                            <option value="-1">Seçiniz</option>
                            <option value="4">Özel Fatura</option>
                            <option value="3">Bakiye Yükleme Faturası</option>
                            <option value="2">Sipariş Uzatım Faturası</option>
                            <option value="1">Sipariş Faturası</option>
                        </select>
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Fatura Durumu</label>
                        <select class="form-control form-control-select" id="searchInvoiceBill">
                            <option value="-1">Seçiniz</option>
                            <option value="1">Fatura Kesilmiş</option>
                            <option value="0">Fatura Kesilmemiş</option>
                        </select>
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Fatura Sahibi</label>
                        <input type="text" class="form-control" id="searchInvoiceUser" placeholder="Aramak istediğiniz kişinin adını soyadını adresini giriniz">
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Sıralama Tipi</label>
                        <select class="form-control form-control-select" id="searchInvoiceOrderType">
                            <option value="iid">Fatura Numarası</option>
                            <option value="ipaydate">Ödenme Tarihi</option>
                            <option value="iprice">Ödenme Tutarı</option>
                        </select>
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Sıralama Türü</label>
                        <select class="form-control form-control-select" id="searchInvoiceSort">
                            <option value="1">Sondan Başa</option>
                            <option value="2">Baştan Sona</option>
                        </select>
                    </div>
                    <div class="col-12 d-flex justify-content-center mt-5">
                        <a data-bs-toggle="tooltip" href="#" class="btn btnFind btn-primary mx-2">
                            <i class="fonticon-equalizer fs-4 me-1"></i>
                            Ara
                        </a>
                        <a data-bs-toggle="tooltip" href="#" class="btn btnFindEmpty btn-warning mx-2">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor"><path fill="none" d="M0 0h24v24H0z"></path><path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"></path></svg>
                            Temizle
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="alert alert-warning d-flex align-items-center p-5">
            <span class="svg-icon svg-icon-2hx svg-icon-warning me-4">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect opacity="0.5" x="13" y="6" width="13" height="2" rx="1" transform="rotate(90 13 6)" fill="currentColor"></rect>
                    <path d="M12.5657 8.56569L16.75 12.75C17.1642 13.1642 17.8358 13.1642 18.25 12.75C18.6642 12.3358 18.6642 11.6642 18.25 11.25L12.7071 5.70711C12.3166 5.31658 11.6834 5.31658 11.2929 5.70711L5.75 11.25C5.33579 11.6642 5.33579 12.3358 5.75 12.75C6.16421 13.1642 6.83579 13.1642 7.25 12.75L11.4343 8.56569C11.7467 8.25327 12.2533 8.25327 12.5657 8.56569Z" fill="currentColor"></path>
                </svg>
            </span>
            <div class="d-flex flex-column">
                <h4 class="mb-1 text-warning">Toplam Fatura Adedi</h4>
                <span id="invoiceCount"></span>
            </div>
        </div>
        <div class="card mb-4">
            <div class="table-responsive">
                <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                    <thead>
                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                            <th class="text-center align-middle">#</th>
                            <th class="text-center align-middle">Sahip</th>
                            <th class="text-center align-middle">Açıklama</th>
                            <th class="text-center align-middle">Durum</th>
                            <th class="text-center align-middle">Fatura Tipi</th>
                            <th class="text-center align-middle">Fatura Durumu</th>
                            <th class="text-center align-middle">Tutar</th>
                            <th class="text-center align-middle">KDV</th>
                            <th class="text-center align-middle">İndirim</th>
                            <th class="text-center align-middle">Toplam</th>
                            <th class="text-center align-middle">Ödenme Methodu</th>
                            <th class="text-center align-middle">Bitiş Tarihi</th>
                            <th class="text-center align-middle">Oluşturulma Tarihi</th>
                            <th class="text-center align-middle">Düzenle</th>
                        </tr>
                    </thead>
                    <tbody id="invoiceList">

                    </tbody>
                </table>
            </div>
        </div>
        <div class="card mb-4">
            <div class="card-body">
                <div class="row" id="paganation">
                    
                </div>
            </div>
        </div>
        <div class="card mb-4">
            <div class="card-header">
                <div class="card-title">
                    Toplu İşlemler
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-12 mb-9">
                        <label class="fs-6 fw-semibold mb-2 d-block">Aksiyon Etkileşimi</label>
                        <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Onaylanan faturalar eğer aksiyona bağlıysa işlemi gerçekleştir.</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" role="switch" id="invoiceTotalOnContent">
                        </div>
                    </div>
                    <div class="col-12 mb-9">
                        <label class="fs-6 fw-semibold mb-2 d-block">Muhasebe Etkileşimi</label>
                        <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Onaylanan faturaların tutarlarını muhasebeye girdi olarak ekle.</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" role="switch" id="invoiceTotalOnAccounting">
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <a href="#" class="btn btn-primary beActionInvoiceAll" data-status="1">Toplu Onayla</a>
                <a href="#" class="btn btn-info beActionInvoiceAll" data-status="0">Toplu Beklemeye Al</a>
                <a href="#" class="btn btn-danger beActionInvoiceAll" data-status="-1">Toplu İptal Et</a>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    $(".form-control-select").select2();
    $(".beActionInvoiceAll").on("click",function(){
        var status = parseInt($(this).data("status"));
        var iids = [];
        $(".beInvoiceCheckbox").each(function(index){
            if($(this).is(":checked")){
                iids.push($(this).data("iid"))
            }
        });
        var oncontent = $("#invoiceTotalOnContent").is(":checked") == true ? 1:0
        var onaccounting = $("#invoiceTotalOnAccounting").is(":checked") == true ? 1:0
        $.ajax({
            url: "{{ beGetRoute('admin.invoice.status.save.post') }}",
            type: "post",
            async: true,
            data: {iids:iids,status:status,oncontent:oncontent,onaccounting:onaccounting},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                wait1 = false;
                if(response.status){
                    Swal.fire("Başarılı",response.message,"success");
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
        return false;
    });
    var page = 1;
    $("#invoiceList").on("click",".btnDelete",function(){
        var iid = $(this).data("iid");
        Swal.fire({
            html: "Bu faturayı silmek istediğinize emin misiniz ?",
            icon: "info",
            buttonsStyling: false,
            showCancelButton: true,
            confirmButtonText: "Onaylıyorum",
            cancelButtonText: "Vazgeçtim",
            customClass: {
                confirmButton: "btn btn-primary",
                cancelButton: "btn btn-danger"
            }
        }).then((result) => {
            if(result.isConfirmed) {
                $.ajax({
                    url: "{{ beGetRoute('admin.invoice.delete.post') }}",
                    type: "post",
                    data: {iid:iid},
                    dataType: "json",
                    crossDomain: true,
                    success: function(response){
                        if(response.status){
                            $("#"+iid+"Row").remove();
                            Swal.fire("Başarılı",response.message,"success");
            
                        }
                        else{
                            Swal.fire("Bir Hata Oluştu",response.message,"error");
                        }
                    }
                });	
            }
        });
        return false;
    });
    $(".btnFind").on("click",function(){
        var name = $("#searchInvoiceName").val();
        var status = $("#searchInvoiceStatus").val();
        if(status < 0 || status > 2){
            status = -2;
        }
        var type = $("#searchInvoiceType").val();
        if(!type){
            type = -1;
        }
        var bill = $("#searchInvoiceBill").val();
        if(!bill){
            bill = -1;
        }
        var user = $("#searchInvoiceUser").val();
        var ordertype = $("#searchInvoiceOrderType").val();
        var sort = $("#searchInvoiceSort").val();
        if(!sort){
            sort = 0;
        }
        beSearchInvoice(name,status,type,bill,user,sort,ordertype);
        return false;
    });
    $(".btnFindEmpty").on("click",function(){
        $("#searchInvoiceName").val("");
        $("#searchInvoiceStatus option:first").attr("selected","selected");
        $("#searchInvoiceType option:first").attr("selected","selected");
        $("#searchInvoiceBill option:first").attr("selected","selected");
        $("#searchInvoiceUser").val("");
        $("#searchInvoiceSort option:first").attr("selected","selected");
        $("#searchInvoiceOrderType option:first").attr("selected","selected");
        beSearchInvoice("",-2,-1,-1,"",0,"iid");
        return false;
    });
    $("#paganation").on("click",".goPaganation",function(){
        page = parseInt($(this).data("page"));
        $(".btnFind").trigger("click");
        return false;
    });
    $(document).ready(function(){
        beSearchInvoice("",-2,-1,-1,"",0,"iid");
    });
    function beSearchInvoice(name,status,type,bill,user,sort,ordertype){
        $.ajax({
            url: "{{ beGetRoute('admin.invoice.search.post') }}",
            type: "post",
            data: {name:name,status:status,type:type,bill:bill,username:user,sort:sort,ordertype:ordertype,page:page},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#paganation").empty().append(response.paganation);
                    $("#invoiceList").empty().append(response.html);
                    $("#invoiceCount").empty().append(response.invoicecount+" Adet");
                    $(".form-control-select").select2();
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
    }
</script>
@endsection