@extend('admin.layout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="d-flex justify-content-end">
            <a href="{{ beGetRoute('admin.coupon.add') }}" class="d-inline-flex align-items-center btn btn-primary mb-5 mx-3">
                <span class="svg-icon svg-icon-muted d-flex align-items-center">
                    <svg width="23" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"/>
                        <rect x="10.8891" y="17.8033" width="12" height="2" rx="1" transform="rotate(-90 10.8891 17.8033)" fill="currentColor"/>
                        <rect x="6.01041" y="10.9247" width="12" height="2" rx="1" fill="currentColor"/>
                    </svg>
                </span>
                Yeni Kupon Oluştur
            </a>
        </div>
        <div class="card mb-4">
            <div class="card-body">
                <div class="row">
                    <div class="col-1">
                        <label class="fs-6 fw-semibold mb-2">Kupon Adı</label>
                        <input type="text" class="form-control" id="searchCouponName">
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Kupon Kodu</label>
                        <input type="text" class="form-control" id="searchCouponCode">
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Kupon Sahibi</label>
                        <input type="text" class="form-control" id="searchCouponUser" placeholder="Aramak istediğiniz kişinin adını soyadını adresini giriniz">
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Dil</label>
                        <select class="form-control form-control-select" id="searchCouponLanguage">
                            <option value="0">Seçiniz</option>
                            @foreach($languages as $language)
                                <option value="{{ $language['lid'] }}">{{ $language['lname'] }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-1">
                        <label class="fs-6 fw-semibold mb-2">Durum</label>
                        <select class="form-control form-control-select" id="searchCouponStatus">
                            <option value="-2">Hepsi</option>
                            <option value="1">Aktif</option>
                            <option value="0">Süresi Geçmiş</option>
                            <option value="-1">İptal Edilmiş</option>
                        </select>
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Sıralama Tipi</label>
                        <select class="form-control form-control-select" id="searchCouponOrderType">
                            <option value="cid">Oluşturulma Tarihi</option>
                            <option value="use">Kullanım Adeti</option>
                        </select>
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Sıralama Türü</label>
                        <select class="form-control form-control-select" id="searchCouponSort">
                            <option value="1">Sondan Başa</option>
                            <option value="2">Baştan Sona</option>
                        </select>
                    </div>
                    <div class="col-12 d-flex justify-content-center mt-5">
                        <a data-bs-toggle="tooltip" href="#" class="btn btnFind btn-primary mx-2">
                            <i class="fonticon-equalizer fs-4 me-1"></i>
                            Ara
                        </a>
                        <a data-bs-toggle="tooltip" href="#" class="btn btnFindEmpty btn-warning mx-2">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor"><path fill="none" d="M0 0h24v24H0z"></path><path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"></path></svg>
                            Temizle
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="alert alert-warning d-flex align-items-center p-5">
            <span class="svg-icon svg-icon-2hx svg-icon-warning me-4">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect opacity="0.5" x="13" y="6" width="13" height="2" rx="1" transform="rotate(90 13 6)" fill="currentColor"></rect>
                    <path d="M12.5657 8.56569L16.75 12.75C17.1642 13.1642 17.8358 13.1642 18.25 12.75C18.6642 12.3358 18.6642 11.6642 18.25 11.25L12.7071 5.70711C12.3166 5.31658 11.6834 5.31658 11.2929 5.70711L5.75 11.25C5.33579 11.6642 5.33579 12.3358 5.75 12.75C6.16421 13.1642 6.83579 13.1642 7.25 12.75L11.4343 8.56569C11.7467 8.25327 12.2533 8.25327 12.5657 8.56569Z" fill="currentColor"></path>
                </svg>
            </span>
            <div class="d-flex flex-column">
                <h4 class="mb-1 text-warning">Toplam Kupon Adedi</h4>
                <span id="couponCount"></span>
            </div>
        </div>
        <div class="card mb-4">
            <div class="table-responsive">
                <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                    <thead>
                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                            <th class="text-center align-middle">#</th>
                            <th class="text-center align-middle">Sahip</th>
                            <th class="text-center align-middle">Kupon Adı</th>
                            <th class="text-center align-middle">Kupon Kodu</th>
                            <th class="text-center align-middle">İndirim Türü</th>
                            <th class="text-center align-middle">Durum</th>
                            <th class="text-center align-middle">Tutar</th>
                            <th class="text-center align-middle">Ürünler</th>
                            <th class="text-center align-middle">Aralık</th>
                            <th class="text-center align-middle">Gerekli Adet</th>
                            <th class="text-center align-middle">Kullanım/Limit</th>
                            <th class="text-center align-middle">Bitiş Tarihi</th>
                            <th class="text-center align-middle">Oluşturulma Tarihi</th>
                            <th class="text-center align-middle"></th>
                        </tr>
                    </thead>
                    <tbody id="couponList">

                    </tbody>
                </table>
            </div>
        </div>
        <div class="card mb-4">
            <div class="card-body">
                <div class="row" id="paganation">
                    
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    $(".form-control-select").select2();
    var page = 1;
    $("#orderList").on("click",".btnStatus",function(){
        var iid = $(this).data("iid");
        $.ajax({
            url: "{{ beGetRoute('client.ipaddress.status.post') }}",
            type: "post",
            data: {iid:iid},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#"+iid+"Status").html(response.html);
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });	
        return false;
    });
    $("#couponList").on("click",".btnDelete",function(){
        var cpid = $(this).data("cpid");
        Swal.fire({
            html: "Bu kuponu silmek istediğinize emin misiniz ?",
            icon: "info",
            buttonsStyling: false,
            showCancelButton: true,
            confirmButtonText: "Onaylıyorum",
            cancelButtonText: "Vazgeçtim",
            customClass: {
                confirmButton: "btn btn-primary",
                cancelButton: "btn btn-danger"
            }
        }).then((result) => {
            if(result.isConfirmed) {
                $.ajax({
                    url: "{{ beGetRoute('admin.coupon.delete.post') }}",
                    type: "post",
                    data: {cpid:cpid},
                    dataType: "json",
                    crossDomain: true,
                    success: function(response){
                        if(response.status){
                            $("#"+cpid+"Row").remove();
                            Swal.fire("Başarılı",response.message,"success");
            
                        }
                        else{
                            Swal.fire("Bir Hata Oluştu",response.message,"error");
                        }
                    }
                });	
            }
        });
        return false;
    });
    $(".btnFind").on("click",function(){
        var name = $("#searchCouponName").val();
        var code = $("#searchCouponCode").val();
        var username = $("#searchCouponUser").val();
        var language = $("#searchCouponLanguage").val();
        var status = $("#searchCouponStatus").val();
        if(status < 0 || status > 2){
            status = -2;
        }
        var ordertype = $("#searchCouponOrderType").val();
        var sort = $("#searchCouponSort").val();
        if(!sort){
            sort = 0;
        }
        beSearchCoupon(name,code,username,language,status,sort,ordertype);
        return false;
    });
    $(".btnFindEmpty").on("click",function(){
        $("#searchCouponName").val("");
        $("#searchCouponCode").val("");
        $("#searchCouponUser").val("");
        $("#searchCouponLanguage option:first").attr("selected","selected");
        $("#searchCouponStatus option:first").attr("selected","selected");
        $("#searchCouponSort option:first").attr("selected","selected");
        $("#searchCouponOrderType option:first").attr("selected","selected");
        beSearchCoupon("","","",0,-2,0,"cid");
        return false;
    });
    $("#paganation").on("click",".goPaganation",function(){
        page = parseInt($(this).data("page"));
        $(".btnFind").trigger("click");
        return false;
    });
    $(document).ready(function(){
        beSearchCoupon("","","",0,-2,0,"cid");
    });
    function beSearchCoupon(name,code,username,language,status,sort,ordertype){
        $.ajax({
            url: "{{ beGetRoute('admin.coupon.search.post') }}",
            type: "post",
            data: {name:name,code:code,username:username,language:language,status:status,sort:sort,ordertype:ordertype,page:page},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#paganation").empty().append(response.paganation);
                    $("#couponList").empty().append(response.html);
                    $("#couponCount").empty().append(response.itemcount+" Adet");
                    $(".form-control-select").select2();
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
    }
</script>
@endsection