@extend('admin.layout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Kupon Düzenle
                </div>
            </div>
            <div class="card-body">
                <form id="couponForm">
                    <div class="row">
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kupon Sahibi</label>
                            <select class="form-control form-control-select-user" name="user">
                                <option value="{{ $coupon['uid'] }}">{{ $coupon['usersearch'] }}</option>
                            </select>
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Dil</label>
                            <select class="form-control form-control-select" name="language">
                                <option value="0"{{ $coupon['lid'] == 0 ? ' selected':'' }}>Tüm Ülkeler</option>
                                @foreach($languages as $language)
                                    <option value="{{ $language['lid'] }}"{{ $coupon['lid'] == $language['lid'] ? ' selected':'' }}>{{ $language['lname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Para Birimi</label>
                            <select class="form-control form-control-select" name="currency">
                                @foreach($currencies as $currency)
                                <option value="{{ $currency['cid'] }}"{{ $coupon['cid'] == $currency['cid'] ? ' selected':'' }}>{{ $currency['cname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kupon Adı</label>
                            <input type="text" class="form-control" name="name" value="{{ $coupon['cname'] }}">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kupon Kodu</label>
                            <input type="text" class="form-control" name="code" value="{{ $coupon['ccode'] }}">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">İndirim Tipi</label>
                            <select class="form-control form-control-select" name="discounttype">
                                <option value="1"{{ $coupon['cdiscounttype'] == 1 ? ' selected':'' }}>Yüzde İndirim</option>
                                <option value="2"{{ $coupon['cdiscounttype'] == 2 ? ' selected':'' }}>Sabit İndirim</option>
                            </select>
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Tutar</label>
                            <input type="text" class="form-control" name="discount" value="{{ $coupon['cdiscount'] }}">
                        </div>

                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Minimum Fiyat</label>
                            <input type="text" class="form-control" name="minprice" value="{{ $coupon['cminprice'] }}">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Maximum Fiyat</label>
                            <input type="text" class="form-control" name="maxprice" value="{{ $coupon['cmaxprice'] }}">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Sepette Kaç Ürün Olabilir</label>
                            <input type="text" class="form-control" name="itemcount" value="{{ $coupon['citemcount'] }}">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kupon Kullanım Limiti(Toplam)</label>
                            <input type="text" class="form-control" name="limit" value="{{ $coupon['climit'] }}">
                        </div>
                        <div class="col-6 mb-9">
                            @php $couponproducts = json_decode($coupon['cproducts'],true) @endphp
                            <label class="fs-6 fw-semibold mb-2">Kullanılabilicek Ürünler</label>
                            <select class="form-control form-control-select" name="products[]" multiple>
                                <option value="0"{{ empty($couponproducts) ? ' selected':'' }}>Tüm Ürünler</option>
                                @foreach($products as $product)
                                <option value="{{ $product['pid'] }}"{{ in_array($product['pid'],$couponproducts) ? ' selected':'' }}>{{ $product['pname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Bitiş Tarihi</label>
                            <input type="datetime-local" class="form-control" name="enddateline" value="{{ date('Y-m-d\TH:i',$coupon['cenddateline']) }}">
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto editCoupon">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    $(".form-control-select").select2();
    $(".form-control-select-user").select2({
        placeholder: "Lütfen aramak istediğiniz kullanıcının isim yada soyisimini giriniz",
        minimumInputLength: 2,
        tags: false,
        ajax: {
            url: "{{ beGetRoute('admin.user.find.post') }}",
            dataType: "json",
            type: "post",
            quietMillis: 50,
            data: function (term) {
                return term;
            },
            processResults: function (data){
                return {
                    results: $.map(data, function (item) {
                        return {
                            text: item.namesurname,
                            id: item.uid
                        }
                    })
                };
            },
            cache: true
        }
    });
    var wait = false;
    $(".editCoupon").on("click",function(){
        if(!wait){
            $(".editCoupon").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.coupon.edit.post') }}",
                type: "post",
                async: true,
                data: $("#couponForm").serialize()+"&cpid={{ $coupon['cpid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    if(response.status){
                        $(".editCoupon").html('Kaydet');
                        Swal.fire("Başarılı",response.message,"success");
                        setTimeout(function(){
                            location.reload();
                        },1000)
                    }
                    else{
                        $(".editCoupon").html('Kaydet');
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                        wait = false;
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection