@extend('admin.layout')
@section('headerinclude')
<style>
.tabs .tab {
    display: none;
}
.tabs .tab.active {
    display: block;
}
</style>
@endsection
@section('content')
<link href="assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css"/>
<script src="assets/plugins/global/plugins.bundle.js"></script>
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="tabs">
            <div class="tab active">
                <div class="row g-5 g-xl-12 mb-7">
                    <div class="col-xl-12">
                        <div class="card mb-7">
                            <div class="card-header">
                                <div class="card-title mt-5 d-block mb-0">
                                    <div class="d-block">
                                        Ürün Eklentileri
                                    </div>
                                    <ul class="nav nav-stretch nav-line-tabs nav-line-tabs-2x border-transparent fs-5 fw-bold">
                                        @foreach($languages as $language)
                                        <li class="nav-item mt-2">
                                            <a class="nav-link nav-language text-active-primary ms-0 me-10 py-5 {{ $language['lid'] == $systemlid ? 'active':'' }}" href="#" data-lang="{{ $language['lid'] }}">{{ $language['lname'] }}</a>
                                        </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                            <div class="card-body">
                                <form id="infoForm">
                                    <div class="row">
                                        <div class="col-4 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Eklenti Grubu</label>
                                            <select class="form-control form-control-select" name="pagid">
                                                <option value="0">Yok</option>    
                                                @foreach($productaddongroups as $productaddongroup)
                                                <option value="{{ $productaddongroup['pagid'] }}"{{ $productaddongroup['pagid'] == $productaddon['pagid'] ? ' selected':'' }}>{{ $productaddongroup['pagname'] }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    @php $lastkeys = []; @endphp
                                    @foreach($languages as $language)
                                    @foreach($productaddontranslations as $productaddontranslation)
                                    @php
                                        if($productaddontranslation['lid'] != $language['lid']){
                                            continue;
                                        }
                                        break;
                                    @endphp
                                    @endforeach
                                    <div class="row languageTab {{ $language['lid'] == $systemlid ? 'd-flex':'d-none' }} languageTab{{ $language['lid'] }}">
                                        <div class="col-6 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Eklenti Adı</label>
                                            <input type="text" class="form-control" name="paname[{{ $language['lid'] }}]" value="{{ $productaddontranslation['paname'] }}">
                                        </div>
                                        <div class="col-6 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Eklenti Kodu</label>
                                            <input type="text" class="form-control" name="pacode[{{ $language['lid'] }}]" value="{{ $productaddontranslation['pacode'] }}" placeholder="Bu alan kullandığınız modül tarafından erişip verilerin işlenmesini sağlar!">
                                        </div>
                                        <div class="col-4 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Eklenti Sırası</label>
                                            <input type="number" class="form-control" name="paposition[{{ $language['lid'] }}]" value="{{ $productaddontranslation['paposition'] }}">
                                        </div>
                                        <div class="col-4 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Seçenek Türü</label>
                                            <select class="form-control form-control-select" name="patype[{{ $language['lid'] }}]">
                                                <option value="1"{{ $productaddontranslation['patype'] == '1' ? ' selected':'' }}>Aktif</option>
                                                <option value="0"{{ $productaddontranslation['patype'] == '0' ? ' selected':'' }}>Pasif</option>
                                            </select>
                                        </div>
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Açıklama</label>
                                            <textarea class="form-control" name="padescription[{{ $language['lid'] }}]" rows="2">{{ $productaddontranslation['padescription'] }}</textarea>
                                        </div>
                                        <div class="col-6 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Durum</label>
                                            <div class="form-check form-check-custom form-check-solid">
                                                <input class="form-check-input" type="hidden" value="0" name="pastatus[{{ $language['lid'] }}]">
                                                <input class="form-check-input" type="checkbox" value="1" name="pastatus[{{ $language['lid'] }}]" id="pastatus{{ $productaddontranslation['patid'] }}"{{ $productaddontranslation['pastatus'] == 1 ? ' checked':'' }}>
                                                <label class="form-check-label" for="pastatus{{ $productaddontranslation['patid'] }}">
                                                    Bu eklentinin aktif olması için seçiniz.
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-6 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Zorunluluk</label>
                                            <div class="form-check form-check-custom form-check-solid">
                                                <input class="form-check-input" type="hidden" value="0" name="pacompulsory[{{ $language['lid'] }}]">
                                                <input class="form-check-input" type="checkbox" value="1" name="pacompulsory[{{ $language['lid'] }}]" id="pacompulsory{{ $productaddontranslation['patid'] }}"{{ $productaddontranslation['pacompulsory'] == 1 ? ' checked':'' }}>
                                                <label class="form-check-label" for="pacompulsory{{ $productaddontranslation['patid'] }}">
                                                    Satın alım esnasında bu eklentinin seçilmesi zorunlu olur.
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-6 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Para Birimi</label>
                                            <div class="form-check form-check-custom form-check-solid">
                                                <input class="form-check-input" type="hidden" value="0" name="paovveridecurrency[{{ $language['lid'] }}]">
                                                <input class="form-check-input" type="checkbox" value="1" name="paovveridecurrency[{{ $language['lid'] }}]" id="paovveridecurrency{{ $productaddontranslation['patid'] }}"{{ $productaddontranslation['paovveridecurrency'] == 1 ? ' checked':'' }}>
                                                <label class="form-check-label" for="paovveridecurrency{{ $productaddontranslation['patid'] }}">
                                                    Müşterinin para birimini geçersiz kıl(sipariş özetinde tutar çevirilerek gösterilir).
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-6 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Periyot Eşleştirmesi</label>
                                            <div class="form-check form-check-custom form-check-solid">
                                                <input class="form-check-input" type="hidden" value="0" name="pamatchperiod[{{ $language['lid'] }}]">
                                                <input class="form-check-input" type="checkbox" value="1" name="pamatchperiod[{{ $language['lid'] }}]" id="pamatchperiod{{ $productaddontranslation['patid'] }}"{{ $productaddontranslation['pamatchperiod'] == 1 ? ' checked':'' }}>
                                                <label class="form-check-label" for="pamatchperiod{{ $productaddontranslation['patid'] }}">
                                                    Ürün periyodu değiştirildiğinde eklentinin periyodunu da değiştir.
                                                </label>
                                            </div>
                                        </div>
                                        <div class="row mb-9">
                                            <div class="col-12">
                                                <label class="fs-6 fw-semibold mb-2">Seçenek Türü</label>
                                            </div>
                                            <div class="col-2">
                                                <div class="form-check form-check-custom form-check-solid">
                                                    <input class="form-check-input" type="radio" value="select" name="patype[{{ $language['lid'] }}]"{{ $productaddontranslation['patype'] == 'select' ? ' checked':'' }}/>
                                                    <div class="form-check-label">
                                                        Seçenek Listesi
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-2">
                                                <div class="form-check form-check-custom form-check-solid">
                                                    <input class="form-check-input" type="radio" value="radio" name="patype[{{ $language['lid'] }}]"{{ $productaddontranslation['patype'] == 'radio' ? ' checked':'' }}/>
                                                    <div class="form-check-label">
                                                        Tekli Seçim
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-2">
                                                <div class="form-check form-check-custom form-check-solid">
                                                    <input class="form-check-input" type="radio" value="range" name="patype[{{ $language['lid'] }}]"{{ $productaddontranslation['patype'] == 'quanity' ? ' checked':'' }}/>
                                                    <div class="form-check-label">
                                                        Miktarlı Seçenek
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row col-12 dragable-zone beItemArea" id="itemArea{{ $language['lid'] }}" data-lid="{{ $language['lid'] }}">
                                            @php 
                                                $paoptions = json_decode($productaddontranslation['paoptions'],true); 
                                            @endphp
                                            @foreach($paoptions as $key => $value)
                                            <div class="col-12 mb-9 dragable" id="row{{ $language['lid'] }}-{{ $key }}" data-key="{{ $key }}" data-lang="{{ $language['lid'] }}">
                                                <div class="row">
                                                    <div class="col-md-1">
                                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Sıralama</label>
                                                        <a href="#" class="btn btn-icon btn-sm btn-hover-light-primary draggable-handle">
                                                            <span class="svg-icon svg-icon-2x">
                                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <path d="M21 7H3C2.4 7 2 6.6 2 6V4C2 3.4 2.4 3 3 3H21C21.6 3 22 3.4 22 4V6C22 6.6 21.6 7 21 7Z" fill="currentColor"></path>
                                                                    <path opacity="0.3" d="M21 14H3C2.4 14 2 13.6 2 13V11C2 10.4 2.4 10 3 10H21C21.6 10 22 10.4 22 11V13C22 13.6 21.6 14 21 14ZM22 20V18C22 17.4 21.6 17 21 17H3C2.4 17 2 17.4 2 18V20C2 20.6 2.4 21 3 21H21C21.6 21 22 20.6 22 20Z" fill="currentColor"></path>
                                                                </svg>
                                                            </span>
                                                        </a>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Ad</label>
                                                        <input type="text" class="form-control" id="rowName{{ $language['lid'] }}-{{ $key }}" value="{{ $value['oname'] }}">
                                                    </div>
                                                    <div class="col-md-1">
                                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Süre</label>
                                                        <input type="text" class="form-control" id="rowTime{{ $language['lid'] }}-{{ $key }}" value="{{ $value['operiodtime'] }}">
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Süre Tipi</label>
                                                        <select class="form-control form-control-select" id="rowTimeType{{ $language['lid'] }}-{{ $key }}">
                                                            @foreach($periods as $pkey => $pval)
                                                            <option value="{{ $pkey }}"{{ $pkey == $value['operiod'] ? ' selected':'' }}>{{ $pval }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Fiyat</label>
                                                        <input type="text" class="form-control" id="rowPrice{{ $language['lid'] }}-{{ $key }}" value="{{ $value['oprice'] }}">
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Birim</label>
                                                        <select class="form-control form-control-select" id="rowCurrency{{ $language['lid'] }}-{{ $key }}">
                                                            @foreach($currencies as $currency)
                                                            <option value="{{ $currency['cid'] }}"{{ $currency['cid'] == $value['ocid'] ? ' selected':'' }}>{{ $currency['cname'] }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">İşlemler</label>
                                                        <div class="mt-1">
                                                            <span data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-original-title="Edit customer details" data-kt-initialized="1">
                                                                <a href="#" class="btn btn-sm btn-light-primary" data-bs-toggle="modal" data-bs-target="#beUpdateModule{{ $language['lid'] }}-{{ $key }}">
                                                                    <i class="fa-solid fa-gears"></i>
                                                                    Düzenle
                                                                </a>
                                                            </span>
                                                            <a data-bs-toggle="tooltip" title="Sil" class="btn btn-danger btnDeleteRow" data-key="{{ $language['lid'] }}-{{ $key }}">
                                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor">
                                                                    <path fill="none" d="M0 0h24v24H0z"/>
                                                                    <path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"/>
                                                                </svg>
                                                                Sil
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @php 
                                            if($key > $lastkeys[$language['lid']]){
                                                $lastkeys[$language['lid']] = $key+1; 
                                            }
                                            @endphp
                                            @endforeach
                                        </div>
                                        <div class="col-12 d-flex align-items-center">
                                            <button class="btn btn-success d-block m-auto addonAddForm">Yeni Satır Ekle</button>
                                            <button class="btn btn-success d-block m-auto addonSaveForm">Kaydet</button>
                                        </div>
                                    </div>
                                    @endforeach
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @foreach($languages as $language)
        @foreach($productaddontranslations as $productaddontranslation)
        @php
            if($productaddontranslation['lid'] != $language['lid']){
                continue;
            }
            break;
        @endphp       
        @endforeach    
        @php 
        $paoptions = json_decode($productaddontranslation['paoptions'],true); 
        @endphp
        @foreach($paoptions as $key => $value)                         
        <div class="modal fade" id="beUpdateModule{{ $language['lid'] }}-{{ $key }}" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" style="width:50%;max-width:none;">
                <div class="modal-content">
                    <form class="form" id="addonModuleForm{{ $language['lid'] }}-{{ $key }}">
                        <input type="hidden" name="item" value="{{ $productaddontranslation['patid'] }}-{{ $key }}">
                        <div class="modal-header">
                            <h2 class="fw-bold">Modül Verilerini Düzenle</h2>
                            <div class="btn btn-icon btn-sm btn-active-icon-primary" data-kt-users-modal-action="close">
                                <span class="svg-icon svg-icon-1">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="currentColor"/>
                                        <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="currentColor"/>
                                    </svg>
                                </span>
                            </div>
                        </div>
                        <div class="modal-body py-10 px-lg-17">
                            @foreach($moduleaddons as $modulename => $data)
                            <div class="d-flex flex-column scroll-y me-n7 pe-7">
                                <div class="fw-bolder fs-3 rotate mb-7 beShowContent" data-contentid="{{ $key }}-{{ $modulename }}">
                                    {{ $data['info']['name'] }}
                                    <span class="ms-2 rotate-180">
                                        <span class="svg-icon svg-icon-3">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M11.4343 12.7344L7.25 8.55005C6.83579 8.13583 6.16421 8.13584 5.75 8.55005C5.33579 8.96426 5.33579 9.63583 5.75 10.05L11.2929 15.5929C11.6834 15.9835 12.3166 15.9835 12.7071 15.5929L18.25 10.05C18.6642 9.63584 18.6642 8.96426 18.25 8.55005C17.8358 8.13584 17.1642 8.13584 16.75 8.55005L12.5657 12.7344C12.2533 13.0468 11.7467 13.0468 11.4343 12.7344Z" fill="currentColor"/>
                                            </svg>
                                        </span>
                                    </span>
                                </div>
                                <div class="row mb-9" style="display: none;" id="beContent-{{ $key }}-{{ $modulename }}">
                                    @foreach($data['addonconfigs'] as $modulekey => $moduledata)
                                    <div class="{{ $moduledata['form-view']['class'] ?? 'col-12' }} mb-9">
                                        <label class="fs-6 fw-semibold mb-1 text-gray-500">{{ $moduledata['name'] }}</label>
                                        <label class="fs-8 fw-semibold mb-2 text-gray-400 d-block">{{ $moduledata['description'] }}</label>
                                        @php $itemvalue = null; @endphp
                                        @foreach($productaddonmodules as $productaddonmodule)
                                            @php
                                                if($productaddontranslation['patid'] == $productaddonmodule['patid'] && $productaddonmodule['pamodule'] == $modulename && $productaddonmodule['pamodulekey'] == $modulekey && $productaddonmodule['pakey'] == $key){
                                                    $itemvalue = $productaddonmodule['pavalue'];
                                                }
                                            @endphp
                                        @endforeach
                                        @if(in_array($moduledata['type'],['integer','float','string','date']))
                                        <input type="text" class="form-control" name="moduledata[{{ $modulename }}][{{ $modulekey }}]" value="{{ $itemvalue }}">
                                        @endif
                                        @if($moduledata['type'] == 'select')
                                        <select class="form-control form-control-select" name="moduledata[{{ $modulename }}][{{ $modulekey }}]">
                                            @foreach($moduledata['values'] as $altkey => $value)
                                            <option value="{{ $altkey }}"{{ $itemvalue == $altkey ? ' selected':'' }}>{{ $value }}</option>
                                            @endforeach
                                        </select>
                                        @endif
                                        @if($moduledata['type'] == 'multpileselect')
                                        <select class="form-control form-control-select" name="moduledata[{{ $modulename }}][{{ $modulekey }}][]">
                                            @foreach($moduledata['values'] as $altkey => $value)
                                            <option value="{{ $altkey }}"{{ $itemvalue == $altkey ? ' selected':'' }}>{{ $value }}</option>
                                            @endforeach
                                        </select>
                                        @endif
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                            @endforeach

                        </div>
                        <div class="modal-footer flex-center">
                            <button type="reset" class="btn btn-light me-3" data-kt-users-modal-action="cancel">
                                İptal
                            </button>
                            <button class="btn btn-primary saveAddonModule" data-id="{{ $language['lid'] }}-{{ $key }}">Kaydet</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        @endforeach
        @php
            break;
        @endphp
        @endforeach
    </div>
</div>

@endsection
@section('js')
<script src="assets/plugins/custom/draggable/draggable.bundle.js"></script>
<script>
    var lastkeys = {};
    @foreach($lastkeys as $key => $value)
    @if(!$value)
    @php $value = 0; @endphp
    @endif
    lastkeys[{{ $key }}] = {{ $value+1 }};
    @endforeach
    var activelang = parseInt($(".nav-link.active").data("lang"));
    $(".form-control-select").select2();
    $(".nav-language").on("click",function(){
        var lang = $(this).data("lang");
        activelang = lang;
        $(".nav-language.active").removeClass("active");
        $(this).addClass("active");
        $(".languageTab.d-flex").removeClass("d-flex").addClass("d-none");
        $(".languageTab"+lang).addClass("d-flex").removeClass("d-none");
        return false;
    });
    $(".addonAddForm").on("click",function(){
        var lastkey = lastkeys[activelang];
        var content = '<div class="col-12 mb-9 dragable" id="row'+activelang+'-'+lastkey+'" data-key="'+lastkey+'" data-lang="'+activelang+'">\
            <div class="row">\
                <div class="col-md-1">\
                    <label class="fs-6 fw-semibold mb-2 text-gray-500">Sıralama</label>\
                    <a href="#" class="btn btn-icon btn-sm btn-hover-light-primary draggable-handle">\
                        <span class="svg-icon svg-icon-2x">\
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">\
                                <path d="M21 7H3C2.4 7 2 6.6 2 6V4C2 3.4 2.4 3 3 3H21C21.6 3 22 3.4 22 4V6C22 6.6 21.6 7 21 7Z" fill="currentColor"></path>\
                                <path opacity="0.3" d="M21 14H3C2.4 14 2 13.6 2 13V11C2 10.4 2.4 10 3 10H21C21.6 10 22 10.4 22 11V13C22 13.6 21.6 14 21 14ZM22 20V18C22 17.4 21.6 17 21 17H3C2.4 17 2 17.4 2 18V20C2 20.6 2.4 21 3 21H21C21.6 21 22 20.6 22 20Z" fill="currentColor"></path>\
                            </svg>\
                        </span>\
                    </a>\
                </div>\
                <div class="col-md-3">\
                    <label class="fs-6 fw-semibold mb-2 text-gray-500">Ad</label>\
                    <input type="text" class="form-control" id="rowName'+activelang+'-'+lastkey+'">\
                </div>\
                <div class="col-md-1">\
                    <label class="fs-6 fw-semibold mb-2 text-gray-500">Süre</label>\
                    <input type="text" class="form-control" id="rowTime'+activelang+'-'+lastkey+'">\
                </div>\
                <div class="col-md-2">\
                    <label class="fs-6 fw-semibold mb-2 text-gray-500">Süre Tipi</label>\
                    <select class="form-control form-control-select" id="rowTimeType'+activelang+'-'+lastkey+'">\
                        @foreach($periods as $pkey => $pval)
                        <option value="{{ $pkey }}">{{ $pval }}</option>\
                        @endforeach
                    </select>\
                </div>\
                <div class="col-md-1">\
                    <label class="fs-6 fw-semibold mb-2 text-gray-500">Fiyat</label>\
                    <input type="text" class="form-control" id="rowPrice'+activelang+'-'+lastkey+'">\
                </div>\
                <div class="col-md-2">\
                    <label class="fs-6 fw-semibold mb-2 text-gray-500">Birim</label>\
                    <select class="form-control form-control-select" id="rowCurrency'+activelang+'-'+lastkey+'">\
                        @foreach($currencies as $currency)
                        <option value="{{ $currency['cid'] }}">{{ $currency['cname'] }}</option>\
                        @endforeach
                    </select>\
                </div>\
                <div class="col-md-2">\
                    <label class="fs-6 fw-semibold mb-2 text-gray-500">İşlemler</label>\
                    <div class="mt-1">\
                        <a data-bs-toggle="tooltip" title="Sil" class="btn btn-danger btnDeleteRow" data-key="'+activelang+'-'+lastkey+'">\
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor">\
                                <path fill="none" d="M0 0h24v24H0z"/>\
                                <path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"/>\
                            </svg>\
                            Sil\
                        </a>\
                    </div>\
                </div>\
            </div>\
        </div>';
        $("#itemArea"+activelang).append(content);
        lastkeys[activelang] += 1;
        return false;
    });
    $(".beItemArea").on("click",".btnDeleteRow",function(){
        var key = $(this).data("key");
        $("#row"+key).remove();
    });
    var wait = false;
    $(".addonSaveForm").on("click",function(){
        if(!wait){
            wait = true;
            $(".addonSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            var key = 0,lang = 0;
            var data = $("#infoForm").serialize()+"&";
            var counter = 0;
            $.each(lastkeys,function(lang,val){
                counter = 0;
                $("#itemArea"+lang+" > div").each(function(){
                    key = $(this).data("key");
                    data += "rowId["+lang+"]["+counter+"]="+key+"&";
                    data += "rowName["+lang+"]["+counter+"]="+$("#rowName"+lang+"-"+key).val().replace(/%/g,"%25")+"&";
                    data += "rowTime["+lang+"]["+counter+"]="+$("#rowTime"+lang+"-"+key).val().replace(/,/g,".")+"&";
                    data += "rowTimeType["+lang+"]["+counter+"]="+$("#rowTimeType"+lang+"-"+key).val()+"&";
                    data += "rowPrice["+lang+"]["+counter+"]="+$("#rowPrice"+lang+"-"+key).val().replace(/,/g,".")+"&";
                    data += "rowCurrency["+lang+"]["+counter+"]="+$("#rowCurrency"+lang+"-"+key).val().replace(/,/g,".")+"&";
                    counter += 1;
                });
                data += "itemCount["+lang+"]="+counter+"&";
            });
            data += "paid={{ $productaddon['paid'] }}";
            $.ajax({
                url: "{{ beGetRoute('admin.addon.edit.post') }}",
                type: "post",
                async: true,
                data: data,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".addonSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".beShowContent").on("click",function(){
        var item = $(this).data("contentid");
        if($(this).hasClass("active")){
            $(this).removeClass("active");
            $("#beContent-"+item).hide("slow");
        }
        else{
            $(this).addClass("active");
            $("#beContent-"+item).show("slow");
        }
    });
    $(".saveAddonModule").on("click",function(){
        if(!wait){
            wait = true;
            var itemid = $(this).data("id");
            $(".saveAddonModule").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.addon.module.edit.post') }}",
                type: "post",
                data: $("#addonModuleForm"+itemid).serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".saveAddonModule").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    var altcontainers = null;
    altcontainers = document.querySelectorAll(".dragable-zone");
    if(altcontainers.length !== 0) {
        swappable = new Sortable.default(altcontainers, {
            draggable: ".dragable",
            handle: ".dragable .draggable-handle",
            mirror: {
                appendTo: ".maindraggable",
                constrainDimensions: true
            }
        });
    }
</script>
@endsection