@extend('laylout')
@section('title')
{{ $product['pname'] }} -&nbsp;
@endsection
@section('headerinclude')
<script type="text/javascript" src="assets/premium/jscripts/bootstrap.bundle.min.js?ver=1850"></script>
<style>
    .table-summary {
        height: fit-content;
        padding: 15px;
        border-radius: 5px;
        background: #19527e;
    }
    .table-summary ul {
        list-style: none;
    }
    .table-summary ul li i {
        margin-right: 5px;
        color: #fff;
    }
    .table-summary .separator {
        height: 1px;
        margin: 15px 0;
        background-color: #fff;
        opacity: .5;
    }
    .table-data {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin: 8px 0px;
    }
    .table-summary span {
        color: #fff;
    }
    .table-summary .buttons {
        display: flex;
        justify-content: center;
    }
    .form-group {
        margin-top: 10px;
        margin-bottom: 10px;
    }
    .form-group label {
        color: #6c757d;
    }
    .input-group {
        position: relative;
        height: calc(3.4rem + 2px);
    }
    .input-group input {
        text-indent: 35px;
    }
    .input-group input[type="tel"]{
        width: 100%;
        height: calc(3.4rem + 2px);
        text-indent: 0px;
    }
    .input-icon {
        width: 40px;
        height: calc(3.4rem + 2px);
        position: absolute;
        z-index: 4;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .input-icon i {
        color: #b1b1b1;
        font-size: 18px;
    }
    .form-control:focus {
        box-shadow: none;
    }
    .select-price {
        font-size: 22px;
        font-weight: bold;
        color: #4b555a;				
    }
    .old-price {
        font-size: 16px;
        color: darkgreen;
    }
    @media (max-width:767px) {
        .product-configure {
            display:block !important
        }
        .table-summary {
            margin:30px 0;
        }
    }
    @media (max-width:543px) {
        #productForm h5 {
            font-size:18px !important;
        }
    }
    @media (max-width:413px) {
        .select-price {
            font-size:16px !important;
        }
    }
</style>
@endsection
@section('content')
<div class="container d-flex product-configure my-3">
    <div class="col-md-9 mx-3">
        <div class="card login-signup-card mb-0">
            <form id="productForm">
                <input type="hidden" name="pid" value="{{ $product['pid'] }}">
                <div class="row card-body px-md-5 py-4"> 
                    <div class="col-md-12 col-lg-12 border-right cart-flex-login"> 
                        <div class="mb-0"> 
                            <h5 class="h3" style="font-size:23px;font-weight:400">{{ $product['pname'] }} Yapılandırması</h5>
                        </div>
                        <hr>
                        <div class="mt-3">
                            <div class="form-group">
                                <label class="pb-1">Fatura Döngüsü</label>
                                <div class="input-group input-group-merge d-flex justify-content-between">
                                    <div class="w-100">
                                        <select name="period" class="form-select configureSelect">
                                            @foreach($pperiods as $key => $option)
                                                <option value="{{ $key }}">{{ ($option['operiodtime'] == 0 ? '':$option['operiodtime'].' ').$periods[$option['operiod']].($option['oprice'] == 0 ? '':(''.beMoneyFormat($option['oprice']).$currencies[$option['ocid']]['cicon'])) }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div id="beProductAddons">

                            </div>
                        </div>
                    </div>
                </div>						
            </form>
        </div>
        @if($product['pdescription'])
        <div class="card p-3 mt-3">
            {{ $product['pdescription'] }}
        </div>
        @endif
    </div>
    <div clasS="col-md-3 mx-3 table-summary" id="infoTable">
        <ul>
            <li><i class="ri-shopping-cart-2-line"></i><span>Yapılandırma Özeti</span></li>
            <li class="separator"></li>
            <li id="optionInfo">

            </li>
            <li class="separator"></li>
            <li>
                <div class="table-data">
                    <span>Ara Toplam</span>
                    <span id="productPrice">0 TL</span>
                </div>
            </li>
            <li>
                <div class="table-data">
                    <span>KDV(%<div id="totalFee" style="display:contents"></div>)</span>
                    <span id="ratePrice">0 TL</span>
                </div>
            </li>
            <li class="separator"></li>
            <li class="mb-2">
                <div class="table-data">
                    <span>Toplam</span>
                    <span id="totalPrice">0 TL</span>
                </div>
            </li>
            <li class="buttons">
                <a href="#" class="btn btn-transparent addToCart">Sepete Ekle</a>
            </li>
        </ul>
    </div>
    <div clasS="col-md-3 mx-3 table-summary" id="infoLoading" style="display:flex;justify-content:center;align-items:center">
        <img src="assets/premium/img/loadingnew.gif" style="width:100px;height:100px">
    </div>
</div>
@endsection
@section('js')
<script>
    checkPrice();
    $("#productForm").on("change",".configureSelect",function(){
        checkPrice();
    });
    var firsttime = true;
    function checkPrice(){
        var icon = "",periodtext = "";
        $("#infoTable").hide();
        $("#infoLoading").css("display","flex");
        $.ajax({
            url: "{{ beGetRoute('product.price') }}?{{ $_SERVER['QUERY_STRING'] }}",
            type: "post",
            data: $("#productForm").serialize(),
            dataType: "json",
            crossDomain: true,
            success: function(response){
                $("#optionInfo").empty();
                icon = response.icon;
                if(response.periodoptions[1] > 0){
                    periodtext = response.periodoptions[1]+" "+response.periodoptions[2];
                }
                else{
                    periodtext = response.periodoptions[2];
                }
                $("#optionInfo").append('<div class="table-data"><div><span>'+response.periodoptions[0]+'</span><span style="display:block;font-size:14px;opacity:0.7">'+periodtext+'</span></div><div><span>'+response.periodoptions[3]+icon+'</span></div></div>');
                $.each(response.addonoptions,function(index,val){
                    if(val[2] > 0){
                        periodtext = val[2]+" "+val[3];
                    }
                    else{
                        periodtext = "";
                    }
                    $("#optionInfo").append('<div class="table-data"><div><span>'+val[0]+'</span><span style="display:block;font-size:14px;opacity:0.9">Seçim: '+val[1]+'</span><span style="display:block;font-size:14px;opacity:0.7">'+periodtext+'</span></div><div><span>'+val[4]+icon+'</span></div></div>');
                });
                $("#beProductAddons").empty().append(response.addonoptionshtml);
                $("#productPrice").html(response.productprice+" "+icon);
                $("#ratePrice").html(response.totalrate+" "+icon);
                $("#totalPrice").html(response.totalprice+" "+icon);
                $("#totalFee").html(response.fee);
                $("#infoTable").show();
                $("#infoLoading").hide();
                if(firsttime){
                    checkPrice();
                    firsttime = false;
                }
            }
        });
    }
    var wait = false;
    $(".addToCart").on("click",function(){
        if(!wait){
            wait = true;
            $(".addToCart").html('<img src="assets/premium/img/loadingnew.svg" style="width:20px;height:20px"> Yükleniyor');
            $.ajax({
                url: "{{ beGetRoute('cart.add.post') }}",
                type: "post",
                async: true,
                data: $("#productForm").serialize()+"&action=add",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    if(response.status){
                        $(".addToCart").html("Sepete Ekle");
                        toast("Başarılı",response.message,"success");
                        setTimeout(function(){
                            window.location.href = response.url;
                        },1000);
                    }
                    else{
                        $(".addToCart").html("Sepete Ekle");
                        toast("Bir Hata Oluştu",response.message,"error");
                        wait = false;
                    }
                }
            });
        }
        else{
            toast("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }			
        return false;
    });
</script>
@endsection