<div class="cart-item" id="product{{ $upid }}">
	<div class="item-info">
		<div class="item-image">
			<a href="{{ $producturl }}" target="_blank">
				<img src="{{ $item['product']['pimage'] }}" width="64" height="64" alt="{{ $item['product']['pname'] }}">
			</a>
		</div>
		<div class="item-content">
			<div>
				<a href="{{ $producturl }}" target="_blank" class="item-name">{{ $item['product']['pname'] }}</a>
			</div>
			<div class="item-details mb-2 font-300">
				<span style="opacity:.6">{{ $item['product']['pdescription'] }}</span>
			</div>
			<div class="item-details">
				<span>{{ $item['periodoptions'][0] }}</span>
				<i class="ri-checkbox-blank-circle-fill"></i>
				<span class="options">{{ ($item['periodoptions'][1] > 1 ? $item['periodoptions'][1].' '.$item['periodoptions'][1]:$item['periodoptions'][2]).' - '.$item['periodoptions'][3].$item['icon'] }}</span>
			</div>
			@foreach($item['addonoptions'] as $addon)
			@if($addon[2] == 0)
			@php continue; @endphp
			@endif
			<div class="item-details">
				<span>{{ $addon[0] }}</span>
				<i class="ri-checkbox-blank-circle-fill"></i>
				<span class="options">{{ $addon[1].' / '.($addon[2] > 1 ? $addon[2].' '.$addon[3]:$addon[3]).' - '.$addon[4].$item['icon'] }}</span>
			</div>
			@endforeach
			<div class="item-price item-details">
				<span>{{ $count.' Adet' }}</span>
				<i class="ri-checkbox-blank-circle-fill"></i>
				<span class="options">{{ ($item['havediscount'] == true ? '<del>'.beMoneyFormat($item['productmainprice']).'</del> ':'').beMoneyFormat($item['productprice']).$item['icon'] }}</span>
			</div>
		</div>
	</div>
	<div class="item-buttons">
        <a href="#" class="removeProduct" data-upid="{{ $upid }}">
            <i class="ri-delete-bin-line text-danger"></i>
            <span>Kaldır</span>
        </a>
	</div>
</div>