@extend('laylout')
@section('headerinclude')
<meta name="og:title" content="{{ beGetConfig('siteshortname') }} - Türkiyenin Servis Sağlayıcısı">
<meta name="twitter:title" content="{{ beGetConfig('siteshortname') }} - Türkiyenin Servis Sağlayıcısı">
<meta name="og:description" content="{{ beGetConfig('sitename') }} ana sayfası üzerinden bir çok ürüne ulaşabilirsiniz. Aynı zamanda DiyoSoftware türkiyenin en büyük servis sağlayıcısıdır.">
<meta name="twitter:description" content="{{ beGetConfig('sitename') }} ana sayfası üzerinden bir çok ürüne ulaşabilirsiniz. Aynı zamanda DiyoSoftware türkiyenin en büyük servis sağlayıcısıdır.">
<meta name="description" content="{{ beGetConfig('sitename') }} olarak, yazılım, IoT, bot geliştirme, M2M ve web tasarımı çözümleri sunan bir yazılım işletmesidir.">
<style>
    .categories {
        display: flex;
    }
    .category-item {
        width: 23%;
        display: flex;
        align-items: center;
        flex-direction: column;
        margin: 0px 5px;
        padding: 10px;
        border-radius: 5px;
        box-shadow: 0 0 13px #e3e3e3;
        background: #fff;
    }
    .category-item img {
        margin-top: 15px;
    }
    .category-item h2,.category-item h3,.category-item h4,.category-item h5 {
        margin-top: 20px;
        font-size: 22px;	
        color: #555;
    }
    .category-item p {
        margin-top: 3px;
        font-size: 14px;
        color: #656363;
    }
    .category-item .category-min-price {
        margin: 20px 0px;
        font-size: 16px;
        font-weight: 500;
        color: #555;
    }
    .category-item hr {
        width: 80%;
        opacity: .2;
    }
    .category-item .category-settings {
        width: 90%;
        margin: 10px 0px;
    }
    .category-item ul li {
        display: flex;
        align-items: center;
        color: #555;
    }
    .category-item ul li:not(:last-child) {
        margin-bottom: 10px;	
    }
    .category-item ul li i {
        margin-right: 10px;
        font-size: 24px;
        color: #1689fc;
    }
    .category-item ul li span {
        font-size: 15px;
    }
    @media screen and (max-width:1400px) { 
        .category-item h2 {
            font-size: 22px;	
        }
        .category-item p {
            font-size: 13px;
        }
        .category-item .category-min-price {
            font-size: 14px;
        }
    }
    @media screen and (max-width:543px) { 
        .categories {
            flex-direction: column;	
        }
        .category-item {
            width: 100%;
            margin: 5px 0px;
        }
    }
</style>
<link type="text/css" rel="stylesheet" href="assets/premium/css/owl.carouser.min.css?ver=1824">
<link type="text/css" rel="stylesheet" href="assets/premium/css/category.css?ver=1824">
<script type="text/javascript" src="assets/premium/jscripts/plugins/owl.carousel.min.js?ver=1824"></script>
@endsection
@section('content')
<div class="container mb-3">
    <div class="container my-5 text-center">
        <h1 class="mb-3" style="color:#212529;font-weight:400;font-size:34px;">{{ __('home_text') }}</h1>
        <span style="font-weight:300;font-size:20px;color:#636262;">İster küçük bir işletme ister büyük bir kuruluş olun, size özel çözümlerimiz ile her zaman buradayız.</span>
    </div>
    <div class="container product-whyus">
        <ul>
            <li>
                <div class="whyus-image">
                    <img src="{{ beGetConfig('siteurl') }}/assets/media/main/yazilim.png" width="500" height="320" alt="Yazılım" title="Yazılım">
                </div>
                <div class="whyus-content">
                    <h2>
                        <span class="whyus-name">{{ __('infolist_1_name') }}</span>
                    </h2>
                    <span class="whyus-description">
                        {{ __('infolist_1_description') }}
                    </span>
                </div>				
            </li>
            <li>
                <div class="whyus-content">
                    <h3>
                        <span class="whyus-name">{{ __('infolist_2_name') }}</span>
                    </h3>
                    <span class="whyus-description">
                        {{ __('infolist_2_description') }}
                    </span>
                </div>	
                <div class="whyus-image">
                    <img src="{{ beGetConfig('siteurl') }}/assets/media/main/firma.png" width="500" height="320" alt="Kurumsal Firma" title="Kurumsal Firma">
                </div>
            </li>
        </ul>
    </div>
    <div class="container product-whyus">
        <ul>
            <li>
                <div class="whyus-image">
                    <img src="{{ beGetConfig('siteurl') }}/assets/media/main/support-concept.svg" width="500" height="320" alt="Kurumsal destek" title="Kurumsal destek">
                </div>
                <div class="whyus-content">
                    <h2>
                        <span class="whyus-name">{{ __('infolist_3_name') }}</span>
                    </h2>
                    <span class="whyus-description">
                        {{ __('infolist_3_description') }}
                    </span>
                </div>				
            </li>
            <li>
                <div class="whyus-content">
                    <h3>
                        <span class="whyus-name">{{ __('infolist_4_name') }}</span>
                    </h3>
                    <span class="whyus-description">
                        {{ __('infolist_4_description') }}
                    </span>
                </div>	
                <div class="whyus-image">
                    <img src="{{ beGetConfig('siteurl') }}/assets/media/main/control-panel-concept.svg" width="500" height="320" alt="Kurumsal İçerik" title="Kurumsal İçerik">
                </div>
            </li>
        </ul>
    </div>
</div>
@endsection
@section('js')
<script>
    $(document).ready(function(){
        var owl = $('.owl-carousel');
        owl.owlCarousel({
            items:1,
            loop:true,
            margin:10,
            autoplay:true,
            autoplayTimeout:5000,
            autoplayHoverPause:true
        });
    });
</script>
@endsection