@extend('client.laylout')
@section('content')
@if($userproducts)
<div class="sportlet">
	<div class="sportlet-header-special mb-3">
		<h3>
			Hizmetleriniz
		</h3>
	</div>
	<div class="stable">
		<table class="table">
			<thead>
				<tr>
					<th>Sipariş</th> 
					<th>Ürün / Hizmet</th> 
					<th>Tutar</th> 
					<th class="hidden-xs text-center">Sonraki Ödeme Tarihi</th> 
					<th class="text-center">Kalan Gün</th>
					<th class="text-center">İşlemler</th>
				</tr>
			</thead>
			<tbody>
                @foreach($userproducts as $userproduct)
                <tr>
                    <td>{{ $userproduct['extend'] }} {{ $userproduct['upid'] }}</td>
                    <td>{{ $userproduct['pname'] }}</td>
                    <td>{{ $userproduct['upprice'] }}₺</td>
                    <td>{{ $userproduct['enddate'] }}</td>
                    <td class="{{ $userproduct['endclass'] }}">{{ $userproduct['endtext'] }}</td>
                    <td>
                        <a href="{{ beGetRoute('client.userproduct.userproduct',['upid' => $userproduct['upid']]) }}" class="btn btn-special btn-sm">Görüntüle</a>
                    </td>
                </tr>
                @endforeach
			</tbody>
		</table>		
	</div>
</div>
<div class="my-3 p-3">
	<a href="#" class="btn btn-sm btn-special payInvoice">Seçilileri Uzat</a>
	<a href="#" class="btn btn-sm btn-special payAllInvoice">Hepsini Uzat</a>
</div>
<script>
	$(".payInvoice").on("click",function(){
		var list = "";
		$(".checkExtend:checked").each(function(){
			list = list+$(this).data("upid")+",";
		});			
		payInvoice(list);
		return false;
	});	
	$(".payAllInvoice").on("click",function(){
		var list = "";
		$(".checkExtend").each(function(){
			list = list+$(this).data("upid")+",";
		});			
		payInvoice(list);
		return false;
	});	
	function payInvoice(list){
		$.ajax({
			url: "{{ beGetRoute('client.invoice.process.post') }}",
			type: "post",
			data: {action:"extend",list:list},
			dataType: "json",
			crossDomain: true,
			success: function(response){
				if(response.status){
					toast("Başarılı",response.message,"success");
					setTimeout(function(){
						window.location.href = response.url;
					},1000);
				}
				else{
					toast("Bir Hata Oluştu",response.message,"error");
				}
			}
		});				
	}
</script>
@else
<div class="sportlet">
	<div class="sportlet-header-special sportlet-headerb mb-3">
		<div>
			<h3>Aktif Hizmetlerim</h3>
		</div>
		<div>
			<a href="{{ beGetConfig('siteurl') }}" class="btn btn-transparent btn-icon btn-sm">
				<i class="ri-add-line"></i>
				Hizmet Satın Al
			</a>
		</div>
	</div>
	<div class="card-body text-center">
		<i class="ri-lifebuoy-line font-weight-bold display-4"></i> 
		<h5 class="my-2">Hiç bir aktif hizmetiniz bulunmamaktadır.</h5> 
	</div>
</div>
@endif
@endsection