@extend('client.laylout')
@section('headerinclude')
<link rel="stylesheet" href="assets/jscripts/select2/select2.css?ver=1807">
<script type="text/javascript" src="assets/jscripts/select2/select2.min.js?ver=1806">
</script>
<script src="assets/jscripts/general.js?ver=1820" nonce></script>
<style>
	.up-general {
		display: flex;
		justify-content: space-between;
		align-items: center;
	}
	.up-info {
		display: flex;
		width: 70%;
	}
	.up-image {
		display: flex;
		align-items: center;
		padding: 10px;
		border: 1px solid #e5e5e5;
		border-radius: 5px;		
	}
	.up-data {
		margin-left: 15px
	}
	.up-name {
		color: #4b555a;
   		font-size: 20px;
	}
	.up-description {
		font-size: 14px;
		color: #646464;		
	}
	.up-items {
		display: flex;
		flex-wrap: wrap;
		margin: 30px 0px;
	}
	.up-item-info {
		width: 30%;
		border-radius: 5px;
		margin: 10px;
		border: 1px solid #dedada;
	}
	.up-item-head {
		display: flex;
		align-items: center;
		padding: 10px 20px;
		font-weight: 500;
		border-bottom: 1px solid #dedada;
	}
	.up-item-head i {
		margin-right: 5px;
	}
	.up-item-content {
		padding: 20px;
	}
	.up-buttons {
		display: flex;
	}
	.up-buttons div {
		width: 30%;
		margin: 0px 10px;
	}
	.up-buttons a {
		width: 100%;
		display: flex;
		justify-content: center;
	}
	.btn-weba {
		color: #fff;
		background: #ff8404;
	}
	.btn-weba:hover {
		color: #fff;
	}
	.form-group label {
		color: #6c757d;
	}
	@media screen and (max-width:543px) { 
		.up-general,.up-items,.up-buttons {
    		flex-direction: column;
		}
		.up-info {
			width: 100%;
			margin-bottom: 10px;
		}
		.up-item-info,.up-buttons div {
			width: 100%;
			margin: 10px 0px;
		}
	}
</style>
@endsection
@section('content')
<div class="sportlet">
	<div class="sportlet-header">
		Hizmet Bilgilerim
	</div>
	<div class="smain">
		<div class="up-general">
			<div class="up-info">
				<div class="up-image">
					<img src="{{ $userproduct['pimage'] }}"  width="100" height="100" alt="{{ $userproduct['pname'] }}">
				</div>
				<div class="up-data">
					<div>
						<span class="up-name">{{ $userproduct['pname'] }} </span>
					</div>
					<div>
						<span class="up-description">{{ $userproduct['pmetadescription'] }}</span>
					</div>
				</div>
			</div>
			<div class="up-percent">
				<svg>
					<circle cx="70" cy="70" r="70"></circle>
					<circle cx="70" cy="70" r="70" style="stroke:#1e5f92;stroke-dashoffset:calc(440 - (440 * {{ $percent }}) / 100)"></circle>
				</svg>
				<div class="number">
					<h2>{{ $day }}</h2><h3>Gün</h3>
				</div>
			</div>
		</div>
		<div class="up-items">
			<div class="up-item-info">
				<div class="up-item-head">
					<i class="ri-calendar-line"></i>
					<span>Satın Alım Tarihi</span>
				</div>		
				<div class="up-item-content">
					{{ $startdate }}
				</div>
			</div>
			<div class="up-item-info">
				<div class="up-item-head">
					<i class="ri-restart-line"></i>
					<span>Sonraki Fatura Tarihi</span>
				</div>		
				<div class="up-item-content">
					{{ $enddate }}
				</div>
			</div>
			<div class="up-item-info">
				<div class="up-item-head">
					<i class="ri-bank-card-2-line"></i>
					<span>Yenileme</span>
				</div>		
				<div class="up-item-content">
					{{ $price }}₺
				</div>
			</div>
		</div>	
		<div class="smain up-buttons">
			<div>
				<a href="{{ beGetRoute('client.ticket.tickets') }}" class="btn btn-icon btn-special"><i class="ri-question-line"></i>Soru Sor</a>
			</div>
			<div>
				<a href="#" class="btn btn-icon btn-special extrendProduct"><i class="ri-timer-flash-line"></i>Süreyi Uzat</a>
			</div>
			<div>
				<a href="#" class="btn btn-icon btn-weba manageProduct"><i class="ri-tools-line"></i>Yönet</a>
			</div>
		</div>
	</div>
</div>
<script>
	$(".manageProduct").on("click",function(){
		$.ajax({
			url: "{{ beGetRoute('client.userproduct.process') }}",
			type: "post",
			data: {action:"manage",upid:{{ $userproduct['upid'] }}},
			dataType: "json",
			crossDomain: true,
			success: function(response){
				if(response.status){
					toast("Başarılı",response.message,"success");
					if(response.url){
						setTimeout(function(){
							window.location.href = response.url;
						},1000);						
					}
				}
				else{
					toast("Bir Hata Oluştu",response.message,"error");
				}
			}
		});						
		return false;
	});
	$(".extrendProduct").on("click",function(){
		$.ajax({
			url: "{{ beGetRoute('client.userproduct.process') }}",
			type: "post",
			data: {action:"extend",upid:{{ $userproduct['upid'] }}},
			dataType: "json",
			crossDomain: true,
			success: function(response){
				if(response.status){
					toast("Başarılı",response.message,"success");
					if(response.url){
						setTimeout(function(){
							window.location.href = response.url;
						},1000);						
					}
				}
				else{
					toast("Bir Hata Oluştu",response.message,"error");
				}
			}
		});						
		return false;		
	});
	var first = true;
	$(".transferProduct").on("click",function(){
		if(first){
			$.ajax({
				url: "{{ beGetRoute('client.userproduct.process') }}",
				type: "post",
				data: {action:"transfer",upid:{{ $userproduct['upid'] }},username:$('#select2-chosen-1').text()},
				dataType: "json",
				crossDomain: true,
				success: function(response){
					if(response.status){
						toast("Başarılı",response.message,"success");
						$("#smsCode").show();
						$(".transferProduct").html("Gönderimi Onayla");
						first = false;
					}
					else{
						toast("Bir Hata Oluştu",response.message,"error");
					}
				}
			});	
		}
		else{
			$.ajax({
				url: "{{ beGetRoute('client.userproduct.process') }}",
				type: "post",
				data: {action:"transfer_approve",code:$("#code").val()},
				dataType: "json",
				crossDomain: true,
				success: function(response){
					if(response.status){
						toast("Başarılı",response.message,"success");
						if(response.url){
							setTimeout(function(){
								window.location.href = response.url;
							},1000);						
						}
					}
					else{
						toast("Bir Hata Oluştu",response.message,"error");
					}
				}
			});	
		}
		return false;
	});
</script>
@endsection