<!DOCTYPE html>
<html>
	<head>
		<title>{{ $title }} - {{ beGetConfig('sitename') }}</title>
        {{ $headerinclude }}
        @yield('headerinclude')
        <meta name="description" content="{{ beGetConfig('sitename') }} Kullanıcı Sipariş Yönetimi Alanı" />
		<link type="text/css" rel="stylesheet" href="assets/premium/css/portlerts.css?ver=1852">
		<link type="text/css" rel="stylesheet" href="assets/premium/css/client.css?ver=1874">
		<link type="text/css" rel="stylesheet" href="assets/premium/css/accordion.css?ver=1850">
		<link type="text/css" rel="stylesheet" href="assets/premium/css/category.css?ver=1850">
		<link type="text/css" rel="stylesheet" href="assets/premium/css/circle.css?ver=1850">
		<script type="text/javascript" src="assets/premium/jscripts/bootstrap.bundle.min.js?ver=1850"></script>
	</head>
	<body>
        {{ $header }}
		<div class="container my-3">
			<div class="scontent">
				<div class="scontent-3">
					<div class="sportlet">
						<div class="sportlet-header sportlet-center">
							Kontrol Sistemi
						</div>
						<ul class="smenu">
                            @foreach($menuitems as $key => $menuitem)
							<li>
								<a href="{{ $menuitem['url'] }}"{{ $menuitem['newpage'] == true ? 'target="_blank"':'' }}>
									<div class="smenu-name">
                                        {{ $menuitem['icon'] }}
										<span>{{ $menuitem['name'] }}</span>
									</div>
								</a>
							</li>
                            @endforeach
						</ul>						
					</div>
                    @foreach($menus as $key => $menu)
                    <div class="sportlet mt-3">
						<div class="sportlet-header sportlet-center">
							{{ $menu['name'] }}
						</div>
						<ul class="smenu">
                            @foreach($menu['menuitems'] as $key => $menuitem)
							<li>
								<a href="{{ $menuitem['url'] }}"{{ $menuitem['newpage'] == true ? 'target="_blank"':'' }}>
									<div class="smenu-name">
                                        {{ $menuitem['icon'] }}
										<span>{{ $menuitem['name'] }}</span>
									</div>
								</a>
							</li>
                            @endforeach
						</ul>						
					</div>
                    @endforeach
				</div>
				<div class="scontent-9">
                    {{ $content }}
				</div>
			</div>
		</div>
		<script>
			$(document).ready(function() {
			  $('[data-toggle="tooltip"]').tooltip()
			})
			$(".smenu li[data-dropdown] > a").on("click",function(){
				var parent = $(this).parent();
				var opened = parent.attr("data-opened") == "1" ? true:false;
				if(opened){
					parent.find("ul").removeClass("active");
					parent.find(".dropdown-icon i").removeClass("ri-arrow-up-s-line").addClass("ri-arrow-down-s-line");
					parent.attr("data-opened","0");					
				}
				else{
					parent.find("ul").addClass("active");
					parent.find(".dropdown-icon i").removeClass("ri-arrow-down-s-line").addClass("ri-arrow-up-s-line");
					parent.attr("data-opened","1");					
				}
				return false;
			});
            {{ $response['js'] }}
		</script>
        @yield('js')
        {{ $footer }}
        <div class="toasts"></div>
	</body>
</html>