@extend('client.laylout')
@section('content')
@if(empty($ticketsactive))
<div class="sportlet">
	<div class="sportlet-header-special sportlet-headerb mb-3">
		<div>
			<h3>Aktif Destek Taleplerim</h3>
		</div>
		<div>
			<a href="{{ beGetRoute('client.ticket.newticket') }}" class="btn btn-transparent btn-icon btn-sm">
				<i class="ri-add-line"></i>
				Yeni Destek Talebi
			</a>
		</div>
	</div>
	<div class="card-body text-center">
		<i class="ri-lifebuoy-line font-weight-bold display-4"></i> 
		<h5 class="my-2">Hiçbir aktif destek talebiniz bulunmamaktadır.</h5> 
		<p class="mb-2">Uzman teknik ekibimizle 7/24 hizmetinizdeyiz.</p> 
	</div>
</div>
@else
<div class="sportlet mt-3">
    <div class="sportlet-header-special mb-3">
        <h3>
        Aktif Destek Taleplerim
        </h3>
    </div>
    <div class="stable-responsive">
        <table class="table stable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Başlık</th>
                    <th>Aktiflik</th>
                    <th class="text-center">Tarih</th>
                    <th class="text-center">Durum</th>
                    <th class="text-center">İşlemler</th>
                </tr>
            </thead>
            <tbody>
                @foreach($ticketsactive as $ticket)
                <tr>
                    <td>{{ $ticket['tid'] }}</td>
                    <td>{{ $ticket['tsubject'] }}</td>
                    <td>{{ $ticket['tstatus'] == 'active' ? 'Beklemede':'İşlemde' }}</td>
                    <td>{{ date('d.m.Y H:i',$ticket['tdateline']) }}</td>
                    <td>{{ $ticket['tlastreply'] == 'admin' ? 'Yanıtlandı':'Yanıt Bekliyor' }}</td>
                    <td>
                    <a href="{{ beGetRoute('client.ticket.ticket',['tid' => $ticket['tid']]) }}" class="btn btn-special btn-sm">Görüntüle</a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endif
@if(empty($ticketsclose))
<div class="sportlet mt-3">
	<div class="sportlet-header-special sportlet-headerb mb-3">
		<div>
			<h3>Kapatılmış Destek Taleplerim</h3>
		</div>
		<div>
			<a href="{{ beGetRoute('client.ticket.newticket') }}" class="btn btn-transparent btn-icon btn-sm">
				<i class="ri-add-line"></i>
				Yeni Destek Talebi
			</a>
		</div>
	</div>
	<div class="card-body text-center">
		<i class="ri-lifebuoy-line font-weight-bold display-4"></i> 
		<h5 class="my-2">Hiçbir aktif destek talebiniz bulunmamaktadır.</h5> 
		<p class="mb-2">Uzman teknik ekibimizle 7/24 hizmetinizdeyiz.</p> 
	</div>
</div>
@else
<div class="sportlet mt-3">
    <div class="sportlet-header-special mb-3">
        <h3>
        Kapatılmış Destek Taleplerim
        </h3>
    </div>
    <div class="stable-responsive">
        <table class="table stable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Başlık</th>
                    <th class="text-center">Tarih</th>
                    <th class="text-center">İşlemler</th>
                </tr>
            </thead>
            <tbody>
                @foreach($ticketsclose as $ticket)
                <tr>
                    <td>{{ $ticket['tid'] }}</td>
                    <td>{{ $ticket['tsubject'] }}</td>
                    <td>{{ date('d.m.Y H:i',$ticket['tdateline']) }}</td>
                    <td>
                    <a href="{{ beGetRoute('client.ticket.ticket',['tid' => $ticket['tid']]) }}" class="btn btn-special btn-sm">Görüntüle</a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endif
@endsection