@php global $lastpost; @endphp
@foreach($posts as $post)
    @if($post["uid"] == $user["uid"])
    <li class="smessage-cMessage smessage-me" id="post{{ $post['pid'] }}">
        <div class="smessage-message">
            <div class="smessage-bubble">
                <div class="smessage-name">
                    <span>{{ $post['name'].' '.$post['surname'] }}</span>
                </div>
                <div class="smessage-inner">
                    <span>{{ $post['tpmessage'] }}</span>
                </div>
                <div class="my-3">
                    @if($post['attachments'])
                    @foreach($post['attachments'] as $attachment)
                    <div class="card p-2">
                        <div class="d-flex align-items-center">
                            <span class="svg-icon svg-icon-2x me-1" style="color:#009ef7">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.3" d="M19 22H5C4.4 22 4 21.6 4 21V3C4 2.4 4.4 2 5 2H14L20 8V21C20 21.6 19.6 22 19 22Z" fill="currentColor"></path>
                                    <path d="M15 8H20L14 2V7C14 7.6 14.4 8 15 8Z" fill="currentColor"></path>
                                </svg>
                            </span>
                            <a href="{{ beGetRoute('file.show',['slug' => $attachment['aslug'],'aid' => $attachment['aid']]) }}" target="_blank" style="color:#009ef7!important">{{ $attachment['aname'] }}</a>
                        </div>
                        <div class="mt-2 d-flex justify-content-between" style="font-size:11px;opacity:.5">
                            <span>{{ beConvertSize($attachment['asize']) }}</span>
                            <span>{{ beSpecialTime($attachment['adateline']) }}</span>
                        </div>
                    </div>
                    @endforeach
                    @endif
                </div>
                <div class="smessage-date">
                {{ beSpecialTime($post['tpdateline']) }}
                </div>
            </div>
        </div>
        <div class="avatar">
            <div>
                <img src="https://www.webailesi.com/images/default_avatar.png">
            </div>
        </div>
    </li>
    @else
    <li class="smessage-cMessage smessage-right" id="post{{ $post['pid'] }}">
        <div class="avatar">
            <div>
                <img src="https://www.webailesi.com/premium/img/weba-avatar.png">
            </div>
        </div>
        <div class="smessage-message">
            <div class="smessage-bubble">
                <div class="smessage-name">
                    <span>{{ $post['name'].' '.$post['surname'] }}</span>
                </div>
                <div class="smessage-inner">
                    <span>Merhaba,</span>
                    <div>{{ $post['tpmessage'] }}</div>
                    <span><br><br>Bilginize sunar, iyi çalışmalar dileriz.</span>
                </div>
                <div class="my-3">
                    @if($post['attachments'])
                    @foreach($post['attachments'] as $attachment)
                    <div class="card p-2">
                        <div class="d-flex align-items-center">
                            <span class="svg-icon svg-icon-2x me-1" style="color:#009ef7">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.3" d="M19 22H5C4.4 22 4 21.6 4 21V3C4 2.4 4.4 2 5 2H14L20 8V21C20 21.6 19.6 22 19 22Z" fill="currentColor"></path>
                                    <path d="M15 8H20L14 2V7C14 7.6 14.4 8 15 8Z" fill="currentColor"></path>
                                </svg>
                            </span>
                            <a href="{{ beGetRoute('file.show',['slug' => $attachment['aslug'],'aid' => $attachment['aid']]) }}" target="_blank" style="color:#009ef7!important">{{ $attachment['aname'] }}</a>
                        </div>
                        <div class="mt-2 d-flex justify-content-between" style="font-size:11px;opacity:.5">
                            <span>{{ beConvertSize($attachment['asize']) }}</span>
                            <span>{{ beSpecialTime($attachment['adateline']) }}</span>
                        </div>
                    </div>
                    @endforeach
                    @endif
                </div>
                <div class="smessage-date">
                    {{ beSpecialTime($post['tpdateline']) }}
                </div>
            </div>
        </div>
    </li>

    @endif
    @php 
        $lastpost = $post['tpid']; 
    @endphp
@endforeach