@extend('client.laylout')
@section('content')
<div class="sportlet">
	<div class="sportlet-header-special">
		<h3>
			Yeni Destek Talebi
		</h3>
	</div>
	<div class="smain">
		<form id="ticketForm" action="">
			<div class="row">
			  <div class="col">
				<input name="subject" placeholder="Destek Talebi Basliginiz" required="required" type="text" value="" class="form-control">
			  </div>
			</div>
			<div class="row my-3">
			  <div class="col">
				<select class="form-select form-control" name="department" required="required">
					@foreach($depertments as $depertment)
					<option value="{{ $depertment['tdid'] }}">{{ $depertment['tdname'] }}</option>
					@endforeach
				</select>
			  </div>
			  <div class="col">
				<select class="form-select form-control" name="product" required="required">
					<option value="0" data-type="none">İlişkili Hizmet Seçiniz</option>
					@foreach($orders as $order)
					<option value="{{ $order['upid'] }}">{{ $order['upname'].' # '.$order['uptag'] }}</option>
					@endforeach
				</select>
			  </div>
			</div>
			<div class="row my-3">
			  <div class="col">
				<textarea class="form-control" name="message" rows="8" placeholder="açıklama"></textarea>
			  </div>
			</div>
			<div class="row text-center">
			  <div class="col">
				<a href="#" class="btn btn-special sendTicket">Gönder</a>
			  </div>
			</div>
		</form>
	</div>
</div>
<script>
    var wait = false;
    $(".sendTicket").on("click",function(){
        if(!wait){
            $(".sendTicket").html('<img src="assets/premium/img/reload.gif" style="width:20px;height:20px"> Gönderiliyor');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('client.ticket.newticket.post') }}",
                type: "post",
                async: true,
                data: $("#ticketForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    if(response.status){
                        $(".sendTicket").html("Gönder");
                        toast("Başarılı",response.message,"success");
                        setTimeout(function(){
                            window.location.href = response.url;
                        },1000);
                    }
                    else{
                        $(".sendTicket").html("Gönder");
                        toast("Bir Hata Oluştu",response.message,"error");
                        wait = false;
                    }
                }
            });	
        }
        else{
            toast("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }	
        return false;
    });
</script>
@endsection