<!DOCTYPE html>
<html>
	<head>
        {{ $headerinclude }}
        @yield('headerinclude')
        <meta name="description" content="Webailesi.com satış sistemi" />
		<link type="text/css" rel="stylesheet" href="assets/premium/css/portlerts.css?ver=1852">
		<link type="text/css" rel="stylesheet" href="assets/premium/css/client.css?ver=1868">
		<link type="text/css" rel="stylesheet" href="assets/premium/css/accordion.css?ver=1850">
		<link type="text/css" rel="stylesheet" href="assets/premium/css/category.css?ver=1850">
		<link type="text/css" rel="stylesheet" href="assets/premium/css/circle.css?ver=1850">
		<script type="text/javascript" src="assets/premium/jscripts/bootstrap.bundle.min.js?ver=1850"></script>
	</head>
	<body>
        {{ $header }}
		<div class="container my-3">
			<div class="scontent">
				<div class="scontent-3">
					<div class="sportlet">
						<div class="sportlet-header sportlet-center">
							Müşteri Paneli
						</div>
						<ul class="smenu">
							<li>
								<a href="{{ beGetRoute('client.dashboard.alternative') }}">
									<div class="smenu-name">
										<i class="ri-home-4-line"></i>
										<span>Ana Sayfa</span>
									</div>
								</a>
							</li>
							<li>
								<a href="{{ beGetRoute('client.userproduct.userproducts') }}">
									<div class="smenu-name">
										<i class="ri-shopping-cart-2-line"></i>
										<span>Hizmetlerim</span>
									</div>
								</a>
							</li>
							<li>
								<a href="{{ beGetRoute('client.ticket.tickets') }}">
									<div class="smenu-name">
										<i class="ri-customer-service-2-line"></i>
										<span>Teknik Destek</span>
									</div>
								</a>
							</li>
							<li data-dropdown="1">
								<a href="#">
									<div class="smenu-name">
										<i class="ri-folder-2-fill"></i>
										<span>Muhasebe</span>
									</div>
									<div class="dropdown-icon">
										<i class="ri-arrow-down-s-line"></i>
									</div>
								</a>
								<ul class="smenu-dropdown">
									<li>
										<a href="{{ beGetRoute('client.invoice.active') }}">
											<div class="smenu-name">
												<i class="ri-file-copy-line"></i>
												<span>Makbuzlarım</span>
											</div>
										</a>
									</li>
									<li>
										<a href="{{ beGetRoute('client.invoice.deactive') }}">
											<div class="smenu-name">
												<i class="ri-chat-check-line"></i>
												<span>Ödenmemiş Makbuzlarım</span>
											</div>
										</a>
									</li>
									<li>
										<a href="{{ beGetRoute('client.invoice.money') }}">
											<div class="smenu-name">
												<i class="ri-bank-card-2-line"></i>
												<span>Kredi Yükle</span>
											</div>
										</a>
									</li>
									<li>
										<a href="{{ beGetRoute('client.ticket.tickets') }}">
											<div class="smenu-name">
												<i class="ri-customer-service-2-line"></i>
												<span>Ödeme Bildirimi</span>
											</div>
										</a>
									</li>
									<li>
										<a href="{{ beGetRoute('client.bank') }}">
											<div class="smenu-name">
												<i class="ri-bank-line"></i>
												<span>Banka Hesapları</span>
											</div>
										</a>
									</li>
								</ul>
							</li>
							<li data-dropdown="1">
								<a href="#">
									<div class="smenu-name">
										<i class="ri-user-3-line"></i>
										<span>Üyelik İşlemleri</span>
									</div>
									<div class="dropdown-icon">
										<i class="ri-arrow-down-s-line"></i>
									</div>
								</a>
								<ul class="smenu-dropdown">
									<li>
										<a href="{{ beGetRoute('client.userinfo') }}">
											<div class="smenu-name">
												<i class="ri-settings-3-line"></i>
												<span>Bilgilerimi Değiştir</span>
											</div>
										</a>
									</li>
									<li>
										<a href="{{ beGetRoute('client.address') }}">
											<div class="smenu-name">
												<i class="ri-map-pin-line"></i>
												<span>Adresimi Düzenle</span>
											</div>
										</a>
									</li>
									<li>
										<a href="{{ beGetRoute('client.password') }}">
											<div class="smenu-name">
												<i class="ri-lock-line"></i>
												<span>Şifremi Değiştir</span>
											</div>
										</a>
									</li>
								</ul>
							</li>
							<li>
								<a href="satis-ortakligi">
									<div class="smenu-name">
										<i class="ri-information-line"></i>
										<span>Satış Ortaklığı</span>
									</div>
								</a>
							</li>
							<li data-dropdown="1">
								<a href="#">
									<div class="smenu-name">
										<i class="ri-history-line"></i>
										<span>Kayıtlar</span>
									</div>
									<div class="dropdown-icon">
										<i class="ri-arrow-down-s-line"></i>
									</div>
								</a>
								<ul class="smenu-dropdown">
									<li>
										<a href="{{ beGetRoute('client.log.sms') }}">
											<div class="smenu-name">
												<i class="ri-phone-line"></i>
												<span>SMS Kayıtları</span>
											</div>
										</a>
									</li>
									<li>
										<a href="{{ beGetRoute('client.log.email') }}">
											<div class="smenu-name">
												<i class="ri-mail-send-line"></i>
												<span>E-Mail Kayıtları</span>
											</div>
										</a>
									</li>
									<li>
										<a href="{{ beGetRoute('client.log.alert') }}">
											<div class="smenu-name">
												<i class="ri-notification-2-line"></i>
												<span>Bildirim Kayıtları</span>
											</div>
										</a>
									</li>
									<li>
										<a href="{{ beGetRoute('client.invoice.active') }}">
											<div class="smenu-name">
												<i class="ri-bank-card-2-line"></i>
												<span>Ödeme Geçmişim</span>
											</div>
										</a>
									</li>
									<li>
										<a href="{{ beGetRoute('client.log.user') }}">
											<div class="smenu-name">
												<i class="ri-user-location-line"></i>
												<span>Giriş Kayıtları</span>
											</div>
										</a>
									</li>
								</ul>
							</li>
							<li>
								<a href="{{ beGetRoute('client.settings') }}">
									<div class="smenu-name">
										<i class="ri-settings-3-line"></i>
										<span>Hesap Ayarları</span>
									</div>
								</a>
							</li>
							<li>
								<a href="{{ beGetRoute('client.invoice.money') }}">
									<div class="smenu-name">
										<i class="ri-bank-card-2-line"></i>
										<span>Kredi Yükle</span>
									</div>
								</a>
							</li>
						</ul>						
					</div>
					<div class="sportlet mt-3">
						<div class="sportlet-header sportlet-center">
							Son Destek Talepleri
						</div>
						<ul class="smenu">
							{{ $lasttickets }}
						</ul>
						<div class="sportlet-footer">
							<a href="yeni-destek-talebi" class="btn btn-transparent btn-flex btn-icon">
								<i class="ri-add-line"></i>
								Yeni Destek Talebi
							</a>
						</div>
					</div>
				</div>
				<div class="scontent-9">
                    @yield('content')
				</div>
			</div>
		</div>
		<script>
			$(document).ready(function() {
			  $('[data-toggle="tooltip"]').tooltip()
			})
			$(".smenu li[data-dropdown] > a").on("click",function(){
				var parent = $(this).parent();
				var opened = parent.attr("data-opened") == "1" ? true:false;
				if(opened){
					parent.find("ul").removeClass("active");
					parent.find(".dropdown-icon i").removeClass("ri-arrow-up-s-line").addClass("ri-arrow-down-s-line");
					parent.attr("data-opened","0");					
				}
				else{
					parent.find("ul").addClass("active");
					parent.find(".dropdown-icon i").removeClass("ri-arrow-down-s-line").addClass("ri-arrow-up-s-line");
					parent.attr("data-opened","1");					
				}
				return false;
			});
		</script>
        @yield('js')
        {{ $footer }}
        <div class="toasts"></div>
	</body>
</html>