@extend('client.laylout')
@section('content')
<div class="scredit">
	<div>
		<span class="scredit-name">Kredi Bakiyeniz</span>
		<span class="scredit-desc">Hesabınıza yüklenmiş olan kredi miktarı.</span>
	</div>
	<div>
		<span class="scredit-val">{{ $user['money'] }}₺</span>
	</div>
</div>
<div class="sportlet mt-3">
	<div class="sportlet-header-special">
		<h3>
			Kredi Yükleme
		</h3>
	</div>
	<div class="smain">
		<form id="creditForm" action="">
			<div class="row">
			  <div class="col">
				<input name="price" placeholder="Yüklemek istediğiniz miktarı girin" required="required" type="number" value="" class="form-control" min="3" max="5000">
			  </div>
			</div>
			<div class="row text-center mt-3">
			  <div class="col">
				<a href="#" class="btn btn-special createInvoice">Yükle</a>
			  </div>
			</div>
		</form>
	</div>
</div>
<div class="container my-3">
	<ul class="nav nav-tabs" id="myTab" role="tablist">
		<li class="nav-item" role="presentation">
			<button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="true"><i class="ri-question-fill"></i>Sıkça Sorulan Sorular</button>
		</li>
	</ul>
	<div class="tab-content" id="myTabContent">
		<div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
			<div class="accordion" id="accordionExample">
				<div class="accordion-item">
					<h2 class="accordion-header" id="head0">
						<button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse0" aria-expanded="true" aria-controls="collapse0">
						Yüklediğim bakiye anında hesabımda aktif olacakmı?
						</button>
					</h2>
					<div id="collapse0" class="accordion-collapse collapse show" aria-labelledby="head0" data-bs-parent="#accordionExample">
						<div class="accordion-body">
						Evet, Kredi yükle sayfasından yatırdığınız site bakiyeleri anında kullanılabilir bakiye olarak hesabınıza eklenecektir. Yüklediğiniz bakiyeler ile webailesi üzerindeki tüm ürünleri satın alabilirsiniz veyatta ayarlar sekmesi üzerinden aktif ettiğiniz otomatik uzatma ayarı için kullanılabilir. Yüklediğiniz kredileri 48 saat içersinde kesinti olmadan geri iade alabilirsiniz ancak 48 saat geçtikten sonra her hangi bir iade hakkı talep edemessiniz.
						</div>
					</div>
				</div>
				
				<div class="accordion-item">
					<h2 class="accordion-header" id="head1">
						<button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse1" aria-expanded="true" aria-controls="collapse1">
						Minimum kaç TL yükleme yapabilirim?
						</button>
					</h2>
					<div id="collapse1" class="accordion-collapse collapse show" aria-labelledby="head1" data-bs-parent="#accordionExample">
						<div class="accordion-body">
						Minimum 1TL yükleme yapabilirsiniz. Maksimum bir yükleme sınırı bulunmamaktadır. Yüklediğiniz site bakiyelerine 3,6,8 ve 12 ay taksite bölebilirsiniz.
						</div>
					</div>
				</div>
				
			</div>	
		</div>
	</div>			
</div>
<script>
	$(".createInvoice").on("click",function(){
		$.ajax({
			url: "{{ beGetRoute('client.invoice.money.post') }}",
			type: "post",
			data: $("#creditForm").serialize(),
			dataType: "json",
			crossDomain: true,
			success: function(response){
				if(response.status){
					toast("Başarılı",response.message,"success");
					setTimeout(function(){
						window.location.href = response.url;
					},1000);
				}
				else{
					toast("Bir Hata Oluştu",response.message,"error");
				}
			}
		});						
		return false;
	});
</script>
@endsection