@extend('client.laylout')
@section('content')
<div class="sportlet">
	<div class="sportlet-header-special sportlet-headerb mb-3">
		<div>
			<h3>Ödenmemiş Makbuzlarım</h3>
		</div>
		<div>
			<a href="{{ beGetRoute('client.ticket.newticket') }}" class="btn btn-transparent btn-icon btn-flex btn-sm">
				<i class="ri-add-line"></i>
				Yeni Destek Talebi
			</a>
		</div>
	</div>
    @if(!$invoices)
    <div class="smain text-center">
        <i class="ri-lifebuoy-line font-weight-bold display-4"></i>
        <h5 class="my-2">Hiç bir ödenmemiş makbuzunuz bulunmamaktadır.</h5>	
    </div>
    @else
	<div class="stable">
        <table class="table">
            <thead>
                <tr>
                    <th>Makbuz-NO</th> 
                    <th>Açıklama</th> 
                    <th>Toplam</th> 
                    <th>Son Ödeme Tarihi</th>
                    <th>İşlemler</th>
                </tr>
            </thead>
            <tbody>
                @foreach($invoices as $invoice)
                <tr>
                    <td>{{ $invoice['iid'] }}</td>
                    <td>{{ $invoice['iname'] }}</td>
                    <td>{{ $invoice['iprice']+$invoice['itaxprice']-$invoice['idiscount'] }} {{ $currencies[$invoice['cid']]['cicon'] }}</td>
                    <td>{{ date('d.m.Y',$invoice['iexpiredate']) }}</td>
                    <td>
                        <a href="{{ beGetRoute('client.invoice.invoice',['iid' => $invoice['iid']]) }}" class="btn btn-special btn-sm">Görüntüle</a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>	
    </div>
    @endif
</div>
@endsection