@extend('client.laylout')
@section('content')
<style>
.payment-options {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 15px;
    border: 1px solid rgb(230 230 230);
    background: white;
    cursor: pointer;
    border-radius: 6px;
    margin-bottom: 15px;
}
.payment-options.active {
    border: 1px solid rgb(43 215 104)!important;
}
.payment-options .info {
    display: flex;
    margin-right: 20px;
}
.payment-options .info .logo {
    margin-right: 20px;
    padding-right: 20px;
    border-right: 1px solid rgb(230 230 230);
}
.payment-options .info .text span:first-child {
    font-weight: 600;
    margin-bottom: 6px;
    font-size: 16px;
}
.payment-options .info .text span:last-child {
    opacity: 0.5;
    font-size: 12px;
}
.payment-options .info .text span {
    display: block;
}
.payment-options .info img {
    width: 85px;
    height: 50px;
}
.payment-options .price {
    width: 8%;
    font-weight: 500;
    font-size: 18px;
}
</style>
<div class="scontent-12">
    <div class="sportlet">
        <div class="sportlet-header-special">
            <h3>
                Son Bir Adım Kaldı
            </h3>
        </div>
        <div class="smain">
            <form action="" method="post">
                <div class="form-group">
                    @foreach($methods as $method)
                        {{ $method }}
                    @endforeach
                </div>
                <div class="text-center mt-3">
                    <div class="col">
                        <button class="btn btn-special btn-icon m-auto btnPay" name="send" value="1">Makbuzu Öde</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<script>
    var method = "";
    $(".payment-options").on("click",function(){
        $(".payment-options.active").removeClass("active");
        $(this).addClass("active");
        method = $(this).data("method")
    });
    var wait = false;
    $(".btnPay").on("click",function(){
        if(!wait){
            $(".btnPay").html('<i class="spinner ri-refresh-line"></i> Lütfen Bekleyin!');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('client.invoice.invoice.post') }}",
                type: "post",
                async: true,
                data: {iid:{{ $invoice['iid'] }},method:method},
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    if(response.status){
                        $(".btnPay").html("Makbuzu Öde");
                        $.Toast("Başarılı",response.message,"success");
                        setTimeout(function(){
                            window.location.href = response.url;
                        },1000);
                    }
                    else{
                        $(".btnPay").html("Makbuzu Öde");
                        $.Toast("Bir Sorun Oluştu",response.message,"error");
                        wait = false;
                    }
                }
            });	
        }
        else{
            $.Toast("Bir Sorun Oluştu",response.message,"error");
        }	
        return false;
    });
</script>
@endsection