@extend('client.laylout')
@section('content')
<div class="sinfo-boxes">
	<a href="{{ beGetRoute('client.userproduct.userproducts') }}" class="sinfo-box">
		<div>
			<span class="sinfo-box-count">{{ $product_count }}</span>
			<span class="sinfo-box-name">Hizmet </span>
		</div>
		<div>
			<img src="https://www.webailesi.com/premium/img/server2.png">
		</div>
	</a>
	<a href="{{ beGetRoute('client.ticket.tickets') }}"  class="sinfo-box">
		<div>
			<span class="sinfo-box-count">{{ $ticket_count }}</span>
			<span class="sinfo-box-name">Destek Talebi</span>
		</div>
		<div>
			<img src="https://www.webailesi.com/premium/img/messaging.png">
		</div>
	</a>
	<a href="{{ beGetRoute('client.invoice.deactive') }}"  class="sinfo-box">
		<div>
			<span class="sinfo-box-count">{{ $invoice_count }}</span>
			<span class="sinfo-box-name">Ödenmemiş Fatura</span>
		</div>
		<div>
			<img src="https://www.webailesi.com/premium/img/card.png">
		</div>
	</a>
</div>
<div class="sinfo-user mt-3">
	<div class="sinfo-userinfo">
		<div>
			<span class="sinfo-name">{{ $user['name'] }} {{ $user['surname'] }}</span>
			<span class="sinfo-email">{{ $user['email'] }}</span>
		</div>
	</div>
	<div class="sinfo-logs">
		<div>
			<span class="sinfo-key">Krediniz</span>
			<span style="color:#00CC00;font-weight:600" class="sinfo-val">{{ $user['money'] }}₺</span>
		</div>
	</div>
</div>
@if($userproducts)
<div class="sportlet mt-3">
	<div class="sportlet-header-special mb-3">
		<h3>
			Yenilemesi Yaklaşan Hizmetler
		</h3>
	</div>
	<div class="stable">
		<table class="table">
			<thead>
				<tr>
					<th>#</th> 
					<th>Ürün / Hizmet</th> 
					<th>Tutar</th> 
					<th class="hidden-xs text-center">Son Ödeme Tarihi</th> 
					<th class="text-center">Kalan Gün</th>
					<th class="text-center">İşlemler</th>
				</tr>
			</thead>
			<tbody>
			@foreach($userproducts as $userproduct)
                <tr>
                    <td>{{ $userproduct['upid'] }}</td>
                    <td>{{ $userproduct['pname'] }}</td>
                    <td>{{ $userproduct['upprice'] }}₺</td>
                    <td>{{ $userproduct['enddate'] }}</td>
                    <td class="{{ $userproduct['endclass'] }}">{{ $userproduct['endtext'] }}</td>
                    <td>
                        <a href="{{ beGetRoute('client.userproduct.userproduct',['upid' => $userproduct['upid']]) }}" class="btn btn-special btn-sm">Görüntüle</a>
                    </td>
                </tr>
                @endforeach
			</tbody>
		</table>		
	</div>
</div>
@endif
<div class="mt-3">
	<ul class="nav nav-tabs" id="myTab" role="tablist">
		<li class="nav-item" role="presentation">
			<button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="true"><i class="ri-question-fill"></i>Sıkça Sorulan Sorular</button>
		</li>
	</ul>
	<div class="tab-content" id="myTabContent">
		<div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
			<div class="accordion" id="accordionExample">
				<div class="accordion-item">
					<h5 class="accordion-header" id="head0">
						<button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse0" aria-expanded="true" aria-controls="collapse0">
							Satın aldığım ürünü nasıl yönetebilirim?
						</button>
					</h5>
					<div id="collapse0" class="accordion-collapse collapse show" aria-labelledby="head0" data-bs-parent="#accordionExample">
						<div class="accordion-body">
							Webailesi müşteri paneli üzerindeki sol menüden "Hizmetlerim" sayfasına giriş yaparak satın aldığınız ürünü 7/24 anında kolayca yönetebilirsiniz. Satın aldığınız ürün hakkında 7/24 destek sistemimiz üzerinden yardım alabilirsiniz. "Hizmetlerim" sayfası üzerinden dilediğiniz zaman fatura oluşturarak hizmetinizin süresini tek tıkla uzatabilirsiniz.
						</div>
					</div>
				</div>
				<div class="accordion-item">
					<h5 class="accordion-header" id="head1">
						<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse1" aria-expanded="false" aria-controls="collapse1">
							Webailesi ürünleri hakkında nasıl yardım alabilirim?
						</button>
					</h5>
					<div id="collapse1" class="accordion-collapse collapse" aria-labelledby="head1" data-bs-parent="#accordionExample">
						<div class="accordion-body">
							Webailesi ürünleri hakkında bilgi almak oldukça kolaydır. Webailesi sosyal medya hesapları üzerinden veyatta destek sistemimiz üzerinden 7/24 iletişim kurabilirsiniz. İletişim kurmanız durumda ekibimiz sorununuzu veyatta sorularınızı yanıtlamak için 7/24 sizinle ilgilenecektir.
						</div>
					</div>
				</div>
				<div class="accordion-item">
					<h5 class="accordion-header" id="head2">
						<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse2" aria-expanded="false" aria-controls="collapse2">
							Ürünlerinizi satarak kazanç elde edebilirmiyim?
						</button>
					</h5>
					<div id="collapse2" class="accordion-collapse collapse" aria-labelledby="head2" data-bs-parent="#accordionExample">
						<div class="accordion-body">
							Evet, webailesi satış ortaklığı programı sayesinde bu mümkün. Webailesi müşteri paneli sayfası üzerindeki sol menü üzerinde bulunan "Satış Ortaklığı" sayfası üzerinden kitleniz için bir kupon kodu oluşturabilir ve sizde webailesi ile kazanmaya başlayabilirsiniz. Webailesi satış ortaklığı programı ile kazandığınız kazançları dilerseniz bakiye olarak kullanabilirsiniz dilersenizde kredi kartınıza aktarım için destek talebi açabilirsiniz.
						</div>
					</div>
				</div>
				<div class="accordion-item">
					<h5 class="accordion-header" id="head3">
						<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse3" aria-expanded="false" aria-controls="collapse3">
							İade sisteminiz nasıl çalışmaktadır?
						</button>
					</h5>
					<div id="collapse3" class="accordion-collapse collapse" aria-labelledby="head3" data-bs-parent="#accordionExample">
						<div class="accordion-body">
							Webailesi iade sistemi tamamen müşteri odaklı hizmet vermektedir. Satın aldığınız ürünleri(otomatik çalıştırılan ürünler için geçerlidir) 48 saat içersinde hiç bir kesinti yaşamadan kredi kartınıza veyatta webailesi kredisi olarak anında iade alabilirsiniz. İade sistemimizde çalışma sağlığını korumak için üyeliğinizde sadece bir kez iade alabilirsiniz. İkinci iadeyi almaya çalıştığınız zaman sistemimiz size iade politikamız gereği iade yapmayacaktır. Webailesi taraflı hatalarda veyatta sorunlarda bu sınır otomatik olarak kaldırılmaktadır veyatta telafi çözümler üretilmektedir.
						</div>
					</div>
				</div>
				<div class="accordion-item">
					<h5 class="accordion-header" id="head4">
						<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse4" aria-expanded="false" aria-controls="collapse4">
							Nasıl hesabıma bakiye yüklerim?
						</button>
					</h5>
					<div id="collapse4" class="accordion-collapse collapse" aria-labelledby="head4" data-bs-parent="#accordionExample">
						<div class="accordion-body">
							Webailesi müşteri paneli üzerindeki sol menüden "Muhasebe" kısmına tıklayın. Açılan sekme üzerinde bulunan "Kredi Yükle" sayfası üzerinden 7/24 kolayca bakiye yükleyebilir hizmetlerinize otomatik uzatma talimatı verebilir veyatta yüklediğiniz bakiyeler ile hiç bir kesinti olmadan dilediğiniz şekilde 7/24 alışveriş yapabilirsiniz. Yüklediğiniz krediler üzerinden ne kadar süre geçsede hesabınızdan asla silinmez ve siz kullanana kadar sizi bekler.
						</div>
					</div>
				</div>
				<div class="accordion-item">
					<h5 class="accordion-header" id="head5">
						<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse5" aria-expanded="false" aria-controls="collapse5">
							Bir işlemi yaparken sorun yaşıyorum?
						</button>
					</h5>
					<div id="collapse5" class="accordion-collapse collapse" aria-labelledby="head5" data-bs-parent="#accordionExample">
						<div class="accordion-body">
							Endişe etmenize gerek yok. Webailesi müşteri paneli üzerinde bulunan "Destek-Sistemi" sekmesi üzerinden 7/24 webailesi çalışanları ile iletişim kurabilirsiniz. Webailesi görevlileri konu ne olursa olsun 7/24 daima sizin sorunlarınıza çözüm üretmek için yanınızda olacaktır. Tüm soru ve sorunlarınız için 7/24 destek talebi açabilir veyatta webailesi.com adresine ait olan her hangi bir iletişim kanalı üzerinden iletişim kurabilirsiniz.
						</div>
					</div>
				</div>

			</div>
		</div>
	</div>
</div>
@endsection