@extend('laylout')
@section('headerinclude')
<meta name="description" content="Webailesi.com satış sistemi" />
<script type="text/javascript" src="assets/premium/jscripts/bootstrap.bundle.min.js?ver=1850"></script>
<style>
    .form-center {
        display: flex;
        flex-direction: column;
        align-items: center;
    }
    .form-group {
        margin-top: 10px;
        margin-bottom: 10px;
    }
    .form-group label {
        color: #6c757d;
    }
    .input-group {
        position: relative;
        height: calc(3.4rem + 2px);
    }
    .input-group input {
        text-indent: 35px;
    }
    .input-group input[type="tel"]{
        width: 100%;
        height: calc(3.4rem + 2px);
        text-indent: 0px;
    }
    .input-icon {
        width: 40px;
        height: calc(3.4rem + 2px);
        position: absolute;
        z-index: 4;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .input-icon i {
        color: #b1b1b1;
        font-size: 18px;
    }
    .form-control:focus {
        box-shadow: none;
    }
</style>
@endsection
@section('content')
<div class="container my-3">
    <div class="row justify-content-center pt-5 pt-sm-5 pt-md-5 pt-lg-0"> 
        <div class="col-md-4" style="height: inherit;">
            <div class="card card-stretch h-100">
                <div class="card-body pb-0 ">
                    <div class="d-flex flex-column h-100">
                        <h3 class="text-dark text-center pt-15 lh-lg" style="font-size: 24px;">Üyeliğiniz bulunmuyor mu ? <br>Hemen üyelik oluşturun</h3>
                        <div class="text-center pt-7 mt-5">
                            <a href="{$mybb->settings['systemurl']}uyelik/kayit-ol" class="btn btn-success fw-bolder fs-6 px-7 py-2">Kayıt Ol</a>
                        </div>
                        <div class="flex-grow-1 bgi-no-repeat bgi-size-contain bgi-position-x-center bgi-position-y-bottom card-rounded-bottom h-200px" style="background-image: url(https://www.webailesi.com/premium/img/emirhan.png);background-size: contain;border-bottom-left-radius: .65rem;border-bottom-right-radius: .65rem;background-position-x: center;background-position-y: bottom;background-repeat: no-repeat;height: 200px!important;"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-8">
            <div class="card login-signup-card mb-0">
                <div id="loginCart" class="card-body row px-md-5 py-5"> 
                    <div class="col-md-12 col-lg-12 border-right cart-flex-login"> 
                        <div class="mb-0 text-center"> 
                            <h5 class="h3" style="font-size:23px;font-weight:400">Şifremi Unuttum</h5>
                        </div>
                        <div class="form-center mt-3">
                            <div id="mailArea" class="form-group col-md-6"> 
                                <label class="pb-1">E-Posta Adresi</label> 
                                <div class="input-group input-group-merge">
                                    <div class="input-icon"> 
                                        <i class="ri-mail-line"></i>
                                    </div> 
                                    <input type="text" class="form-control" name="mail" autocomplete="false" id="mail" autofocus="" placeholder="E-Posta Adresi"> 
                                </div> 
                            </div>
                            <div><h5 class="text-danger">YADA</h5></div>
                            <div id="phoneArea" class="form-group col-md-6"> 
                                <label class="pb-1">Telefon Numarası</label> 
                                <div class="input-group input-group-merge">
                                    <div class="input-icon"> 
                                        <i class="ri-phone-line"></i>
                                    </div> 
                                    <input type="text" class="form-control" name="phone" autocomplete="false" id="phone" placeholder="Telefon Numarası"> 
                                </div> 
                            </div>
                            <div id="smsCode" class="form-group col-md-6" style="display:none">
                                <label class="pb-1">Gelen SMS Kodu</label> 
                                <div class="input-group input-group-merge">
                                    <div class="input-icon"> 
                                        <i class="ri-phone-line"></i>
                                    </div> 
                                    <input type="text" class="form-control" name="code" autocomplete="false" id="code" placeholder="Telefonunza gelen SMS'in 6 haneli kodunu giriniz"> 
                                </div> 
                            </div>
                            <div class="w-100 d-flex justify-content-end mt-4 mb-4">
                                <a class="btn btn-special border-radius mobile" href="tel://+908503083156">Erişimim Yok</a> 
                                <button class="btn btn-special border-radius resetPassword" style="margin-left:10px">Gönder</button> 
                            </div>	
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
var first = true;
$(".resetPassword").on("click",function(){
    if(first){
        $.ajax({
            url: "{{ beGetRoute('auth.forgetpassword.post') }}",
            type: "post",
            data: {action:"reset_password",mail:$("#mail").val(),phone:$("#phone").val()},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $.Toast("Başarılı",response.message,"success");
                    if(response.type == 1){
                        $("#mailArea").hide();
                        $("#phoneArea").hide();		
                        $("#smsCode").show();
                        $(".resetPassword").html("Kodu Onayla");
                        first = false;
                    }
                    else{
                        setTimeout(function(){
                            window.location.href = response.url;
                        },1000);								
                    }
                }
                else{
                    $.Toast("Bir Hata Oluştu",response.message,"error");
                }
            }
        });							
    }
    else{
        $.ajax({
            url: "{{ beGetRoute('auth.forgetpassword.post') }}",
            type: "post",
            data: {action:"code_approve",code:$("#code").val()},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $.Toast("Başarılı",response.message,"success");
                    setTimeout(function(){
                        window.location.href = response.url;
                    },1000);						
                }
                else{
                    $.Toast("Bir Hata Oluştu",response.message,"error");
                }
            }
        });							
    }				
    return false;
});
</script>
@endsection