@extend('admin.laylout')
@section('headerinclude')
<style>
.tabs .tab {
    display: none;
}
.tabs .tab.active {
    display: block;
}
</style>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="d-flex flex-column flex-lg-row">
            <div class="flex-column flex-lg-row-auto w-lg-250px w-xl-350px mb-10">
                <div class="card mb-5 mb-xl-8">
                    <div class="card-body">
                        <div class="d-flex flex-center flex-column py-5">
                            <a href="#" class="fs-3 text-gray-800 text-hover-primary fw-bold mb-3">
                                {{ $user['username'] }}
                            </a>
                            <div class="mb-9 mt-5">
                                <div class="badge badge-lg badge-light-primary d-inline">{{ $usergroup['ugname'] }}</div>
                            </div>
                            <div class="row">
                                <div class="border border-gray-300 border-dashed rounded py-3 px-3 mb-3">
                                    <div class="fs-4 fw-bold text-gray-700">
                                        <span class="w-75px" id="orderCount">0 Adet</span>
                                        <span class="svg-icon svg-icon-3 svg-icon-success">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <rect opacity="0.5" x="13" y="6" width="13" height="2" rx="1" transform="rotate(90 13 6)" fill="currentColor"></rect>
                                            <path d="M12.5657 8.56569L16.75 12.75C17.1642 13.1642 17.8358 13.1642 18.25 12.75C18.6642 12.3358 18.6642 11.6642 18.25 11.25L12.7071 5.70711C12.3166 5.31658 11.6834 5.31658 11.2929 5.70711L5.75 11.25C5.33579 11.6642 5.33579 12.3358 5.75 12.75C6.16421 13.1642 6.83579 13.1642 7.25 12.75L11.4343 8.56569C11.7467 8.25327 12.2533 8.25327 12.5657 8.56569Z" fill="currentColor"></path>
                                        </svg>
                                        </span>
                                    </div>
                                    <div class="fw-semibold text-muted">Hizmet</div>
                                </div>
                                <div class="border border-gray-300 border-dashed rounded py-3 px-3 mb-3">
                                    <div class="fs-4 fw-bold text-gray-700">
                                        <span class="w-50px" id="invoiceCount">0 Adet</span>
                                        <span class="svg-icon svg-icon-3 svg-icon-danger">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <rect opacity="0.5" x="11" y="18" width="13" height="2" rx="1" transform="rotate(-90 11 18)" fill="currentColor"></rect>
                                            <path d="M11.4343 15.4343L7.25 11.25C6.83579 10.8358 6.16421 10.8358 5.75 11.25C5.33579 11.6642 5.33579 12.3358 5.75 12.75L11.2929 18.2929C11.6834 18.6834 12.3166 18.6834 12.7071 18.2929L18.25 12.75C18.6642 12.3358 18.6642 11.6642 18.25 11.25C17.8358 10.8358 17.1642 10.8358 16.75 11.25L12.5657 15.4343C12.2533 15.7467 11.7467 15.7467 11.4343 15.4343Z" fill="currentColor"></path>
                                        </svg>
                                        </span>
                                    </div>
                                    <div class="fw-semibold text-muted">Fatura</div>
                                </div>
                                <div class="border border-gray-300 border-dashed rounded py-3 px-3 mb-3">
                                    <div class="fs-4 fw-bold text-gray-700">
                                        <span class="w-50px">{{ $user['money'] }}</span>
                                        <span class="svg-icon svg-icon-3 svg-icon-warning">
                                            {{ $usercurrencie['cicon'] }}
                                        </span>
                                    </div>
                                    <div class="fw-semibold text-muted">{{ $usercurrencie['cname'] }}</div>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex flex-stack fs-4 py-3">
                            <div class="fw-bold rotate collapsible" data-bs-toggle="collapse" href="#detaylar" role="button" aria-expanded="false" aria-controls="kt_user_view_details">
                                Detaylar
                                <span class="ms-2 rotate-180">
                                    <span class="svg-icon svg-icon-3">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M11.4343 12.7344L7.25 8.55005C6.83579 8.13583 6.16421 8.13584 5.75 8.55005C5.33579 8.96426 5.33579 9.63583 5.75 10.05L11.2929 15.5929C11.6834 15.9835 12.3166 15.9835 12.7071 15.5929L18.25 10.05C18.6642 9.63584 18.6642 8.96426 18.25 8.55005C17.8358 8.13584 17.1642 8.13584 16.75 8.55005L12.5657 12.7344C12.2533 13.0468 11.7467 13.0468 11.4343 12.7344Z" fill="currentColor"></path>
                                        </svg>
                                    </span>
                                </span>
                            </div>
                            <span data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-original-title="Edit customer details" data-kt-initialized="1">
                                <a href="#" class="btn btn-sm btn-light-primary" data-bs-toggle="modal" data-bs-target="#beUpdateUser">
                                    Düzenle
                                </a>
                            </span>
                        </div>
                        <div class="separator"></div>
                        <div id="detaylar" class="collapse show">
                        <div class="pb-5 fs-6">
                            <div class="fw-bold mt-5">Hesap ID</div>
                            <div class="text-gray-600"># {{ $user['uid'] }}</div>
                            <div class="fw-bold mt-5">Email</div>
                            <div class="text-gray-600"><a href="mail:{{ $user['email'] }}" class="text-gray-600 text-hover-primary">{{ $user['email'] }}</a></div>
                            <div class="fw-bold mt-5">Para Birimi</div>
                            <div class="text-gray-600">{{ $usercurrencie['cname'] }}</div>
                            <div class="fw-bold mt-5">Dil</div>
                            <div class="text-gray-600">{{ $userlanguage['lname'] }}</div>
                            <div class="fw-bold mt-5">Kayıt Tarihi</div>
                            <div class="text-gray-600">{{ date('d.m.Y',$user['regdate']) }}</div>
                        </div>
                        </div>
                    </div>
                </div>
                <div class="card mb-5 mb-xl-8">
                    <div class="card-header border-0">
                        <div class="card-title">
                        <h3 class="fw-bold m-0">Connected Accounts</h3>
                        </div>
                    </div>
                    <div class="card-body pt-2">
                        <div class="notice d-flex bg-light-primary rounded border-primary border border-dashed mb-9 p-6">
                        <span class="svg-icon svg-icon-2tx svg-icon-primary me-4">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path opacity="0.3" d="M22 19V17C22 16.4 21.6 16 21 16H8V3C8 2.4 7.6 2 7 2H5C4.4 2 4 2.4 4 3V19C4 19.6 4.4 20 5 20H21C21.6 20 22 19.6 22 19Z" fill="currentColor"></path>
                                <path d="M20 5V21C20 21.6 19.6 22 19 22H17C16.4 22 16 21.6 16 21V8H8V4H19C19.6 4 20 4.4 20 5ZM3 8H4V4H3C2.4 4 2 4.4 2 5V7C2 7.6 2.4 8 3 8Z" fill="currentColor"></path>
                            </svg>
                        </span>
                        <div class="d-flex flex-stack flex-grow-1 ">
                            <div class=" fw-semibold">
                                <div class="fs-6 text-gray-700 ">By connecting an account, you hereby agree to our <a href="#" class="me-1">privacy policy</a> and <a href="#">terms of use</a>.</div>
                            </div>
                        </div>
                        </div>
                        <div class="py-2">
                        <div class="d-flex flex-stack">
                            <div class="d-flex">
                                <img src="/metronic8/demo1/assets/media/svg/brand-logos/google-icon.svg" class="w-30px me-6" alt="">
                                <div class="d-flex flex-column">
                                    <a href="#" class="fs-5 text-dark text-hover-primary fw-bold">Google</a>
                                    <div class="fs-6 fw-semibold text-muted">Plan properly your workflow</div>
                                </div>
                            </div>
                            <div class="d-flex justify-content-end">
                                <label class="form-check form-switch form-switch-sm form-check-custom form-check-solid">
                                <input class="form-check-input" name="google" type="checkbox" value="1" id="kt_modal_connected_accounts_google" checked="checked">
                                <span class="form-check-label fw-semibold text-muted" for="kt_modal_connected_accounts_google"></span>
                                </label>
                            </div>
                        </div>
                        <div class="separator separator-dashed my-5"></div>
                        <div class="d-flex flex-stack">
                            <div class="d-flex">
                                <img src="/metronic8/demo1/assets/media/svg/brand-logos/github.svg" class="w-30px me-6" alt="">
                                <div class="d-flex flex-column">
                                    <a href="#" class="fs-5 text-dark text-hover-primary fw-bold">Github</a>
                                    <div class="fs-6 fw-semibold text-muted">Keep eye on on your Repositories</div>
                                </div>
                            </div>
                            <div class="d-flex justify-content-end">
                                <label class="form-check form-switch form-switch-sm form-check-custom form-check-solid">
                                <input class="form-check-input" name="github" type="checkbox" value="1" id="kt_modal_connected_accounts_github" checked="checked">
                                <span class="form-check-label fw-semibold text-muted" for="kt_modal_connected_accounts_github"></span>
                                </label>
                            </div>
                        </div>
                        <div class="separator separator-dashed my-5"></div>
                        <div class="d-flex flex-stack">
                            <div class="d-flex">
                                <img src="/metronic8/demo1/assets/media/svg/brand-logos/slack-icon.svg" class="w-30px me-6" alt="">
                                <div class="d-flex flex-column">
                                    <a href="#" class="fs-5 text-dark text-hover-primary fw-bold">Slack</a>
                                    <div class="fs-6 fw-semibold text-muted">Integrate Projects Discussions</div>
                                </div>
                            </div>
                            <div class="d-flex justify-content-end">
                                <label class="form-check form-switch form-switch-sm form-check-custom form-check-solid">
                                <input class="form-check-input" name="slack" type="checkbox" value="1" id="kt_modal_connected_accounts_slack">
                                <span class="form-check-label fw-semibold text-muted" for="kt_modal_connected_accounts_slack"></span>
                                </label>
                            </div>
                        </div>
                        </div>
                    </div>
                    <div class="card-footer border-0 d-flex justify-content-center pt-0">
                        <button class="btn btn-sm  btn-light-primary">Save Changes</button>
                    </div>
                </div>
            </div>
            <div class="flex-lg-row-fluid ms-lg-15">
                <ul class="nav nav-custom nav-tabs nav-line-tabs nav-line-tabs-2x border-0 fs-4 fw-semibold mb-8" role="tablist">
                    <li class="nav-item" role="presentation">
                        <a class="nav-link text-active-primary pb-4 active" data-bs-toggle="tab" href="#beGlobal" aria-selected="true" role="tab">Genel</a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link text-active-primary pb-4" data-kt-countup-tabs="true" data-bs-toggle="tab" href="#beSettings" data-kt-initialized="1" aria-selected="false" role="tab" tabindex="-1">Ayarlar</a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link text-active-primary pb-4" data-kt-countup-tabs="true" data-bs-toggle="tab" href="#beOrders" data-kt-initialized="1" aria-selected="false" role="tab" tabindex="-1">Hizmetler</a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link text-active-primary pb-4" data-kt-countup-tabs="true" data-bs-toggle="tab" href="#beInvoices" data-kt-initialized="1" aria-selected="false" role="tab" tabindex="-1">Faturalar</a>
                    </li>
                    @foreach($tabs as $key => $value)
                    <li class="nav-item" role="presentation">
                        <a class="nav-link text-active-primary pb-4" data-kt-countup-tabs="true" data-bs-toggle="tab" href="#{{ $key }}" data-kt-initialized="1" aria-selected="false" role="tab" tabindex="-1">{{ $value['name'] }}</a>
                    </li>
                    @endforeach
                    <li class="nav-item ms-auto">
                        <a href="#" class="btn btn-primary ps-7" data-kt-menu-trigger="click" data-kt-menu-attach="parent" data-kt-menu-placement="bottom-end">
                        İşlemler
                        <span class="svg-icon svg-icon-2 me-0">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M11.4343 12.7344L7.25 8.55005C6.83579 8.13583 6.16421 8.13584 5.75 8.55005C5.33579 8.96426 5.33579 9.63583 5.75 10.05L11.2929 15.5929C11.6834 15.9835 12.3166 15.9835 12.7071 15.5929L18.25 10.05C18.6642 9.63584 18.6642 8.96426 18.25 8.55005C17.8358 8.13584 17.1642 8.13584 16.75 8.55005L12.5657 12.7344C12.2533 13.0468 11.7467 13.0468 11.4343 12.7344Z" fill="currentColor"></path>
                            </svg>
                        </span>
                        </a>
                        <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-800 menu-state-bg-light-primary fw-semibold py-4 w-250px fs-6" data-kt-menu="true">
                        <div class="menu-item px-5">
                            <div class="menu-content text-muted pb-2 px-5 fs-7 text-uppercase">
                                Payments
                            </div>
                        </div>
                        <div class="menu-item px-5">
                            <a href="#" class="menu-link px-5">
                            Create invoice
                            </a>
                        </div>
                        <div class="menu-item px-5">
                            <a href="#" class="menu-link flex-stack px-5">
                            Create payments
                            <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip" aria-label="Specify a target name for future usage and reference" data-bs-original-title="Specify a target name for future usage and reference" data-kt-initialized="1"></i>
                            </a>
                        </div>
                        <div class="menu-item px-5" data-kt-menu-trigger="hover" data-kt-menu-placement="left-start">
                            <a href="#" class="menu-link px-5">
                            <span class="menu-title">Subscription</span>
                            <span class="menu-arrow"></span>
                            </a>
                            <div class="menu-sub menu-sub-dropdown w-175px py-4">
                                <div class="menu-item px-3">
                                    <a href="#" class="menu-link px-5">
                                    Apps
                                    </a>
                                </div>
                                <div class="menu-item px-3">
                                    <a href="#" class="menu-link px-5">
                                    Billing
                                    </a>
                                </div>
                                <div class="menu-item px-3">
                                    <a href="#" class="menu-link px-5">
                                    Statements
                                    </a>
                                </div>
                                <div class="separator my-2"></div>
                                <div class="menu-item px-3">
                                    <div class="menu-content px-3">
                                    <label class="form-check form-switch form-check-custom form-check-solid">
                                    <input class="form-check-input w-30px h-20px" type="checkbox" value="" name="notifications" checked="" id="kt_user_menu_notifications">
                                    <span class="form-check-label text-muted fs-6" for="kt_user_menu_notifications">
                                    Notifications
                                    </span>
                                    </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="separator my-3"></div>
                        <div class="menu-item px-5">
                            <div class="menu-content text-muted pb-2 px-5 fs-7 text-uppercase">
                                Account
                            </div>
                        </div>
                        <div class="menu-item px-5">
                            <a href="#" class="menu-link px-5">
                            Reports
                            </a>
                        </div>
                        <div class="menu-item px-5 my-1">
                            <a href="#" class="menu-link px-5">
                            Account Settings
                            </a>
                        </div>
                        <div class="menu-item px-5">
                            <a href="#" class="menu-link text-danger px-5">
                            Delete customer
                            </a>
                        </div>
                        </div>
                    </li>
                </ul>
                <div class="tab-content" id="myTabContent">
                    <div class="tab-pane fade active show" id="beGlobal" role="tabpanel">
                        <div class="card pt-4 mb-6 mb-xl-9">
                            <div class="card-header border-0">
                                <div class="card-title flex-column">
                                    <h2 class="mb-1">Kullanıcı Bakiyesi</h2>
                                    <div class="fs-6 fw-semibold text-muted">Kullanıcının bakiye ile ilgili işlemlerini ayarlayın</div>
                                </div>
                                <div class="card-toolbar">
                                    <button type="button" class="btn btn-light-primary btn-sm" data-bs-toggle="modal" data-bs-target="#beUserMoney">
                                        <span class="svg-icon svg-icon-3">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path opacity="0.3" d="M21 10.7192H3C2.4 10.7192 2 11.1192 2 11.7192C2 12.3192 2.4 12.7192 3 12.7192H6V14.7192C6 18.0192 8.7 20.7192 12 20.7192C15.3 20.7192 18 18.0192 18 14.7192V12.7192H21C21.6 12.7192 22 12.3192 22 11.7192C22 11.1192 21.6 10.7192 21 10.7192Z" fill="currentColor"></path>
                                                <path d="M11.6 21.9192C11.4 21.9192 11.2 21.8192 11 21.7192C10.6 21.4192 10.5 20.7191 10.8 20.3191C11.7 19.1191 12.3 17.8191 12.7 16.3191C12.8 15.8191 13.4 15.4192 13.9 15.6192C14.4 15.7192 14.8 16.3191 14.6 16.8191C14.2 18.5191 13.4 20.1192 12.4 21.5192C12.2 21.7192 11.9 21.9192 11.6 21.9192ZM8.7 19.7192C10.2 18.1192 11 15.9192 11 13.7192V8.71917C11 8.11917 11.4 7.71917 12 7.71917C12.6 7.71917 13 8.11917 13 8.71917V13.0192C13 13.6192 13.4 14.0192 14 14.0192C14.6 14.0192 15 13.6192 15 13.0192V8.71917C15 7.01917 13.7 5.71917 12 5.71917C10.3 5.71917 9 7.01917 9 8.71917V13.7192C9 15.4192 8.4 17.1191 7.2 18.3191C6.8 18.7191 6.9 19.3192 7.3 19.7192C7.5 19.9192 7.7 20.0192 8 20.0192C8.3 20.0192 8.5 19.9192 8.7 19.7192ZM6 16.7192C6.5 16.7192 7 16.2192 7 15.7192V8.71917C7 8.11917 7.1 7.51918 7.3 6.91918C7.5 6.41918 7.2 5.8192 6.7 5.6192C6.2 5.4192 5.59999 5.71917 5.39999 6.21917C5.09999 7.01917 5 7.81917 5 8.71917V15.7192V15.8191C5 16.3191 5.5 16.7192 6 16.7192ZM9 4.71917C9.5 4.31917 10.1 4.11918 10.7 3.91918C11.2 3.81918 11.5 3.21917 11.4 2.71917C11.3 2.21917 10.7 1.91916 10.2 2.01916C9.4 2.21916 8.59999 2.6192 7.89999 3.1192C7.49999 3.4192 7.4 4.11916 7.7 4.51916C7.9 4.81916 8.2 4.91918 8.5 4.91918C8.6 4.91918 8.8 4.81917 9 4.71917ZM18.2 18.9192C18.7 17.2192 19 15.5192 19 13.7192V8.71917C19 5.71917 17.1 3.1192 14.3 2.1192C13.8 1.9192 13.2 2.21917 13 2.71917C12.8 3.21917 13.1 3.81916 13.6 4.01916C15.6 4.71916 17 6.61917 17 8.71917V13.7192C17 15.3192 16.8 16.8191 16.3 18.3191C16.1 18.8191 16.4 19.4192 16.9 19.6192C17 19.6192 17.1 19.6192 17.2 19.6192C17.7 19.6192 18 19.3192 18.2 18.9192Z" fill="currentColor"></path>
                                            </svg>
                                        </span>
                                        Bakiye Ayarları
                                    </button>
                                </div>
                            </div>
                            <div class="card-body pb-5">
                                <div class="d-flex flex-stack">
                                    <div class="d-flex flex-column">
                                        <span>Bakiye</span>
                                        <span class="text-muted fs-6">{{ $user['money'] }} {{ $usercurrencie['cicon'] }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card card-flush mb-6 mb-xl-9">
                            <div class="card-header mt-6">
                                <div class="card-title flex-column">
                                    <h2 class="mb-1">Notlar</h2>
                                </div>
                            </div>
                            <form id="noteForm" class="card-body">
                                <div class="row">
                                    <div class="col-12 mb-9">
                                        <textarea class="form-control" name="note" rows="7">{{ $userinfo['uinote'] }}</textarea>
                                    </div>
                                    <div class="col-12">
                                        <button class="btn btn-success d-block m-auto noteSaveForm">Kaydet</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="beSettings" role="tabpanel">
                        <div class="card pt-4 mb-6 mb-xl-9">
                            <div class="card-header border-0">
                                <div class="card-title">
                                    Seçenekler
                                </div>
                            </div>
                            <form id="settingForm" class="card-body">
                                <div class="row">
                                    <div class="col-xl-6">
                                        <div class="row">
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">SMS Bilgilendirmesi</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Kullanıcılara satın alım vs gibi durumlarda sms yollar.</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="sms_alert" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="sms_alert" value="1"{{ $uisettings['sms_alert'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Mail Bilgilendirmesi</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Kullanıcılara satın alım vs gibi durumlarda mail yollar.</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="mail_alert" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="mail_alert" value="1"{{ $uisettings['mail_alert'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Bildirim Bilgilendirmesi</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Kullanıcılara satın alım vs gibi durumlarda bildirim yollar.</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="notification_alert" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="notification_alert" value="1"{{ $uisettings['notification_alert'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="row">
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Otomatik Ödeme İzni</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Kullanıcının otomatik ödemeyi açıp açamayacağını belirler!</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="order_auto_pay" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="order_auto_pay" value="1"{{ $uisettings['order_auto_pay'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Vergi Muafiyeti</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Kullanıcıdan faturalar için katma değer vergisi ödememesini sağlar.</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="invoice_tax_exemption" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="invoice_tax_exemption" value="1"{{ $uisettings['invoice_tax_exemption'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Fatura Gecikme Ücreti</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Fatura ödemesi geçtiğinde faturayı zamlandır</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="invoice_latefee" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="invoice_latefee" value="1"{{ $uisettings['invoice_latefee'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-12">
                                        <hr>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="row">
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Destek Talebi</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Kullanıcı destek talebi açabilir.</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="ticket_create" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="ticket_create" value="1"{{ $uisettings['ticket_create'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Tek Destek Talebi</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Bu kullanıcının aynı anda tek bir destek talebi olabilir</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="ticket_onlyone" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="ticket_onlyone" value="1"{{ $uisettings['ticket_onlyone'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Destek Dosyası</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Kullanıcı taleplere dosya yükleyebilir</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="ticket_files" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="ticket_files" value="1"{{ $uisettings['ticket_files'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button class="btn btn-success d-block m-auto settingSaveForm">Kaydet</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="beOrders" role="tabpanel">
                        <div class="card pt-4 mb-6 mb-xl-9">
                            <div class="card-header border-0">
                                <div class="card-title">
                                    Kullanıcı Ürünleri
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                                    <thead>
                                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                                            <th class="text-center align-middle">#</th>
                                            <th class="text-center align-middle">Ürün</th>
                                            <th class="text-center align-middle">Sahip</th>
                                            <th class="text-center align-middle">Durum</th>
                                            <th class="text-center align-middle">Yenlieme Fiyatı</th>
                                            <th class="text-center align-middle">Tarihler</th>
                                            <th class="text-center align-middle">Düzenle</th>
                                        </tr>
                                    </thead>
                                    <tbody id="orderList">

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="beInvoices" role="tabpanel">
                        <div class="d-flex justify-content-end">
                            <a href="{{ beGetRoute('admin.invoice.add') }}?user={{ $user['uid'] }}" class="d-inline-flex align-items-center btn btn-primary mb-5 mx-3">
                                <span class="svg-icon svg-icon-muted d-flex align-items-center">
                                    <svg width="23" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"></rect>
                                        <rect x="10.8891" y="17.8033" width="12" height="2" rx="1" transform="rotate(-90 10.8891 17.8033)" fill="currentColor"></rect>
                                        <rect x="6.01041" y="10.9247" width="12" height="2" rx="1" fill="currentColor"></rect>
                                    </svg>
                                </span>
                                Yeni Fatura Oluştur
                            </a>
                        </div>
                        <div class="card pt-4 mb-6 mb-xl-9">
                            <div class="card-header border-0">
                                <div class="card-title">
                                    Kullanıcı Faturaları
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                                    <thead>
                                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                                            <th class="text-center align-middle">#</th>
                                            <th class="text-center align-middle">Sahip</th>
                                            <th class="text-center align-middle">Açıklama</th>
                                            <th class="text-center align-middle">Durum</th>
                                            <th class="text-center align-middle">Fatura Tipi</th>
                                            <th class="text-center align-middle">Fatura Durumu</th>
                                            <th class="text-center align-middle">Tutar</th>
                                            <th class="text-center align-middle">KDV</th>
                                            <th class="text-center align-middle">İndirim</th>
                                            <th class="text-center align-middle">Toplam</th>
                                            <th class="text-center align-middle">Ödenme Methodu</th>
                                            <th class="text-center align-middle">Bitiş Tarihi</th>
                                            <th class="text-center align-middle">Oluşturulma Tarihi</th>
                                            <th class="text-center align-middle">Düzenle</th>
                                        </tr>
                                    </thead>
                                    <tbody id="invoiceList">

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    @foreach($tabs as $key => $value)
                    <div class="tab-pane fade" id="{{ $key }}" role="tabpanel">
                        {{ $value['template'] }}
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
        <div class="modal fade" id="beUpdateUser" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered mw-650px">
                <div class="modal-content">
                    <form class="form" id="userForm">
                        <div class="modal-header">
                            <h2 class="fw-bold">Kullanıcı Düzenle</h2>
                            <div class="btn btn-icon btn-sm btn-active-icon-primary" data-kt-users-modal-action="close">
                                <span class="svg-icon svg-icon-1">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="currentColor"/>
                                        <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="currentColor"/>
                                    </svg>
                                </span>
                            </div>
                        </div>
                        <div class="modal-body py-10 px-lg-17">
                            <div class="d-flex flex-column scroll-y me-n7 pe-7" id="kt_modal_update_user_scroll" data-kt-scroll="true" data-kt-scroll-activate="{default: false, lg: true}" data-kt-scroll-max-height="auto" data-kt-scroll-dependencies="#kt_modal_update_user_header" data-kt-scroll-wrappers="#kt_modal_update_user_scroll" data-kt-scroll-offset="300px">
                                <div class="fw-bolder fs-3 rotate collapsible mb-7" data-bs-toggle="collapse" href="#kt_modal_update_user_user_info" role="button" aria-expanded="false" aria-controls="kt_modal_update_user_user_info">
                                    Kullanıcı Bilgileri
                                    <span class="ms-2 rotate-180">
                                        <span class="svg-icon svg-icon-3">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M11.4343 12.7344L7.25 8.55005C6.83579 8.13583 6.16421 8.13584 5.75 8.55005C5.33579 8.96426 5.33579 9.63583 5.75 10.05L11.2929 15.5929C11.6834 15.9835 12.3166 15.9835 12.7071 15.5929L18.25 10.05C18.6642 9.63584 18.6642 8.96426 18.25 8.55005C17.8358 8.13584 17.1642 8.13584 16.75 8.55005L12.5657 12.7344C12.2533 13.0468 11.7467 13.0468 11.4343 12.7344Z" fill="currentColor"/>
                                            </svg>
                                        </span>
                                    </span>
                                </div>
                                <div id="kt_modal_update_user_user_info" class="collapse show">
                                    <div class="fv-row mb-7">
                                        <label class="fs-6 fw-semibold mb-2">Ad</label>
                                        <input type="text" class="form-control form-control-solid" placeholder="" name="name" value="{{ $user['name'] }}" />
                                    </div>
                                    <div class="fv-row mb-7">
                                        <label class="fs-6 fw-semibold mb-2">Soyad</label>
                                        <input type="text" class="form-control form-control-solid" placeholder="" name="surname" value="{{ $user['surname'] }}" />
                                    </div>
                                    <div class="fv-row mb-7">
                                        <label class="fs-6 fw-semibold mb-2">
                                            <span>Mail</span>
                                            <i class="fas fa-exclamation-circle ms-1 fs-7" data-bs-toggle="tooltip" title="Lütfen kullanılabilir bir mail adresi girin"></i>
                                        </label>
                                        <input type="email" class="form-control form-control-solid" placeholder="" name="email" value="{{ $user['email'] }}" />
                                    </div>
                                    <div class="fv-row mb-7">
                                        <label class="fs-6 fw-semibold mb-2">
                                            <span>Şifre</span>
                                            <i class="fas fa-exclamation-circle ms-1 fs-7" data-bs-toggle="tooltip" title="Lütfen şifreyi girdikten sonra kontrol ediniz"></i>
                                        </label>
                                        <input type="text" class="form-control form-control-solid" placeholder="*****" name="password" value="" />
                                    </div>
                                    <div class="fv-row mb-7">
                                        <label class="fs-6 fw-semibold mb-2">Dil</label>
                                        <select class="form-control form-control-select" name="language">
                                            @foreach($languages as $language)
                                                <option value="{{ $language['lid'] }}"{{ $userlanguage['lid'] == $language['lid'] ? ' selected':'' }}>{{ $language['lname'] }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="fv-row mb-7">
                                        <label class="fs-6 fw-semibold mb-2">Para Birimi</label>
                                        <select class="form-control form-control-select" name="currencie">
                                            @foreach($currencies as $currencie)
                                                <option value="{{ $currencie['cid'] }}"{{ $usercurrencie['cid'] == $currencie['cid'] ? ' selected':'' }}>{{ $currencie['cname'] }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="fw-bolder fs-3 rotate collapsible mb-7" data-bs-toggle="collapse" href="#kt_modal_update_user_address" role="button" aria-expanded="false" aria-controls="kt_modal_update_user_address">
                                    Kullanıcı Detayları
                                    <span class="ms-2 rotate-180">
                                        <span class="svg-icon svg-icon-3">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M11.4343 12.7344L7.25 8.55005C6.83579 8.13583 6.16421 8.13584 5.75 8.55005C5.33579 8.96426 5.33579 9.63583 5.75 10.05L11.2929 15.5929C11.6834 15.9835 12.3166 15.9835 12.7071 15.5929L18.25 10.05C18.6642 9.63584 18.6642 8.96426 18.25 8.55005C17.8358 8.13584 17.1642 8.13584 16.75 8.55005L12.5657 12.7344C12.2533 13.0468 11.7467 13.0468 11.4343 12.7344Z" fill="currentColor"/>
                                            </svg>
                                        </span>
                                    </span>
                                </div>
                                <div id="kt_modal_update_user_address" class="collapse show">
                                    <div class="fv-row mb-7">
                                        <label class="fs-6 fw-semibold mb-2">Telefon Ülke Kodu</label>
                                        <input type="text" class="form-control form-control-solid" placeholder="" name="dial" value="{{ $userinfo['uidial'] }}" />
                                    </div>
                                    <div class="fv-row mb-7">
                                        <label class="fs-6 fw-semibold mb-2">Telefon Numarası</label>
                                        <input type="text" class="form-control form-control-solid" placeholder="" name="phone" value="{{ $userinfo['uiphone'] }}" />
                                    </div>
                                    <div class="fv-row mb-7">
                                        <label class="fs-6 fw-semibold mb-2">Adres</label>
                                        <textarea class="form-control" name="address" rows="7">{{ $userinfo['uiaddress'] }}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer flex-center">
                            <button type="reset" class="btn btn-light me-3" data-kt-users-modal-action="cancel">
                                İptal
                            </button>
                            <button class="btn btn-primary userSaveForm">Kaydet</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="modal fade" id="beUserMoney" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered mw-650px">
                <div class="modal-content">
                    <form class="form" id="userMoneyForm">
                        <div class="modal-header">
                            <h2 class="fw-bold">Kullanıcı Bakiye İşlemleri</h2>
                            <div class="btn btn-icon btn-sm btn-active-icon-primary" data-kt-users-modal-action="close">
                                <span class="svg-icon svg-icon-1">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="currentColor"/>
                                        <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="currentColor"/>
                                    </svg>
                                </span>
                            </div>
                        </div>
                        <div class="modal-body py-10 px-lg-17">
                            <div class="d-flex flex-column scroll-y me-n7 pe-7" id="kt_modal_update_user_scroll" data-kt-scroll="true" data-kt-scroll-activate="{default: false, lg: true}" data-kt-scroll-max-height="auto" data-kt-scroll-dependencies="#kt_modal_update_user_header" data-kt-scroll-wrappers="#kt_modal_update_user_scroll" data-kt-scroll-offset="300px">
                                <div class="fw-bolder fs-3 rotate collapsible mb-7" data-bs-toggle="collapse" href="#beUserMoneySet" role="button" aria-expanded="false" aria-controls="beUserMoneySet">
                                    Kullanıcı Bakiye İşlemleri
                                    <span class="ms-2 rotate-180">
                                        <span class="svg-icon svg-icon-3">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M11.4343 12.7344L7.25 8.55005C6.83579 8.13583 6.16421 8.13584 5.75 8.55005C5.33579 8.96426 5.33579 9.63583 5.75 10.05L11.2929 15.5929C11.6834 15.9835 12.3166 15.9835 12.7071 15.5929L18.25 10.05C18.6642 9.63584 18.6642 8.96426 18.25 8.55005C17.8358 8.13584 17.1642 8.13584 16.75 8.55005L12.5657 12.7344C12.2533 13.0468 11.7467 13.0468 11.4343 12.7344Z" fill="currentColor"/>
                                            </svg>
                                        </span>
                                    </span>
                                </div>
                                <div id="beUserMoneySet" class="collapse show">
                                    <div class="row mb-7">
                                        <div class="col-md-6 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Tutar</label>
                                            <input type="text" class="form-control form-control-solid" placeholder="" name="amount"/>
                                        </div>
                                        <div class="col-md-6 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Para Birimi</label>
                                            <select class="form-control form-control-select" name="currencie">
                                                @foreach($currencies as $currencie)
                                                    <option value="{{ $currencie['cid'] }}"{{ $usercurrencie['cid'] == $currencie['cid'] ? ' selected':'' }}>{{ $currencie['cname'] }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-12">
                                            <label class="fs-6 fw-semibold mb-2">Türü</label>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-check form-check-custom form-check-solid">
                                                        <input class="form-check-input" type="radio" name="type" value="1" id="beAddMoney" checked="checked" />
                                                        <label class="form-check-label" for="beAddMoney">
                                                            Ekle
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-check form-check-custom form-check-solid">
                                                        <input class="form-check-input" type="radio" name="type" value="-1" id="beRemoveMoney"/>
                                                        <label class="form-check-label" for="beRemoveMoney">
                                                            Çıkar
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="fv-row mb-7">
                                        <label class="fs-6 fw-semibold mb-2">Açıklama</label>
                                        <textarea class="form-control" name="description" rows="7"></textarea>
                                    </div>
                                </div>
                                <div class="fw-bolder fs-3 rotate collapsible mb-7" data-bs-toggle="collapse" href="#beUserMoneyLogs" role="button" aria-expanded="false" aria-controls="beUserMoneyLogs">
                                    İşlem Kayıtları
                                    <span class="ms-2 rotate-180">
                                        <span class="svg-icon svg-icon-3">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M11.4343 12.7344L7.25 8.55005C6.83579 8.13583 6.16421 8.13584 5.75 8.55005C5.33579 8.96426 5.33579 9.63583 5.75 10.05L11.2929 15.5929C11.6834 15.9835 12.3166 15.9835 12.7071 15.5929L18.25 10.05C18.6642 9.63584 18.6642 8.96426 18.25 8.55005C17.8358 8.13584 17.1642 8.13584 16.75 8.55005L12.5657 12.7344C12.2533 13.0468 11.7467 13.0468 11.4343 12.7344Z" fill="currentColor"/>
                                            </svg>
                                        </span>
                                    </span>
                                </div>
                                <div id="beUserMoneyLogs" class="collapse show">
                                    <div class="fv-row mb-7">
                                        <div class="table-responsive">
                                            <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                                                <thead>
                                                    <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                                                        <th class="text-center align-middle">#</th>
                                                        <th class="text-center align-middle">İşlem</th>
                                                        <th class="text-center align-middle">Tarih</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($userlogs as $userlog)
                                                    @if($userlog['ltype'] != 'money_change')
                                                        @continue
                                                    @endif
                                                    <tr>
                                                        <td class="text-center align-middle">{{ $userlog['lid'] }}</td>
                                                        <td class="text-center align-middle">{{ $userlog['lmessage'] }}</td>
                                                        <td class="text-center align-middle">{{ beSpecialTime($userlog['ldateline']) }}</td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer flex-center">
                            <button type="reset" class="btn btn-light me-3" data-kt-users-modal-action="cancel">
                                İptal
                            </button>
                            <button class="btn btn-primary userMoneySaveForm">Kaydet</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var wait2 = false;
    $(".nameSaveForm").on("click",function(){
        if(!wait2){
            wait2 = true;
            $(".nameSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.user.name.save.post') }}",
                type: "post",
                async: true,
                data: $("#nameForm").serialize()+"&uid={{ $user['uid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait2 = false;
                    $(".nameSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".phoneSaveForm").on("click",function(){
        if(!wait2){
            wait2 = true;
            $(".phoneSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.user.phone.save.post') }}",
                type: "post",
                async: true,
                data: $("#phoneForm").serialize()+"&uid={{ $user['uid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait2 = false;
                    $(".phoneSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".noteSaveForm").on("click",function(){
        if(!wait2){
            wait2 = true;
            $(".noteSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.user.note.save.post') }}",
                type: "post",
                async: true,
                data: $("#noteForm").serialize()+"&uid={{ $user['uid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait2 = false;
                    $(".noteSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    var wait3 = false;
    $(".settingSaveForm").on("click",function(){
        if(!wait3){
            wait3 = true;
            $(".settingSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.user.setting.save.post') }}",
                type: "post",
                async: true,
                data: $("#settingForm").serialize()+"&uid={{ $user['uid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait3 = false;
                    $(".settingSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    var wait4 = false;
    $(".userSaveForm").on("click",function(){
        if(!wait4){
            wait4 = true;
            $(".userSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.user.save.post') }}",
                type: "post",
                async: true,
                data: $("#userForm").serialize()+"&uid={{ $user['uid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait4 = false;
                    $(".userSaveForm").html("Kaydet");
                    $("#beUpdateUser").modal("hide");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    var wait5 = false;
    $(".userMoneySaveForm").on("click",function(){
        if(!wait4){
            wait4 = true;
            $(".userMoneySaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.user.money.update.post') }}",
                type: "post",
                async: true,
                data: $("#userMoneyForm").serialize()+"&uid={{ $user['uid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait4 = false;
                    $(".userMoneySaveForm").html("Kaydet");
                    $("#beUserMoney").modal("hide");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    setTimeout(function(){
        $.ajax({
            url: "{{ beGetRoute('admin.order.search.post') }}",
            type: "post",
            data: {status:-2,product:0,user:"",uid:{{ $user['uid'] }},data:"",options:"",sort:0,page:0,pageitems:999},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#orderList").empty().append(response.html);
                    $("#orderCount").empty().append(response.ordercount+" Adet");
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
        $.ajax({
            url: "{{ beGetRoute('admin.invoice.search.post') }}",
            type: "post",
            data: {name:"",status:-2,type:-1,bill:-1,user:"",uid:{{ $user['uid'] }},sort:0,page:0,pageitems:999},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#invoiceList").empty().append(response.html);
                    $("#invoiceCount").empty().append(response.invoicecount+" Adet");
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
    },1000);
    $("#invoiceList").on("click",".btnDelete",function(){
        var iid = $(this).data("iid");
        Swal.fire({
            html: "Bu faturayı silmek istediğinize emin misiniz ?",
            icon: "info",
            buttonsStyling: false,
            showCancelButton: true,
            confirmButtonText: "Onaylıyorum",
            cancelButtonText: "Vazgeçtim",
            customClass: {
                confirmButton: "btn btn-primary",
                cancelButton: "btn btn-danger"
            }
        }).then((result) => {
            if(result.isConfirmed) {
                $.ajax({
                    url: "{{ beGetRoute('admin.invoice.delete.post') }}",
                    type: "post",
                    data: {iid:iid},
                    dataType: "json",
                    crossDomain: true,
                    success: function(response){
                        if(response.status){
                            $("#"+iid+"Row").remove();
                            Swal.fire("Başarılı",response.message,"success");
            
                        }
                        else{
                            Swal.fire("Bir Hata Oluştu",response.message,"error");
                        }
                    }
                });	
            }
        });
        return false;
    });
</script>
@endsection