@extend('admin.laylout')
@section('headerinclude')
<style>
.tabs .tab {
    display: none;
}
.tabs .tab.active {
    display: block;
}
</style>
@endsection
@section('content')
<link href="assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css"/>
<script src="assets/plugins/global/plugins.bundle.js"></script>
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="row g-5 g-xl-8 mb-7">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">
                            Sipariş
                        </div>
                    </div>
                    <div class="card-body pb-0">
                        <div class="d-flex flex-wrap py-5">
                            <div class="flex-equal me-5">
                                <table class="table table-flush fw-semibold gy-1">
                                    <tbody>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Sipariş ID</td>
                                            <td class="text-gray-800"># {{ $order['upid'] }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Sahip Bilgileri</td>
                                            <td class="text-gray-800">
                                                {{ $order['name'].' '.$order['surname'] }}
                                                <a href="{{ beGetRoute('admin.user.show',['uid' => $order['uid']]) }}">
                                                    <span class="svg-icon svg-icon-2 text-warning">
                                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path opacity="0.3" d="M4.7 17.3V7.7C4.7 6.59543 5.59543 5.7 6.7 5.7H9.8C10.2694 5.7 10.65 5.31944 10.65 4.85C10.65 4.38056 10.2694 4 9.8 4H5C3.89543 4 3 4.89543 3 6V19C3 20.1046 3.89543 21 5 21H18C19.1046 21 20 20.1046 20 19V14.2C20 13.7306 19.6194 13.35 19.15 13.35C18.6806 13.35 18.3 13.7306 18.3 14.2V17.3C18.3 18.4046 17.4046 19.3 16.3 19.3H6.7C5.59543 19.3 4.7 18.4046 4.7 17.3Z" fill="currentColor"></path>
                                                            <rect x="21.9497" y="3.46448" width="13" height="2" rx="1" transform="rotate(135 21.9497 3.46448)" fill="currentColor"></rect>
                                                            <path d="M19.8284 4.97161L19.8284 9.93937C19.8284 10.5252 20.3033 11 20.8891 11C21.4749 11 21.9497 10.5252 21.9497 9.93937L21.9497 3.05029C21.9497 2.498 21.502 2.05028 20.9497 2.05028L14.0607 2.05027C13.4749 2.05027 13 2.52514 13 3.11094C13 3.69673 13.4749 4.17161 14.0607 4.17161L19.0284 4.17161C19.4702 4.17161 19.8284 4.52978 19.8284 4.97161Z" fill="currentColor"></path>
                                                        </svg>
                                                    </span>
                                                </a>    
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Sahip Mail</td>
                                            <td class="text-gray-800">{{ $order['email'] }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Başlangıç Tarihi</td>
                                            <td class="text-gray-800">{{ beSpecialTime($order['upstime']) }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Fatura Tarihi</td>
                                            <td class="text-gray-800">{{ beSpecialTime($order['upntime'],' H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Bitiş Tarihi</td>
                                            <td class="text-gray-800">{{ beSpecialTime($order['upetime'],' H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Periyot</td>
                                            @php 
                                            $period = $upoptions['period'];
                                            @endphp
                                            <td class="text-gray-800">{{ $period['time'].' '.$periods[$period['period']] }}({{ $period['periodcounter'].'/'.$period['periodfullcounter'] }}) - {{ $period['price'].' '.$currencies[$period['currency']]['cicon'] }}</td>
                                        </tr>
                                        @foreach($upoptions as $key => $option)
                                        @php if($key == 'period') continue @endphp
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">{{ $productaddons[str_replace('addon','',$key)]['paname'] }}</td>
                                            <td class="text-gray-800">{{ $option['time'].' '.$periods[$option['period']] }}({{ $option['periodfullcounter'].'/'.$option['periodfullcounter'] }}) - {{ $option['price'].' '.$currencies[$option['currency']]['cicon'] }}</td>
                                        </tr>
                                        @endforeach
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Yineleme Ücreti</td>
                                            <td class="text-gray-800">{{ beMoneyFormat($order['upprice'],3).' '.$currencies[$order['cid']]['cicon'] }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="flex-equal me-5">
                                <table class="table table-flush fw-semibold gy-1">
                                    <tbody>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Ürün Adı:</td>
                                            <td class="text-gray-800">
                                                {{ $product['pname'] }}
                                                <a href="{{ beGetRoute('admin.product.show',['pid' => $product['pid']]) }}">
                                                    <span class="svg-icon svg-icon-2 text-warning">
                                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path opacity="0.3" d="M4.7 17.3V7.7C4.7 6.59543 5.59543 5.7 6.7 5.7H9.8C10.2694 5.7 10.65 5.31944 10.65 4.85C10.65 4.38056 10.2694 4 9.8 4H5C3.89543 4 3 4.89543 3 6V19C3 20.1046 3.89543 21 5 21H18C19.1046 21 20 20.1046 20 19V14.2C20 13.7306 19.6194 13.35 19.15 13.35C18.6806 13.35 18.3 13.7306 18.3 14.2V17.3C18.3 18.4046 17.4046 19.3 16.3 19.3H6.7C5.59543 19.3 4.7 18.4046 4.7 17.3Z" fill="currentColor"></path>
                                                            <rect x="21.9497" y="3.46448" width="13" height="2" rx="1" transform="rotate(135 21.9497 3.46448)" fill="currentColor"></rect>
                                                            <path d="M19.8284 4.97161L19.8284 9.93937C19.8284 10.5252 20.3033 11 20.8891 11C21.4749 11 21.9497 10.5252 21.9497 9.93937L21.9497 3.05029C21.9497 2.498 21.502 2.05028 20.9497 2.05028L14.0607 2.05027C13.4749 2.05027 13 2.52514 13 3.11094C13 3.69673 13.4749 4.17161 14.0607 4.17161L19.0284 4.17161C19.4702 4.17161 19.8284 4.52978 19.8284 4.97161Z" fill="currentColor"></path>
                                                        </svg>
                                                    </span>
                                                </a>  
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Eklenme:</td>
                                            <td class="text-gray-800">{{ date('d.m.Y',$product['pdateline']) }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Stok Sayısı:</td>
                                            <td class="text-gray-800">{{ $product['pstock'] }} Adet</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Aktif Ürün:</td>
                                            <td class="text-gray-800">{{ $product['pactive'] }} Adet</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Toplam Satış:</td>
                                            <td class="text-gray-800">{{ $product['psold'] }} Adet</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <hr>
                        <div class="d-flex flex-wrap py-5">
                            <div class="flex-equal me-5">
                                <div class="d-flex flex-wrap py-5">
                                    <div class="flex-equal me-5">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <p class="fs-6 fw-semibold text-gray-600">Sipariş Durumu:</p>
                                                <p class="fs-6 fw-semibold text-gray-600"><span class="badge badge-{{ $status[$order['upstatus']][1] }}">{{ $status[$order['upstatus']][0] }}</span></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-equal me-5">
                                        <form id="statusForm">
                                            <div class="row">
                                                <div class="col-12 mb-9">
                                                    <select class="form-control form-control-select" name="status" id="statusSelect">
                                                        @foreach($status as $key => $name)
                                                        <option value="{{ $key }}"{{ $key == $order['upstatus'] ? ' selected':'' }}>{{ $name[0] }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="col-12 mb-9" id="statusFormExtend" style="display: none;">
                                                    <div class="row align-items-center">
                                                        <div class="col-md-8">
                                                            <div class="form-check form-switch">
                                                                <input type="hidden" name="onmodule" value="0">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="useOnModule" name="onmodule" value="1">
                                                                <label class="form-check-label" for="useOnModule">Modülde Üzerinde Uygula</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <button class="btn btn-success d-block m-auto statusSaveForm">Kaydet</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <div class="flex-equal me-5" id="contentUp">
                                
                            </div>
                        </div>
                        <ul class="nav nav-stretch nav-line-tabs nav-line-tabs-2x border-transparent fs-5 fw-bold">
                            <li class="nav-item mt-2">
                                <a class="nav-link text-active-primary ms-0 me-10 py-5 active" href="#" data-tab="Global">Genel</a>
                            </li>
                            <li class="nav-item mt-2">
                                <a class="nav-link text-active-primary ms-0 me-10 py-5" href="#" data-tab="Options">Yapılandırma</a>
                            </li>
                            <li class="nav-item mt-2">
                                <a class="nav-link text-active-primary ms-0 me-10 py-5" href="#" data-tab="Pricing">Fiyatlandırma</a>
                            </li>
                            <li class="nav-item mt-2">
                                <a class="nav-link text-active-primary ms-0 me-10 py-5" href="#" data-tab="Invoice">Faturalandırma</a>
                            </li>
                            <li class="nav-item mt-2">
                                <a class="nav-link text-active-primary ms-0 me-10 py-5" href="#" data-tab="Automation">Otomasyon</a>
                            </li>
                            <li class="nav-item mt-2">
                                <a class="nav-link text-active-primary ms-0 me-10 py-5" href="#" data-tab="Transfer">Transfer</a>
                            </li>
                            <li class="nav-item mt-2">
                                <a class="nav-link text-active-primary ms-0 me-10 py-5" href="#" data-tab="Logs">Kayıtlar</a>
                            </li>
                            <li class="nav-item mt-2">
                                <a class="nav-link text-active-primary ms-0 me-10 py-5" href="#" data-tab="Cancel">İptal Seçenekleri</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="tabs">
            <div class="tab active" id="tabGlobal">
                <div class="row g-5 g-xl-8 mb-7">
                    <div class="col-xl-6">
                        <div class="card mb-7">
                            <div class="card-header">
                                <div class="card-title">
                                    Sipariş İsimlendirmesi
                                </div>
                            </div>
                            <div class="card-body">
                                <form id="nameForm">
                                    <div class="row">
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Sipariş Adı</label>
                                            <input type="text" class="form-control" name="name" value="{{ $order['upname'] }}">
                                        </div>
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Sipariş Etiketi</label>
                                            <input type="text" class="form-control" name="tag" value="{{ $order['uptag'] }}">
                                        </div>
                                        <div class="col-12">
                                            <button class="btn btn-success d-block m-auto nameSaveForm">Kaydet</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Sipariş Notları
                                </div>
                            </div>
                            <form id="noteForm" class="card-body">
                                <div class="row">
                                    <div class="col-12 mb-9">
                                        <textarea class="form-control" name="note" rows="7">{{ $order['upnote'] }}</textarea>
                                    </div>
                                    <div class="col-12">
                                        <button class="btn btn-success d-block m-auto noteSaveForm">Kaydet</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab" id="tabOptions">
                <div class="row g-5 g-xl-8 mb-7">
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Sipariş Yapılandırması
                                </div>
                            </div>
                            <div class="card-body">
                                <form id="addonForm">
                                    <div class="row">
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Periyot Seçin</label>
                                            <select class="form-control form-control-select" name="period">
                                                @php $pperiods = json_decode($product['pperiods'],true); @endphp
                                                @php $orderperiod = $upoptions['period']['period'] @endphp
                                                @foreach($pperiods[$order['cid']] as $key => $option)
                                                <option value="{{ $key }}"{{ $key == $upoptions['period']['key'] ? ' selected':'' }}>{{ ($option['operiodtime'] == 0 ? '':$option['operiodtime'].' ').$periods[$option['operiod']].' - '.($option['oprice'] == 0 ? ('Ücretsiz'):(beMoneyFormat($option['oprice']).$currencies[$option['ocid']]['cicon'])) }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @foreach($productaddons as $paid => $productaddon)
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">{{ $productaddon['paname'] }}</label>
                                            <div class="row">
                                                <div class="col-md-4">
                                                <label class="fs-6 fw-semibold mb-2 text-gray-500">Opsiyon Durumu</label>
                                                @if($productaddon['patype'] == 'select')
                                                @php $paoptions = json_decode($productaddon['paoptions'],true); @endphp
                                                    <select class="form-control form-control-select optionSelect" name="addon{{ $paid }}" data-option="{{ $paid }}">
                                                        <option value="0" selected>İstemiyorum</option>
                                                        @php
                                                            $altkey = 0;
                                                            if($upoptions['addon'.$paid]){
                                                                $altkey = $upoptions['addon'.$paid]['key'];
                                                            }
                                                        @endphp
                                                        @foreach($paoptions as $key => $option)
                                                        <option value="{{ $key }}"{{ $key == $altkey ? ' selected':'' }}>{{ $option['oname'].' ('.($option['oprice'] == 0 ? ('Ücretsiz'):(beMoneyFormat($option['oprice']).$currencies[$option['ocid']]['cicon'])).' - '.($option['operiodtime'] == 0 ? '':$option['operiodtime'].' ').$periods[$orderperiod].')' }}</option>
                                                        @endforeach
                                                    </select>
                                                @endif
                                                </div>
                                                <div class="col-md-8 row" id="addonContent{{ $paid }}">
                                                    @if($upoptions['addon'.$paid])
                                                    <div class="col-md-4">
                                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Opsyion Fiyatı</label>
                                                        <input type="number" class="form-control" name="price{{ $paid }}" value="{{ $upoptions['addon'.$paid]['price'] }}">
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Opsyion Birimi</label>
                                                        <select class="form-control form-control-select" name="currency{{ $paid }}">
                                                            @foreach($currencies as $currency)
                                                            <option value="{{ $currency['cid'] }}"{{ $currency['cid'] == $upoptions['addon'.$paid]['currency'] ? ' selected':'' }}>{{ $currency['cname'] }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Opsyion Periyot Kullanım/Limit</label>
                                                        <input type="text" class="form-control" name="periodcounter{{ $paid }}" value="{{ $upoptions['addon'.$paid]['periodcounter'].'/'.$upoptions['addon'.$paid]['periodfullcounter'] }}">
                                                    </div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        @endforeach
                                        <div class="col-12">
                                            <button class="btn btn-success d-block m-auto addonSaveForm">Kaydet</button>
                                        </div>
                                    </div>
                                </form> 
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Sipariş Yapılandırma Kayıtları
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table w-100 table-rounded table-striped gy-7 gs-7 mb-0">
                                    <thead>
                                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                                            <th class="text-center align-middle">#</th>
                                            <th class="text-center align-middle">Kullanıcı</th>
                                            <th class="text-center align-middle">İşlem</th>
                                            <th class="text-center align-middle">IP Adresi</th>
                                            <th class="text-center align-middle">Tarih</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($userproductlogs as $userproductlog)
                                        @if($userproductlog['ltype'] != 'addon_edit')
                                            @continue
                                        @endif
                                        <tr>
                                            <td class="text-center align-middle">{{ $userproductlog['lid'] }}</td>
                                            <td class="text-center align-middle">
                                                {{ $userproductlog['name'].' '.$userproductlog['surname'] }}
                                                <a href="{{ beGetRoute('admin.user.show',['uid' => $userproductlog['uid']]) }}">
                                                    <span class="svg-icon svg-icon-2 text-warning">
                                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path opacity="0.3" d="M4.7 17.3V7.7C4.7 6.59543 5.59543 5.7 6.7 5.7H9.8C10.2694 5.7 10.65 5.31944 10.65 4.85C10.65 4.38056 10.2694 4 9.8 4H5C3.89543 4 3 4.89543 3 6V19C3 20.1046 3.89543 21 5 21H18C19.1046 21 20 20.1046 20 19V14.2C20 13.7306 19.6194 13.35 19.15 13.35C18.6806 13.35 18.3 13.7306 18.3 14.2V17.3C18.3 18.4046 17.4046 19.3 16.3 19.3H6.7C5.59543 19.3 4.7 18.4046 4.7 17.3Z" fill="currentColor"></path>
                                                            <rect x="21.9497" y="3.46448" width="13" height="2" rx="1" transform="rotate(135 21.9497 3.46448)" fill="currentColor"></rect>
                                                            <path d="M19.8284 4.97161L19.8284 9.93937C19.8284 10.5252 20.3033 11 20.8891 11C21.4749 11 21.9497 10.5252 21.9497 9.93937L21.9497 3.05029C21.9497 2.498 21.502 2.05028 20.9497 2.05028L14.0607 2.05027C13.4749 2.05027 13 2.52514 13 3.11094C13 3.69673 13.4749 4.17161 14.0607 4.17161L19.0284 4.17161C19.4702 4.17161 19.8284 4.52978 19.8284 4.97161Z" fill="currentColor"></path>
                                                        </svg>
                                                    </span>
                                                </a>  
                                            </td>
                                            <td class="text-center align-middle">{{ $userproductlog['lmessage'] }}</td>
                                            <td class="text-center align-middle">{{ $userproductlog['lipaddress'] }}</td>
                                            <td class="text-center align-middle">{{ date('d.m.Y H:i',$userproductlog['ldateline']) }}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab" id="tabPricing">
                <div class="row g-5 g-xl-8 mb-7">
                    <div class="col-xl-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Sipariş Fiyatlandırması
                                </div>
                            </div>
                            <div class="card-body">
                                <form id="priceForm">
                                    <div class="row">
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Ürün Fiyatı</label>
                                            <input type="text" class="form-control" name="price" value="{{ $order['upprice'] }}">
                                        </div>
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Ürün KDV Oranı(%)</label>
                                            <input type="text" class="form-control" name="taxrate" value="{{ $order['uptaxrate'] }}">
                                        </div>
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Ürün Fiyat Birimi</label>
                                            <select class="form-control form-control-select" name="currency">
                                                @foreach($currencies as $currency)
                                                <option value="{{ $currency['cid'] }}"{{ $currency['cid'] == $order['cid'] ? ' selected':'' }}>{{ $currency['cname'] }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Fiyatın Hesaplanması</label>
                                            <select class="form-control form-control-select" name="calcprice">
                                                <option value="product"{{ $order['upcalcprice'] == 'product' ? ' selected':'' }}>Ürün Fiyatı Üzerinden</option>
                                                <option value="special"{{ $order['upcalcprice'] == 'special' ? ' selected':'' }}>Bu Sipariş Üzerinden</option>
                                            </select>
                                        </div>
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Ürün Faturalandırması</label>
                                            <div class="form-check form-check-custom form-check-solid">
                                                <input class="form-check-input" type="checkbox" value="1" name="upbill" id="upbill"{{ $order['upbill'] == 1 ? ' checked':'' }}>
                                                <label class="form-check-label" for="upbill">
                                                    Bu sipariş için satın alım, uzatma gibi işlemler için yapılan ödemeler için resmi fatura oluştur.
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <button class="btn btn-success d-block m-auto priceSaveForm">Kaydet</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Sipariş Fiyatlandırma Kayıtları
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table w-100 table-rounded table-striped gy-7 gs-7 mb-0">
                                    <thead>
                                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                                            <th class="text-center align-middle">#</th>
                                            <th class="text-center align-middle">Kullanıcı</th>
                                            <th class="text-center align-middle">İşlem</th>
                                            <th class="text-center align-middle">IP Adresi</th>
                                            <th class="text-center align-middle">Tarih</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($userproductlogs as $userproductlog)
                                        @if($userproductlog['ltype'] != 'price_edit')
                                            @continue
                                        @endif
                                        <tr>
                                            <td class="text-center align-middle">{{ $userproductlog['lid'] }}</td>
                                            <td class="text-center align-middle">
                                                {{ $userproductlog['name'].' '.$userproductlog['surname'] }}
                                                <a href="{{ beGetRoute('admin.user.show',['uid' => $userproductlog['uid']]) }}">
                                                    <span class="svg-icon svg-icon-2 text-warning">
                                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path opacity="0.3" d="M4.7 17.3V7.7C4.7 6.59543 5.59543 5.7 6.7 5.7H9.8C10.2694 5.7 10.65 5.31944 10.65 4.85C10.65 4.38056 10.2694 4 9.8 4H5C3.89543 4 3 4.89543 3 6V19C3 20.1046 3.89543 21 5 21H18C19.1046 21 20 20.1046 20 19V14.2C20 13.7306 19.6194 13.35 19.15 13.35C18.6806 13.35 18.3 13.7306 18.3 14.2V17.3C18.3 18.4046 17.4046 19.3 16.3 19.3H6.7C5.59543 19.3 4.7 18.4046 4.7 17.3Z" fill="currentColor"></path>
                                                            <rect x="21.9497" y="3.46448" width="13" height="2" rx="1" transform="rotate(135 21.9497 3.46448)" fill="currentColor"></rect>
                                                            <path d="M19.8284 4.97161L19.8284 9.93937C19.8284 10.5252 20.3033 11 20.8891 11C21.4749 11 21.9497 10.5252 21.9497 9.93937L21.9497 3.05029C21.9497 2.498 21.502 2.05028 20.9497 2.05028L14.0607 2.05027C13.4749 2.05027 13 2.52514 13 3.11094C13 3.69673 13.4749 4.17161 14.0607 4.17161L19.0284 4.17161C19.4702 4.17161 19.8284 4.52978 19.8284 4.97161Z" fill="currentColor"></path>
                                                        </svg>
                                                    </span>
                                                </a>  
                                            </td>
                                            <td class="text-center align-middle">{{ $userproductlog['lmessage'] }}</td>
                                            <td class="text-center align-middle">{{ $userproductlog['lipaddress'] }}</td>
                                            <td class="text-center align-middle">{{ date('d.m.Y H:i',$userproductlog['ldateline']) }}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab" id="tabInvoice">
                <div class="row g-5 g-xl-8 mb-7">
                    <div class="col-xl-4">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Sipariş Faturalandırması
                                </div>
                            </div>
                            <div class="card-body">
                                <form id="timeForm">
                                    <div class="row">
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Başlangıç Tarihi</label>
                                            <input type="datetime-local" class="form-control" name="upstime" value="{{ date('Y-m-d\TH:i',$order['upstime']) }}">
                                        </div>
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Fatura Tarihi</label>
                                            <input type="datetime-local" class="form-control" name="upntime" value="{{ date('Y-m-d\TH:i',$order['upntime']) }}">
                                        </div>
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Bitiş Tarihi</label>
                                            <input type="datetime-local" class="form-control" name="upetime" value="{{ date('Y-m-d\TH:i',$order['upetime']) }}">
                                        </div>
                                        <div class="col-12 row">
                                            <div class="col-4 mb-9">
                                                <button class="btn btn-success d-block m-auto timeSaveForm">Kaydet</button>
                                            </div>
                                            <div class="col-8 mb-9">
                                                <button class="btn btn-primary d-block m-auto createInvoice">Fatura Oluştur</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-8">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Siparişin Aktif Faturaları
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table w-100 table-rounded table-striped gy-7 gs-7 mb-0">
                                    <thead>
                                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                                            <th class="text-center align-middle">#</th>
                                            <th class="text-center align-middle">Açıklama</th>
                                            <th class="text-center align-middle">İçerik</th>
                                            <th class="text-center align-middle">Durum</th>
                                            <th class="text-center align-middle">Oluşturulma Tarihi</th>
                                            <th class="text-center align-middle"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($invoices as $invoice)
                                        <tr>
                                            <td class="text-center align-middle">{{ $invoice['iid'] }}</td>
                                            <td class="text-center align-middle">{{ $invoice['idescription'] }}</td>
                                            <td class="text-center align-middle">
                                                @foreach($invoice['ibasket'] as $basket)
                                                <code class="ms-0 d-block">{{ $basket[0].' '.$basket[1].$currencies[$invoice['cid']]['cicon'].' x '.$basket[2].' Adet' }}</code>
                                                @endforeach
                                            </td>
                                            <td class="text-center align-middle"><span class="badge badge-info">Aktif</span></td>
                                            <td class="text-center align-middle">{{ date('d.m.Y H:i',$invoice['idateline']) }}</td>
                                            <td class="text-center align-middle">
                                                <a data-bs-toggle="tooltip" title="Görüntüle" href="{{ beGetRoute('admin.invoice.show',['iid' => $invoice['iid']]) }}" class="btn btn-warning"><i class="far fa-eye"></i></a>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab" id="tabAutomation">
                <div class="row g-5 g-xl-8 mb-7">
                    <div class="col-xl-12">
                        <div class="card mb-7">
                            <div class="card-header">
                                <div class="card-title">
                                    Otomasyon Ayarları
                                </div>
                            </div>
                            <div class="card-body mb-3">
                                <form id="moduleForm">
                                    <div class="row">
                                        <label class="fs-6 fw-semibold mb-2">Modül</label>
                                        <select class="form-control form-control-select" name="{{ $key }}">
                                            @foreach($modules as $key => $data)
                                            <option value="{{ $key }}"{{ $order['upmodule'] == $key ? ' selected':'' }}>{{ $data['info']['name'] }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </form>
                            </div>
                            <div class="card-body">
                                <form id="moduleDataForm">
                            
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12" id="contentDown">
                    </div>
                </div>
            </div>
            <div class="tab" id="tabTransfer">
                <div class="row g-5 g-xl-8 mb-7">
                    <div class="col-xl-6">
                        <div class="card mb-7">
                            <div class="card-header">
                                <div class="card-title">
                                    Ürünü Transfer Et
                                </div>
                            </div>
                            <div class="card-body mb-3">
                                <form id="transferForm">
                                    <div class="row">
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Kullanıcı</label>
                                            <select class="form-control form-control-select-user" name="user">
                                                <option value="{{ $order['uid'] }}">{{ $order['name'].' '.$order['surname'] }}</option>
                                            </select>
                                        </div>
                                        <div class="col-12">
                                            <button class="btn btn-success d-block m-auto transferSaveForm">Taşı</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>          
                    <div class="col-xl-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Sipariş Transfer Kayıtları
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table w-100 table-rounded table-striped gy-7 gs-7 mb-0">
                                    <thead>
                                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                                            <th class="text-center align-middle">#</th>
                                            <th class="text-center align-middle">Kullanıcı</th>
                                            <th class="text-center align-middle">İşlem</th>
                                            <th class="text-center align-middle">IP Adresi</th>
                                            <th class="text-center align-middle">Tarih</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($userproductlogs as $userproductlog)
                                        @if($userproductlog['ltype'] != 'transfer')
                                            @continue
                                        @endif
                                        <tr>
                                            <td class="text-center align-middle">{{ $userproductlog['lid'] }}</td>
                                            <td class="text-center align-middle">
                                                {{ $userproductlog['name'].' '.$userproductlog['surname'] }}
                                                <a href="{{ beGetRoute('admin.user.show',['uid' => $userproductlog['uid']]) }}">
                                                    <span class="svg-icon svg-icon-2 text-warning">
                                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path opacity="0.3" d="M4.7 17.3V7.7C4.7 6.59543 5.59543 5.7 6.7 5.7H9.8C10.2694 5.7 10.65 5.31944 10.65 4.85C10.65 4.38056 10.2694 4 9.8 4H5C3.89543 4 3 4.89543 3 6V19C3 20.1046 3.89543 21 5 21H18C19.1046 21 20 20.1046 20 19V14.2C20 13.7306 19.6194 13.35 19.15 13.35C18.6806 13.35 18.3 13.7306 18.3 14.2V17.3C18.3 18.4046 17.4046 19.3 16.3 19.3H6.7C5.59543 19.3 4.7 18.4046 4.7 17.3Z" fill="currentColor"></path>
                                                            <rect x="21.9497" y="3.46448" width="13" height="2" rx="1" transform="rotate(135 21.9497 3.46448)" fill="currentColor"></rect>
                                                            <path d="M19.8284 4.97161L19.8284 9.93937C19.8284 10.5252 20.3033 11 20.8891 11C21.4749 11 21.9497 10.5252 21.9497 9.93937L21.9497 3.05029C21.9497 2.498 21.502 2.05028 20.9497 2.05028L14.0607 2.05027C13.4749 2.05027 13 2.52514 13 3.11094C13 3.69673 13.4749 4.17161 14.0607 4.17161L19.0284 4.17161C19.4702 4.17161 19.8284 4.52978 19.8284 4.97161Z" fill="currentColor"></path>
                                                        </svg>
                                                    </span>
                                                </a>  
                                            </td>
                                            <td class="text-center align-middle">{{ $userproductlog['lmessage'] }}</td>
                                            <td class="text-center align-middle">{{ $userproductlog['lipaddress'] }}</td>
                                            <td class="text-center align-middle">{{ date('d.m.Y H:i',$userproductlog['ldateline']) }}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>                         
                </div>
            </div>
            <div class="tab" id="tabLogs">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="card mb-7">
                            <div class="card-header">
                                <div class="card-title">
                                    Kayıtlar
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table w-100 table-rounded table-striped gy-7 gs-7 mb-0">
                                    <thead>
                                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                                            <th class="text-center align-middle">#</th>
                                            <th class="text-center align-middle">İşlemi Yapan</th>
                                            <th class="text-center align-middle">İşlem</th>
                                            <th class="text-center align-middle">IP Adresi</th>
                                            <th class="text-center align-middle">Tarih</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($userproductlogs as $userproductlog)
                                        <tr>
                                            <td class="text-center align-middle">{{ $userproductlog['lid'] }}</td>
                                            <td class="text-center align-middle">
                                                {{ $userproductlog['name'].' '.$userproductlog['surname'] }}
                                                <a href="{{ beGetRoute('admin.user.show',['uid' => $userproductlog['uid']]) }}">
                                                    <span class="svg-icon svg-icon-2 text-warning">
                                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path opacity="0.3" d="M4.7 17.3V7.7C4.7 6.59543 5.59543 5.7 6.7 5.7H9.8C10.2694 5.7 10.65 5.31944 10.65 4.85C10.65 4.38056 10.2694 4 9.8 4H5C3.89543 4 3 4.89543 3 6V19C3 20.1046 3.89543 21 5 21H18C19.1046 21 20 20.1046 20 19V14.2C20 13.7306 19.6194 13.35 19.15 13.35C18.6806 13.35 18.3 13.7306 18.3 14.2V17.3C18.3 18.4046 17.4046 19.3 16.3 19.3H6.7C5.59543 19.3 4.7 18.4046 4.7 17.3Z" fill="currentColor"></path>
                                                            <rect x="21.9497" y="3.46448" width="13" height="2" rx="1" transform="rotate(135 21.9497 3.46448)" fill="currentColor"></rect>
                                                            <path d="M19.8284 4.97161L19.8284 9.93937C19.8284 10.5252 20.3033 11 20.8891 11C21.4749 11 21.9497 10.5252 21.9497 9.93937L21.9497 3.05029C21.9497 2.498 21.502 2.05028 20.9497 2.05028L14.0607 2.05027C13.4749 2.05027 13 2.52514 13 3.11094C13 3.69673 13.4749 4.17161 14.0607 4.17161L19.0284 4.17161C19.4702 4.17161 19.8284 4.52978 19.8284 4.97161Z" fill="currentColor"></path>
                                                        </svg>
                                                    </span>
                                                </a>  
                                            </td>
                                            <td class="text-center align-middle">{{ $userproductlog['lmessage'] }}</td>
                                            <td class="text-center align-middle">{{ $userproductlog['lipaddress'] }}</td>
                                            <td class="text-center align-middle">{{ date('d.m.Y H:i',$userproductlog['ldateline']) }}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab" id="tabCancel">
                <div class="row g-5 g-xl-8 mb-7">
                
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
<script>
    $(".form-control-select").select2();
    var module = "{{ $order['upmodule'] }}";
    $(".nav-link").on("click",function(){
        var tab = $(this).data("tab");
        $(".nav-link.active").removeClass("active");
        $(this).addClass("active");
        $(".tab.active").removeClass("active");
        $("#tab"+tab).addClass("active");
        return false;
    });
    $("#statusSelect").change(function(){
        $("#statusFormExtend").show("slow");
    });
    var wait1 = false;
    $(".statusSaveForm").on("click",function(){
        if(!wait1){
            wait1 = true;
            $(".statusSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.order.status.save.post') }}",
                type: "post",
                async: true,
                data: $("#statusForm").serialize()+"&upid={{ $order['upid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait1 = false;
                    $(".statusSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                    loadModule(module);
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    var wait2 = false;
    $(".nameSaveForm").on("click",function(){
        if(!wait2){
            wait1 = true;
            $(".nameSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.order.name.save.post') }}",
                type: "post",
                async: true,
                data: $("#nameForm").serialize()+"&upid={{ $order['upid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait2 = false;
                    $(".nameSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".noteSaveForm").on("click",function(){
        if(!wait2){
            wait2 = true;
            $(".noteSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.order.note.save.post') }}",
                type: "post",
                async: true,
                data: $("#noteForm").serialize()+"&upid={{ $order['upid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait2 = false;
                    $(".noteSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    var wait3 = false;
    $(".addonSaveForm").on("click",function(){
        if(!wait3){
            wait3 = true;
            $(".addonSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.order.options.save.post') }}",
                type: "post",
                async: true,
                data: $("#addonForm").serialize()+"&upid={{ $order['upid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait3 = false;
                    $(".addonSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    var wait4 = false;
    $(".priceSaveForm").on("click",function(){
        if(!wait4){
            wait4 = true;
            $(".priceSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.order.price.save.post') }}",
                type: "post",
                async: true,
                data: $("#priceForm").serialize()+"&upid={{ $order['upid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait4 = false;
                    $(".priceSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    var wait5 = false;
    $(".createInvoice").on("click",function(){
        if(!wait5){
            wait5 = true;
            $(".createInvoice").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.order.invoice.create.post') }}",
                type: "post",
                async: true,
                data: {upid:{{ $order['upid'] }}},
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait5 = false;
                    $(".createInvoice").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                        setTimeout(function(){
                            location.reload();
                        },1000);
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    var wait6 = false;
    $(".timeSaveForm").on("click",function(){
        if(!wait6){
            wait6 = true;
            $(".timeSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.order.time.save.post') }}",
                type: "post",
                async: true,
                data: $("#timeForm").serialize()+"&upid={{ $order['upid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait6 = false;
                    $(".timeSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                    loadModule(module);
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    var wait7 = false;
    $("#moduleDataForm").on("click",".saveAutomation",function(){
        if(!wait7){
            wait7 = true;
            $(".saveAutomation").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.order.automation.save.post') }}",
                type: "post",
                async: true,
                data: $("#moduleDataForm").serialize()+"&upid={{ $order['upid'] }}&module="+module,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait7 = false;
                    $(".saveAutomation").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                    loadModule(module);
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".optionSelect").change(function(){
        var paid = $(this).data("option");
        $.ajax({
            url: "{{ beGetRoute('admin.order.options.info.post') }}",
            type: "post",
            async: true,
            data: {upid:{{ $order['upid'] }},paid:paid,option:$(this).val()},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#addonContent"+paid).empty().append(response.html);
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
    });
    var wait8 = false;
    $(".transferSaveForm").on("click",function(){
        if(!wait8){
            wait8 = true;
            $(".transferSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.order.transfer.post') }}",
                type: "post",
                async: true,
                data: $("#transferForm").serialize()+"&upid={{ $order['upid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait8 = false;
                    $(".transferSaveForm").html("Taşı");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                    loadModule(module);
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".form-control-select-user").select2({
        placeholder: "Lütfen aramak istediğiniz kullanıcının isim yada soyisimini giriniz",
        minimumInputLength: 2,
        tags: false,
        ajax: {
            url: "{{ beGetRoute('admin.user.find.post') }}",
            dataType: "json",
            type: "post",
            quietMillis: 50,
            data: function (term) {
                return term;
            },
            processResults: function (data){
                return {
                    results: $.map(data, function (item) {
                        return {
                            text: item.namesurname,
                            id: item.uid
                        }
                    })
                };
            },
            cache: true
        }
    });
    if(module){
        setTimeout(function(){
            loadModule(module);
        },1000);
    }
    function loadModule(module){
        $("#contentUp").append('<span class="spinner-border align-middle ms-2"></span>');
        $.ajax({
            url: "{{ beGetRoute('admin.order.automation.post') }}",
            type: "post",
            async: true,
            data: {upid:{{ $order['upid'] }},module:module},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#moduleDataForm").empty().append('<div class="row">'+response.automation+'<div class="col-12"><button class="btn btn-success d-block m-auto saveAutomation">Kaydet</button></div></div>');
                    $("#contentUp").empty().append(response.contentup);
                    if(response.contentdown){
                        $("#contentDown").empty().append(response.contentdown);
                    }
                    $(".form-control-select").select2();
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
    }
</script>
@endsection