@extend('admin.laylout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Fatura Ekle
                </div>
            </div>
            <div class="card-body">
                <form id="machineForm">
                    <div class="row">
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Fatura Adı</label>
                            <input type="text" class="form-control" name="name">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Fatura Açıklaması</label>
                            <input type="text" class="form-control" name="description">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Fatura Tipi</label>
                            <select class="form-control form-control-select" name="type">
                                <option value="3">Özel Fatura</option>
                                <option value="4">Bakiye Yükleme</option>
                            </select>
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Resmi Fatura Durumu</label>
                            <select class="form-control form-control-select" name="bill">
                                <option value="0">Fatura Kesilmedi</option>
                                <option value="1">Fatura Kesildi</option>
                            </select>
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Fatura Sahibi</label>
                            <select class="form-control form-control-select-user" name="user">
                                @if($usersearch)
                                    <option value="{{ $usersearch['uid'] }}">{{ $usersearch['text'] }}</option>
                                @endif
                            </select>
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Fatura Para Birimi</label>
                            <select class="form-control form-control-select" name="currency">
                                @foreach($currencies as $currency)
                                <option value="{{ $currency['cid'] }}">{{ $currency['cname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Fatura Oluşturulma Zamanı</label>
                            <input type="datetime-local" class="form-control" name="dateline" value="{{ date('Y-m-d\TH:i',BE_TIME) }}">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Fatura Zaman Aşımı</label>
                            <input type="datetime-local" class="form-control" name="expiredate" value="{{ date('Y-m-d\TH:i',BE_TIME+86400) }}">
                        </div>
                        <div class="row col-12 dragable-zone" id="itemArea">
                            <div class="col-12 mb-9 dragable" id="row1" data-key="1">
                                <div class="row">
                                    <div class="col-md-1">
                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Sıralama</label>
                                        <a href="#" class="btn btn-icon btn-sm btn-hover-light-primary draggable-handle">
                                            <span class="svg-icon svg-icon-2x">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M21 7H3C2.4 7 2 6.6 2 6V4C2 3.4 2.4 3 3 3H21C21.6 3 22 3.4 22 4V6C22 6.6 21.6 7 21 7Z" fill="currentColor"></path>
                                                    <path opacity="0.3" d="M21 14H3C2.4 14 2 13.6 2 13V11C2 10.4 2.4 10 3 10H21C21.6 10 22 10.4 22 11V13C22 13.6 21.6 14 21 14ZM22 20V18C22 17.4 21.6 17 21 17H3C2.4 17 2 17.4 2 18V20C2 20.6 2.4 21 3 21H21C21.6 21 22 20.6 22 20Z" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </a>
                                    </div>
                                    <div class="col-md-3">
                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Ürün</label>
                                        <input type="text" class="form-control" id="rowName1">
                                    </div>
                                    <div class="col-md-2">
                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Fiyat</label>
                                        <input type="text" class="form-control" id="rowPrice1">
                                    </div>
                                    <div class="col-md-2">
                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Adet</label>
                                        <input type="number" class="form-control" id="rowCount1">
                                    </div>
                                    <div class="col-md-2">
                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Birim</label>
                                        <select class="form-control form-control-select" id="rowCurrency1">
                                            @foreach($currencies as $currency)
                                            <option value="{{ $currency['cid'] }}">{{ $currency['cname'] }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-1">
                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Vergilendir</label>
                                        <input type="checkbox" class="form-check-input" id="rowTax1">
                                    </div>
                                    <div class="col-md-1">
                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">İşlemler</label>
                                        <a data-bs-toggle="tooltip" title="Sil" class="btn btn-danger btnDeleteRow" data-key="1">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor">
                                                <path fill="none" d="M0 0h24v24H0z"/>
                                                <path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"/>
                                            </svg>
                                            Sil
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto addonAddForm">Yeni Satır Ekle</button>
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Fatura Notları</label>
                            <textarea rows="3" class="form-control" name="note"></textarea>
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto addMachine">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script src="assets/plugins/custom/draggable/draggable.bundle.js"></script>
<script>
    var lastkey = 2;
    var altcontainers = null,swappable = null;
    $(".addonAddForm").on("click",function(){
        var content = '<div class="col-12 mb-9 dragable" id="row'+lastkey+'" data-key="'+lastkey+'">\
            <div class="row">\
                <div class="col-md-1">\
                    <label class="fs-6 fw-semibold mb-2 text-gray-500">Sıralama</label>\
                    <a href="#" class="btn btn-icon btn-sm btn-hover-light-primary draggable-handle">\
                        <span class="svg-icon svg-icon-2x">\
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">\
                                <path d="M21 7H3C2.4 7 2 6.6 2 6V4C2 3.4 2.4 3 3 3H21C21.6 3 22 3.4 22 4V6C22 6.6 21.6 7 21 7Z" fill="currentColor"></path>\
                                <path opacity="0.3" d="M21 14H3C2.4 14 2 13.6 2 13V11C2 10.4 2.4 10 3 10H21C21.6 10 22 10.4 22 11V13C22 13.6 21.6 14 21 14ZM22 20V18C22 17.4 21.6 17 21 17H3C2.4 17 2 17.4 2 18V20C2 20.6 2.4 21 3 21H21C21.6 21 22 20.6 22 20Z" fill="currentColor"></path>\
                            </svg>\
                        </span>\
                    </a>\
                </div>\
                <div class="col-md-3">\
                    <label class="fs-6 fw-semibold mb-2 text-gray-500">Ürün</label>\
                    <input type="text" class="form-control" id="rowName'+lastkey+'">\
                </div>\
                <div class="col-md-2">\
                    <label class="fs-6 fw-semibold mb-2 text-gray-500">Fiyat</label>\
                    <input type="text" class="form-control" id="rowPrice'+lastkey+'">\
                </div>\
                <div class="col-md-2">\
                    <label class="fs-6 fw-semibold mb-2 text-gray-500">Adet</label>\
                    <input type="number" class="form-control" id="rowCount'+lastkey+'">\
                </div>\
                <div class="col-md-2">\
                    <label class="fs-6 fw-semibold mb-2 text-gray-500">Birim</label>\
                    <select class="form-control form-control-select" id="rowCurrency'+lastkey+'">\
                        @foreach($currencies as $currency)
                        <option value="{{ $currency['cid'] }}">{{ $currency['cname'] }}</option>\
                        @endforeach
                    </select>\
                </div>\
                <div class="col-md-1">\
                    <label class="fs-6 fw-semibold mb-2 text-gray-500">Vergilendir</label>\
                    <input type="checkbox" class="form-check-input" id="rowTax'+lastkey+'">\
                </div>\
                <div class="col-md-1">\
                    <label class="fs-6 fw-semibold mb-2 text-gray-500">İşlemler</label>\
                    <a data-bs-toggle="tooltip" title="Sil" class="btn btn-danger btnDeleteRow" data-key="'+lastkey+'">\
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor">\
                            <path fill="none" d="M0 0h24v24H0z"/>\
                            <path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"/>\
                        </svg>\
                        Sil\
                    </a>\
                </div>\
            </div>\
        </div>';
        $("#itemArea").append(content);
        lastkey += 1;
        altcontainers = document.querySelectorAll(".dragable-zone");
        if(swappable != null){
            swappable.destroy();
        }
        if(altcontainers.length !== 0) {
            swappable = new Sortable.default(altcontainers, {
                draggable: ".dragable",
                handle: ".dragable .draggable-handle",
                mirror: {
                    appendTo: ".maindraggable",
                    constrainDimensions: true
                }
            });
        }
        return false;
    });
    $("#itemArea").on("click",".btnDeleteRow",function(){
        var key = $(this).data("key");
        $("#row"+key).remove();
    });
    $(".form-control-select").select2();
    $(".form-control-select-user").select2({
        placeholder: "Lütfen aramak istediğiniz kullanıcının isim yada soyisimini giriniz",
        minimumInputLength: 2,
        tags: false,
        ajax: {
            url: "{{ beGetRoute('admin.user.find.post') }}",
            dataType: "json",
            type: "post",
            quietMillis: 50,
            data: function (term) {
                return term;
            },
            processResults: function (data){
                return {
                    results: $.map(data, function (item) {
                        return {
                            text: item.namesurname,
                            id: item.uid
                        }
                    })
                };
            },
            cache: true
        }
    });
    var wait = false;
    $(".addMachine").on("click",function(){
        if(!wait){
            $(".addMachine").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            var key = 0;
            var data = "&";
            var counter = 0;
            $("#itemArea > div").each(function(){
                key = $(this).data("key");
                data += "rowName"+counter+"="+$("#rowName"+key).val()+"&";
                data += "rowPrice"+counter+"="+$("#rowPrice"+key).val().replace(/,/g,".")+"&";
                data += "rowCount"+counter+"="+$("#rowCount"+key).val().replace(/,/g,".")+"&";
                data += "rowTax"+counter+"="+($("#rowTax"+key).is(":checked") == true ? "1":"0")+"&";
                data += "rowCurrency"+counter+"="+$("#rowCurrency"+key).val().replace(/,/g,".")+"&";
                counter += 1;
            });
            data += "itemCount="+counter;
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.invoice.add.post') }}",
                type: "post",
                async: true,
                data: $("#machineForm").serialize()+data,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    if(response.status){
                        $(".addMachine").html("Kaydet");
                        Swal.fire("Başarılı",response.message,"success");
                        setTimeout(function(){
                            window.location.href = response.url;
                        },1000);
                    }
                    else{
                        $(".addMachine").html("Kaydet");
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                        wait = false;
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection