@extend('admin.laylout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="d-flex justify-content-end">
            <button type="button" class="d-inline-flex align-items-center btn btn-primary mb-5 mx-3" data-bs-toggle="modal" data-bs-target="#beNewFinance">
                <span class="svg-icon svg-icon-muted d-flex align-items-center">
                    <svg width="23" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"/>
                        <rect x="10.8891" y="17.8033" width="12" height="2" rx="1" transform="rotate(-90 10.8891 17.8033)" fill="currentColor"/>
                        <rect x="6.01041" y="10.9247" width="12" height="2" rx="1" fill="currentColor"/>
                    </svg>
                </span>
                Periyodik Giriş Ekle
            </button>
        </div>
        <div class="card mb-4">
            <div class="table-responsive">
                <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                    <thead>
                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                            <th class="text-center align-middle">#</th>
                            <th class="text-center align-middle">İşlem</th>
                            <th class="text-center align-middle">Tür</th>
                            <th class="text-center align-middle">Miktar</th>
                            <th class="text-center align-middle">İşlem Günü</th>
                            <th class="text-center align-middle">Eklenme Tarih</th>
                            <th class="text-center align-middle"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($accountingperiods as $accountingperiod)
                        <tr id="{{ $accountingperiod['apid'] }}Row">
                            <td class="text-center align-middle">{{ $accountingperiod['apid'] }}</td>
                            <td class="text-center align-middle">{{ $accountingperiod['apname'] }}</td>
                            <td class="text-center align-middle"><span class="text-{{ $accountingtypes[$accountingperiod['aptype']][1] }}">{{ $accountingtypes[$accountingperiod['aptype']][0] }}</span></td>
                            <td class="text-center align-middle">{{ $accountingperiod['aptotal'].' '.$currencies[$accountingperiod['cid']]['cicon'] }}</td>
                            <td class="text-center align-middle">Her Ayın {{ $accountingperiod['apdate'] }}. Günü</td>
                            <td class="text-center align-middle">{{ beSpecialTime($accountingperiod['apdateline']) }}</td>
                            <td class="text-center align-middle">
                                <a data-bs-toggle="tooltip" title="Sil" class="btn btn-danger btnDelete" data-apid="{{ $accountingperiod['apid'] }}">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor"><path fill="none" d="M0 0h24v24H0z"/><path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"/></svg>
                                </a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <div class="modal fade" id="beNewFinance" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered mw-650px">
                <div class="modal-content">
                    <form class="form" id="financeForm">
                        <div class="modal-header">
                            <h2 class="fw-bold">Yeni Giriş Ekle</h2>
                            <div class="btn btn-icon btn-sm btn-active-icon-primary" data-kt-users-modal-action="close">
                                <span class="svg-icon svg-icon-1">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="currentColor"/>
                                        <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="currentColor"/>
                                    </svg>
                                </span>
                            </div>
                        </div>
                        <div class="modal-body py-10 px-lg-17">
                            <div class="d-flex flex-column scroll-y me-n7 pe-7" id="kt_modal_update_user_scroll" data-kt-scroll="true" data-kt-scroll-activate="{default: false, lg: true}" data-kt-scroll-max-height="auto" data-kt-scroll-dependencies="#kt_modal_update_user_header" data-kt-scroll-wrappers="#kt_modal_update_user_scroll" data-kt-scroll-offset="300px">
                                <div class="collapse show">
                                    <div class="row mb-7">
                                        <div class="col-md-6 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">İşlem</label>
                                            <input type="text" class="form-control form-control-solid" name="name">
                                        </div>
                                        <div class="col-md-6 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Gün</label>
                                            <select class="form-control form-control-select" name="day">
                                                @for($i = 1; $i < 31; $i++)
                                                    <option value="{{ $i }}">{{ $i }}</option>
                                                @endfor
                                            </select>
                                        </div>
                                        <div class="col-md-6 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Tutar</label>
                                            <input type="text" class="form-control form-control-solid" name="total">
                                        </div>
                                        <div class="col-md-6 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Para Birimi</label>
                                            <select class="form-control form-control-select" name="currencie">
                                                @foreach($currencies as $currencie)
                                                    <option value="{{ $currencie['cid'] }}"{{ $systemcid == $currencie['cid'] ? ' selected':'' }}>{{ $currencie['cname'] }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-12">
                                            <label class="fs-6 fw-semibold mb-2">Türü</label>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-check form-check-custom form-check-solid">
                                                        <input class="form-check-input" type="radio" name="type" value="income" id="beAddMoney" checked="checked" />
                                                        <label class="form-check-label" for="beAddMoney">
                                                            Giriş
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-check form-check-custom form-check-solid">
                                                        <input class="form-check-input" type="radio" name="type" value="expense" id="beRemoveMoney"/>
                                                        <label class="form-check-label" for="beRemoveMoney">
                                                            Çıkış
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer flex-center">
                            <button type="reset" class="btn btn-light me-3" data-kt-users-modal-action="cancel">
                                İptal
                            </button>
                            <button class="btn btn-primary financeSaveForm">Ekle</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    $(".form-control-select").select2();
    var wait1 = false;
    $(".financeSaveForm").on("click",function(){
        if(!wait1){
            wait1 = true;
            $(".financeSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.accounting.periodic.add.post') }}",
                type: "post",
                async: true,
                data: $("#financeForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait1 = false;
                    $(".financeSaveForm").html("Ekle");
                    $("#beNewFinance").modal("hide");
                    if(response.status){
                        setTimeout(function(){
                            location.reload();
                        },1000);
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".btnDelete").on("click",function(){
        var apid = $(this).data("apid");
        $.ajax({
            url: "{{ beGetRoute('admin.accounting.periodic.delete.post') }}",
            type: "post",
            data: {apid:apid},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#"+apid+"Row").remove();
                    Swal.fire("Başarılı",response.message,"success");
    
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });	
        return false;
    });
</script>
@endsection