<div class="row">
    <div class="col-6 col-md-12 mb-3">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-drag-move-line"></i> {{ __('teamspeak_transaction_move_channel_text') }}</span>
                </div>
            </div>
            <div class="card-content">
                <form id="moveChannelForm">
                    <div class="row my-3">
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label>{{ __('teamspeak_transaction_move_channel') }}</label>
                                <select class="form-control" name="channel">
                                    @foreach($channellist as $channel)
                                    <option value="{{ $channel['cid'] }}">{{ $channel['channel_name'] }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label>{{ __('teamspeak_transaction_move_password') }}</label>
                                <input type="text" class="form-control" name="password" required="required">
                            </div>
                        </div>
                        <div class="col-12 row-center row-flex">
                            <a href="#" class="btn btn-primary beCallRequestx" data-method="move_all" data-form="moveChannel">
                                {{ __('teamspeak_transaction_move_channel_text') }}
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-6 col-md-12 mb-3">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-notification-line"></i> {{ __('teamspeak_transaction_poke_text') }}</span>
                </div>
            </div>
            <div class="card-content">
                <form id="pokeForm">
                    <div class="row my-3">
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label>{{ __('teamspeak_transaction_poke_message') }}</label>
                                <input type="text" class="form-control" name="message" required="required">
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label>{{ __('teamspeak_transaction_poke_count') }}</label>
                                <input type="number" class="form-control" name="count" value="1">
                            </div>
                        </div>
                        <div class="col-12 row-center row-flex">
                            <a href="#" class="btn btn-primary beCallRequestx" data-method="poke_all" data-form="poke">
                                {{ __('teamspeak_transaction_poke_text') }}
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-6 col-md-12 mb-3">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-eraser-line"></i> {{ __('teamspeak_transaction_kick_text') }}</span>
                </div>
            </div>
            <div class="card-content">
                <form id="kickForm">
                    <div class="row my-3">
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label>{{ __('teamspeak_transaction_kick_message') }}</label>
                                <input type="text" class="form-control" name="message" required="required">
                            </div>
                        </div>
                        <div class="col-12 row-center row-flex">
                            <a href="#" class="btn btn-primary beCallRequestx" data-method="kick_all" data-form="kick">
                                {{ __('teamspeak_transaction_kick_text') }}
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-6 col-md-12 mb-3">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-chat-1-line"></i> {{ __('teamspeak_transaction_message_text') }}</span>
                </div>
            </div>
            <div class="card-content">
                <form id="messageForm">
                    <div class="row my-3">
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label>{{ __('teamspeak_transaction_message_message') }}</label>
                                <input type="text" class="form-control" name="message" required="required">
                            </div>
                        </div>
                        <div class="col-12 row-center row-flex">
                            <a href="#" class="btn btn-primary beCallRequestx" data-method="message_all" data-form="message">
                                {{ __('teamspeak_transaction_message_text') }}
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-forbid-line"></i> {{ __('teamspeak_transaction_ban_text') }}</span>
                </div>
            </div>
            <div class="card-content">
                <form id="banForm">
                    <div class="row my-3">
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label>{{ __('teamspeak_transaction_message_message') }}</label>
                                <input type="text" class="form-control" name="message" required="required">
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label>{{ __('teamspeak_transaction_ban_duration') }}</label>
                                <input type="number" class="form-control" name="duration" value="0">
                            </div>
                        </div>
                        <div class="col-12 row-center row-flex">
                            <a href="#" class="btn btn-primary beCallRequestx" data-method="ban_all" data-form="ban">
                                {{ __('teamspeak_transaction_ban_text') }}
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
    var wait = false;
    $(".beCallRequestx").on("click",function(){
        if(!wait){
            wait = true;
            var item = $(this);
            var content = item.html();
            item.html('<span class="beSpinner"></span> Lütfen Bekleyiniz!');
            var method = item.data("method");
            var form = item.data("form");
            var data = item.data("data");
            var datacontent = "";
            if(form){
                datacontent = $("#"+form+"Form").serialize()+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            else{
                datacontent = data+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            $.ajax({
                url: "{{ beGetRoute('client.userproduct.userproduct.show.post') }}",
                type: "post",
                data: datacontent,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    item.html(content);
                    if(response.status){
                        $.Toast("Başarılı",response.message,"success");
                        if(response.refresh){
                            setTimeout(function(){
                                location.reload();
                            },1000);
                        }
                    }
                    else{
                        $.Toast("Bir Sorun Oluştu",response.message,"error");
                    }
                }
            });	
            return false;
        }
        else{
            $.Toast("Bir Sorun Oluştu","İşlem devam ediyor lütfen bekleyiniz","error");
        }
    });
</script>