<div class="row">
    <div class="col-6 col-md-12">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-git-repository-line"></i> {{ __('teamspeak_permission_add') }}</span>
                </div>
            </div>
            <div class="card-content">
                <form id="permissionAddForm">
                    <div class="row my-3">
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label for="Password1">{{ __('teamspeak_permission_user') }}</label>
                                <select class="form-control" name="clid">
                                    @foreach($clientlist as $client)
                                    <option value="{{ $client['clid'] }}">{{ $client['client_nickname'] }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label for="Password1">{{ __('teamspeak_permission_group') }}</label>
                                <select class="form-control" name="group">
                                    @foreach($grouplist as $group)
                                    <option value="{{ $group['sgid'] }}">{{ $group['name'] }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-12 row-center row-flex">
                            <a href="#" class="btn btn-primary beCallRequestx" data-method="permission_add" data-form="permissionAdd">
                                {{ __('teamspeak_permission_add') }}
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-6 col-md-12">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-git-repository-line"></i> {{ __('teamspeak_permission_del') }}</span>
                </div>
            </div>
            <div class="card-content">
                <form id="permissionDelForm">
                    <div class="row my-3">
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label for="Password1">{{ __('teamspeak_permission_user') }}</label>
                                <select class="form-control" name="clid">
                                    @foreach($clientlist as $client)
                                    <option value="{{ $client['clid'] }}">{{ $client['client_nickname'] }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <label for="Password1">{{ __('teamspeak_permission_group') }}</label>
                                <select class="form-control" name="group">
                                    @foreach($grouplist as $group)
                                    <option value="{{ $group['sgid'] }}">{{ $group['name'] }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-12 row-center row-flex">
                            <a href="#" class="btn btn-primary beCallRequestx" data-method="permission_del" data-form="permissionDel">
                                {{ __('teamspeak_permission_del') }}
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
    var wait = false;
    $(".beCallRequestx").on("click",function(){
        if(!wait){
            wait = true;
            var item = $(this);
            var content = item.html();
            item.html('<span class="beSpinner"></span> Lütfen Bekleyiniz!');
            var method = item.data("method");
            var form = item.data("form");
            var data = item.data("data");
            var datacontent = "";
            if(form){
                datacontent = $("#"+form+"Form").serialize()+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            else{
                datacontent = data+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            $.ajax({
                url: "{{ beGetRoute('client.userproduct.userproduct.show.post') }}",
                type: "post",
                data: datacontent,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    item.html(content);
                    if(response.status){
                        $.Toast("Başarılı",response.message,"success");
                        if(response.refresh){
                            setTimeout(function(){
                                location.reload();
                            },1000);
                        }
                    }
                    else{
                        $.Toast("Bir Sorun Oluştu",response.message,"error");
                    }
                }
            });	
            return false;
        }
        else{
            $.Toast("Bir Sorun Oluştu","İşlem devam ediyor lütfen bekleyiniz","error");
        }
    });
</script>