<!DOCTYPE html>
<html>
    <head>
        <title>{{ beGetConfig('sitename') }}</title>
        <meta http-equiv="X-UA-Compatible" content="chrome=1">
        <base href="{{ beGetConfig('siteurl') }}">
        <link rel="stylesheet" href="assets/plugins/vnc/base.css" title="plain">
    </head>
    <body style="margin: 0px;">
        <div id="noVNC_screen">
            <div id="noVNC_status_bar" class="noVNC_status_bar" style="margin-top: 0px; padding:10px">
                <table border=0 width="100%">
                    <tr>
                        <td width="1%">
                            <div id="noVNC_buttons" style="display: flex;">
                                <input type=button value="Ctrl+Alt+Del" id="beSendCtrlAltDelButton">
                            </div>
                        </td>
                        <td><div id="noVNC_status">Loading</div></td>
                        <td width="6%">
                            <div id="noVNC_buttons" style="display: flex;">
                                <a href="{{ $url }}" style="padding: 4px 20px;color: #59626d;background: #fff;text-decoration: none;">Geri Dön</a>
                            </div>
                        </td>
                    </tr>
                </table>
            </div>
            <div id="screen">
              
            </div>
        </div>
        <script type="text/javascript">
            window._noVNC_has_module_support = true;
            window.addEventListener("load", function() {                                                                      
                if (window._noVNC_has_module_support) return;
                var loader = document.createElement("script");
                loader.src = "assets/plugins/vnc/browser-es-module-loader.js";
                document.head.appendChild(loader);
            });
        </script>
        <script type="module">
            import RFB from "./assets/plugins/vnc/core/rfb.js";
            var rfb,desktopName;
            function connectedToServer(e) {
                status(desktopName+" Cihazıyla Bağlantı Kuruldu");
            }
            function disconnectedFromServer(e) {
                if(e.detail.clean){
                    status("Bağlantı Kesildi");
                } 
                else{
                    status("Bir bağlantı hatası oluştu lütfen kontrol ediniz");
                }
            }
            function credentialsAred(e) {
                const password = prompt("Password d:");
                rfb.sendCredentials({ password: password });
            }
            function updateDesktopName(e){ 
                desktopName = e.detail.name; 
            }
            function status(text){
                document.getElementById("noVNC_status").textContent = text;
            }
            function debug(text){
                document.getElementById("noVNC_status").textContent = text;
            }
            function sendCtrlAltDel(){ 
                rfb.sendCtrlAltDel(); return false; 
            }
            document.getElementById("beSendCtrlAltDelButton").onclick = sendCtrlAltDel;
            status("Bağlanılıyor");
            rfb = new RFB(document.getElementById("screen"),"{{ $wss_url }}",{
                credentials: {
                    password: "{{ $password }}"
                },
                wsProtocols: ["binary"],
            });
            rfb.addEventListener("connect",connectedToServer);
            rfb.addEventListener("disconnect",disconnectedFromServer);
            rfb.addEventListener("credentialsd",credentialsAred);
            rfb.addEventListener("desktopname",updateDesktopName);
            rfb.viewOnly = false;
            rfb.scaleViewport = false;
            rfb.connect();
        </script>
    </body>
</html>