<!DOCTYPE html>
<html xml:lang="tr" lang="tr" xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta charset="UTF-8">
        <title>Hizmet Yükselt - {{ beGetConfig('sitename') }}</title>
        {{ $headerinclude }}
        <link href="assets/betheme/css/clientarea.css?ver=24" rel="stylesheet">
        <link href="assets/betheme/css/card.css?ver=22" rel="stylesheet">
        <link href="assets/betheme/css/col.css?ver=16" rel="stylesheet">
        <link href="assets/betheme/css/forms.css?ver=21" rel="stylesheet">
    </head>
    <body>
        <main>
            {{ $header }}
            <div class="content">
                <div class="container-xxl bclientarea">
                    <div class="col-3 col-md-12">
                        <div class="bmenu">
                            <div class="bmenu-header">
                                <span>Hızlı Erişim</span>
                            </div>
                            <div class="bmenu-content">
                                <ul>
                                    <li data-page="client.dashboard.alternative">
                                        <a href="{{ beGetRoute('client.dashboard.alternative') }}">
                                            <div>
                                                <i class="ri-service-line"></i>
                                                <span>Ana Sayfa</span>
                                            </div>
                                        </a>
                                    </li>
                                    <li data-page="client.userproduct.userproducts">
                                        <a href="{{ beGetRoute('client.userproduct.userproducts') }}">
                                            <div>
                                                <i class="ri-shopping-cart-line"></i>
                                                <span>Hizmetlerim</span>
                                            </div>
                                        </a>
                                    </li>
                                    <li class="has-mainmenu" data-page="client.ticket.tickets" data-mainmenu="clientarea-ticketmenu">
                                        <a href="{{ beGetRoute('client.ticket.tickets') }}">
                                            <div>
                                                <i class="ri-ticket-line"></i>
                                                <span>Destek Taleplerim</span>
                                            </div>
                                        </a>
                                    </li>
                                    <li class="has-mainmenu" data-page="client.ticket.newticket" data-mainmenu="clientarea-ticketmenu">
                                        <a href="{{ beGetRoute('client.ticket.newticket') }}">
                                            <div>
                                                <i class="ri-coupon-3-line"></i>
                                                <span>Yeni Destek Talebi</span>
                                            </div>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-9 col-md-12">
                        <div class="bcontent">
                            <div class="card mb-3">
                                <div class="card-header">
                                    <div>
                                        <span class="card-title"><i class="ri-git-repository-private-line"></i> Hizmetimi Yükselt</span>
                                    </div>
                                </div>
                                <div class="card-content">
                                    <form id="beLanguageForm">
                                        <div class="row">
                                            <div class="col-6 mb-3">
                                                <div class="form-group">
                                                    <label for="#">Aktif Hizmet</label>
                                                    <select class="form-control" name="oldproduct" disabled>
                                                        @foreach($products as $product)
                                                        @if($userproduct['pid'] != $product['pid'])
                                                        @php continue; @endphp
                                                        @endif
                                                        <option value="{{ $product['pid'] }}">{{ $product['pname'] }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-6 mb-3">
                                                <div class="form-group">
                                                    <label for="#">Yükseltilecek Hizmet</label>
                                                    <select class="form-control" name="newproduct">
                                                        <option value="0">Seçiniz</option>
                                                        @foreach($products as $product)
                                                        @if(!in_array($product['pid'],$userproduct['pupgradeproducts']))
                                                        @php continue; @endphp
                                                        @endif
                                                        <option value="{{ $product['pid'] }}">{{ $product['pname'] }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-3" id="upgradeData" style="display: none;">
                                                <p class="text-normal mb-3">Hizmetiniz olan <span class="oldproduct text-hard"></span> adlı ürünün süresinin bitmesine <span class="remainingtime text-hard"></span> kaldı. Normal şartlarda aynı periyot için <span class="newproduct text-hard"></span> adlı ürünün ödemesi <span class="newfullprice text-hard"></span> iken sizin kalan günleriniz için <span class="newprice text-hard"></span> ödemeniz gerekmektedir. Eğer onaylıyorsanız aşağıda bulunan onaylıyorum butonuna basarak faturanızın oluşturulmasını sağlayabilirsiniz.</p>
                                                <div class="mb-1"><span class="text-hard mr-2"><span class="oldproduct"></span>(<span class="oldfullprice text-hard"></span>)</span>-&gt;<span class="text-hard ml-2"><span class="newproduct"></span>(<span class="newfullprice text-hard"></span>)</span></div>
                                                <div><span class="text-hard">Geçiş Ücreti: <span class="newprice text-hard"></span></span></div>
                                            </div>
                                            <div class="col-12 row-center row-flex">
                                                <a href="#" class="btn btn-special beUpdateInvoice" data-url="#">Onaylıyorum</a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <script>
                var pid = 0;
                $("select[name='newproduct']").change(function(){
                    pid = $(this).val();
                    beClassRequest("{{ beGetRoute('client.userproduct.upgrade.post') }}",{upid:{{ $userproduct['upid'] }},pid:pid,step:1},function(response){
                        $(".oldproduct").html(response.oldproductname);
                        $(".newproduct").html(response.newproductname);
                        $(".remainingtime").html(response.remainingtimeuser+" "+response.calculateperiodname);
                        $(".oldfullprice").html(response.oldfullprice+" "+response.currency.cicon);
                        $(".newfullprice").html(response.newfullprice+" "+response.currency.cicon);
                        $(".newprice").html(response.newprice+" "+response.currency.cicon);
                        $("#upgradeData").show();
                    });
                })
                $(".beUpdateInvoice").on("click",function(){
                    beClassRequest("{{ beGetRoute('client.userproduct.upgrade.post') }}",{upid:{{ $userproduct['upid'] }},pid:pid,step:2});
                    return false;
                })
            </script>
            {{ $footer }}
        </main>
    </body>
</html>