@extend('admin.layout')
@section('headerinclude')
<style>
.accordpool.active {
    display: flex;
    flex-shrink: 0;
    transition: all 0.2s ease-in-out;
    transform: rotate(90deg);
    align-items: center;
    justify-content: center;
    color: var(--kt-primary);
}
.accordpool.active > span {
    color: var(--kt-primary);
}
</style>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Destek Hazır Cevap
                </div>
            </div>
            <div class="card-body">
                <form id="predefinedMessageForm">
                    <input type="hidden" name="tpcid" value="{{ $predefinedcategory['tpcid'] }}">
                    <div class="row">
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kategori Adı</label>
                            <input type="text" class="form-control" name="categoryname" value="{{ $predefinedcategory['tpcname'] }}">
                        </div>
                        <div class="col-12 mb-9">
                            <div class="row">
                            @foreach($predefinedreplies as $predefinedreply)
                            <div class="col-12 maindraggable my-2" id="predefinedReplyArea{{ $predefinedreply['tprid'] }}">
                                <div class="card card-bordered">
                                    <div class="card-header">
                                        <div class="card-title">
                                            <h3 class="card-label">{{ $predefinedreply['tprname'].' '.$languages[$predefinedreply['lid']]['lname'] }}</h3>
                                        </div>
                                        <div class="card-toolbar">
                                            <span class="accordion-icon accordpool" data-tprid="{{ $predefinedreply['tprid'] }}">
                                                <span class="svg-icon svg-icon-1">
                                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <rect opacity="0.5" x="18" y="13" width="13" height="2" rx="1" transform="rotate(-180 18 13)" fill="currentColor"></rect>
                                                        <path d="M15.4343 12.5657L11.25 16.75C10.8358 17.1642 10.8358 17.8358 11.25 18.25C11.6642 18.6642 12.3358 18.6642 12.75 18.25L18.2929 12.7071C18.6834 12.3166 18.6834 11.6834 18.2929 11.2929L12.75 5.75C12.3358 5.33579 11.6642 5.33579 11.25 5.75C10.8358 6.16421 10.8358 6.83579 11.25 7.25L15.4343 11.4343C15.7467 11.7467 15.7467 12.2533 15.4343 12.5657Z" fill="currentColor"></path>
                                                    </svg>
                                                </span>
                                            </span>
                                        </div>
                                    </div>
                                    <div id="predefinedreply{{ $predefinedreply['tprid'] }}" data-status="0" style="display:none">
                                        <div class="card-body px-5 pt-5 pb-0">
                                            <div class="row">
                                                <div class="col-6 mb-9">
                                                    <label class="fs-6 fw-semibold mb-2">Başlık</label>
                                                    <input type="text" class="form-control" name="name[{{ $predefinedreply['tprid'] }}]" value="{{ $predefinedreply['tprname'] }}">
                                                </div>
                                                <div class="col-6 mb-9">
                                                    <label class="fs-6 fw-semibold mb-2">Dil</label>
                                                    <select class="form-control form-control-select" name="language[{{ $predefinedreply['tprid'] }}]">
                                                        @foreach($languages as $language)
                                                        <option value="{{ $language['lid'] }}"{{ $signature['lid'] == $language['lid'] ? ' selected':'' }}>{{ $language['lname'] }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="col-12 mb-9">
                                                    <label class="fs-6 fw-semibold mb-2">Mesaj</label>
                                                    <textarea class="form-control form-control-flush mb-3 messageArea" name="message[{{ $predefinedreply['tprid'] }}]" rows="5" placeholder="Lütfen mesajınızı yazınız">{{ $predefinedreply['tprmessage'] }}</textarea>
                                                </div>
                                                <div class="col-12 mb-9">
                                                    <button class="btn btn-danger d-block m-auto predefinedMessageDelete" data-tprid="{{ $predefinedreply['tprid'] }}">Sil</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                            </div>
                        </div>
                        @if($predefinedreplies)
                        <hr>
                        @endif
                        <div class="col-12 mb-9">
                            <div class="col-12 maindraggable my-2">
                                <div class="card card-bordered">
                                    <div class="card-header">
                                        <div class="card-title">
                                            <h3 class="card-label">Yeni Ekle</h3>
                                        </div>
                                        <div class="card-toolbar">
                                            <span class="accordion-icon accordpool" data-tprid="0">
                                                <span class="svg-icon svg-icon-1">
                                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <rect opacity="0.5" x="18" y="13" width="13" height="2" rx="1" transform="rotate(-180 18 13)" fill="currentColor"></rect>
                                                        <path d="M15.4343 12.5657L11.25 16.75C10.8358 17.1642 10.8358 17.8358 11.25 18.25C11.6642 18.6642 12.3358 18.6642 12.75 18.25L18.2929 12.7071C18.6834 12.3166 18.6834 11.6834 18.2929 11.2929L12.75 5.75C12.3358 5.33579 11.6642 5.33579 11.25 5.75C10.8358 6.16421 10.8358 6.83579 11.25 7.25L15.4343 11.4343C15.7467 11.7467 15.7467 12.2533 15.4343 12.5657Z" fill="currentColor"></path>
                                                    </svg>
                                                </span>
                                            </span>
                                        </div>
                                    </div>
                                    <div id="predefinedreply0" data-status="0" style="display:none">
                                        <div class="card-body px-5 pt-5 pb-0">
                                            <div class="row">
                                                <div class="col-6 mb-9">
                                                    <label class="fs-6 fw-semibold mb-2">Başlık</label>
                                                    <input type="text" class="form-control" name="add_name">
                                                </div>
                                                <div class="col-6 mb-9">
                                                    <label class="fs-6 fw-semibold mb-2">Dil</label>
                                                    <select class="form-control form-control-select" name="add_language">
                                                        @foreach($languages as $language)
                                                        <option value="{{ $language['lid'] }}">{{ $language['lname'] }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="col-12 mb-9">
                                                    <label class="fs-6 fw-semibold mb-2">Mesaj</label>
                                                    <textarea class="form-control form-control-flush mb-3 messageArea" name="add_message" rows="5" placeholder="Lütfen mesajınızı yazınız"></textarea>
                                                </div>
                                                <div class="col-12 mb-9">
                                                    <button class="btn btn-primary d-block m-auto predefinedMessageAdd">Ekle</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>                            
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto predefinedCategoryEdit">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script src="assets/plugins/custom/tinymce/tinymce.bundle.js"></script>
<script>
    $(".form-control-select").select2();
    $(".accordpool").on("click",function(){
        var tprid = $(this).data("tprid");
        var content = $("#predefinedreply"+tprid);
        if(content.attr("data-status") == "0"){
            content.attr("data-status","1");
            $(this).addClass("active");
            content.show();
        }
        else{
            content.attr("data-status","0");
            $(this).removeClass("active");
            content.hide();
        }
        return false;
    });

    $(document).ready(function(){
        $(".form-control-select").select2();
        var options = {selector:".messageArea",height:"480",entity_encoding:"raw",verify_html:false,plugins:'code searchreplace autolink directionality visualblocks visualchars image link media codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap emoticons autosave fullscreen',toolbar: "undo redo print spellcheckdialog formatpainter | blocks fontfamily fontsize | bold italic underline forecolor backcolor | link image | alignleft aligncenter alignright alignjustify | code"};
        if(KTThemeMode.getMode() === "dark"){
            options["skin"] = "oxide-dark";
            options["content_css"] = "dark";
        }
        tinymce.init(options);
    });
    var wait = false;
    $(".predefinedMessageAdd").on("click",function(){
        if(!wait){
            $(".predefinedMessageAdd").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            tinymce.triggerSave();
            $.ajax({
                url: "{{ beGetRoute('admin.ticket.predefined.message.add.post') }}",
                type: "post",
                async: true,
                data: $("#predefinedMessageForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".predefinedMessageAdd").html('Ekle');
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                        setTimeout(function(){
                            location.reload();
                        },1000);
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".predefinedMessageDelete").on("click",function(){
        if(!wait){
            var tprid = $(this).data("tprid");
            $(".predefinedMessageDelete").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            tinymce.triggerSave();
            $.ajax({
                url: "{{ beGetRoute('admin.ticket.predefined.message.delete.post') }}",
                type: "post",
                async: true,
                data: {tprid:tprid,tpcid:{{ $predefinedcategory['tpcid'] }}},
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".predefinedMessageDelete").html('Ekle');
                    if(response.status){
                        $("#predefinedReplyArea"+tprid).remove();
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".predefinedCategoryEdit").on("click",function(){
        if(!wait){
            $(".predefinedCategoryEdit").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            tinymce.triggerSave();
            $.ajax({
                url: "{{ beGetRoute('admin.ticket.predefined.category.edit.post') }}",
                type: "post",
                async: true,
                data: $("#predefinedMessageForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".predefinedCategoryEdit").html('Kaydet');
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection