@extend('admin.layout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        @if($be->ticketstats['inprocess'])
        <div class="alert alert-danger d-flex align-items-center p-5">
            <span class="svg-icon svg-icon-2hx svg-icon-danger me-4">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path opacity="0.3" d="M22.0318 8.59998C22.0318 10.4 21.4318 12.2 20.0318 13.5C18.4318 15.1 16.3318 15.7 14.2318 15.4C13.3318 15.3 12.3318 15.6 11.7318 16.3L6.93177 21.1C5.73177 22.3 3.83179 22.2 2.73179 21C1.63179 19.8 1.83177 18 2.93177 16.9L7.53178 12.3C8.23178 11.6 8.53177 10.7 8.43177 9.80005C8.13177 7.80005 8.73176 5.6 10.3318 4C11.7318 2.6 13.5318 2 15.2318 2C16.1318 2 16.6318 3.20005 15.9318 3.80005L13.0318 6.70007C12.5318 7.20007 12.4318 7.9 12.7318 8.5C13.3318 9.7 14.2318 10.6001 15.4318 11.2001C16.0318 11.5001 16.7318 11.3 17.2318 10.9L20.1318 8C20.8318 7.2 22.0318 7.59998 22.0318 8.59998Z" fill="currentColor"></path>
                    <path d="M4.23179 19.7C3.83179 19.3 3.83179 18.7 4.23179 18.3L9.73179 12.8C10.1318 12.4 10.7318 12.4 11.1318 12.8C11.5318 13.2 11.5318 13.8 11.1318 14.2L5.63179 19.7C5.23179 20.1 4.53179 20.1 4.23179 19.7Z" fill="currentColor"></path>
                </svg>
            </span>
            <div class="d-flex flex-column">
                <h4 class="mb-1 text-danger">İşlemde Talep Mevuct</h4>
                <span>Destek sistemi üzerinde İşleme Alınmış moduna bekleyen talepler mevcut! Lütfen belirtilen talepleri kontrol ediniz!</span>
            </div>
        </div>
        @endif
        <div class="card mb-4">
            <div class="card-body">
                <div class="row">
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Talep Sahibi</label>
                        <input type="text" class="form-control" id="searchTicketUser" placeholder="Aramak istediğiniz kişinin adını soyadını adresini giriniz">
                    </div>
                    <div class="col-4">
                        <label class="fs-6 fw-semibold mb-2">Talep Adı</label>
                        <input type="text" class="form-control" id="searchTicketName" placeholder="Aramak istediğiniz faturanın adını giriniz">
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Talep Sorumlusu</label>
                        <input type="text" class="form-control" id="searchTicketAdmin" placeholder="Aramak istediğiniz kişinin adını soyadını adresini giriniz">
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Departman</label>
                        <select class="form-control form-control-select" id="searchTicketDepertment">
                            <option value="0">Hepsi</option>
                            @foreach($depertments as $tdid => $depertment)
                            <option value="{{ $tdid }}">{{ $depertment['tdname'] }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Sıralama Türü</label>
                        <select class="form-control form-control-select" id="searchTicketSort">
                            <option value="1">Sondan Başa</option>
                            <option value="2">Baştan Sona</option>
                        </select>
                    </div>
                    <div class="col-12 d-flex justify-content-center mt-5">
                        <a data-bs-toggle="tooltip" href="#" class="btn btnFind btn-primary mx-2">
                            <i class="fonticon-equalizer fs-4 me-1"></i>
                            Ara
                        </a>
                        <a data-bs-toggle="tooltip" href="#" class="btn btnFindEmpty btn-warning mx-2">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor"><path fill="none" d="M0 0h24v24H0z"></path><path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"></path></svg>
                            Temizle
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="alert alert-warning d-flex align-items-center p-5">
            <span class="svg-icon svg-icon-2hx svg-icon-warning me-4">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect opacity="0.5" x="13" y="6" width="13" height="2" rx="1" transform="rotate(90 13 6)" fill="currentColor"></rect>
                    <path d="M12.5657 8.56569L16.75 12.75C17.1642 13.1642 17.8358 13.1642 18.25 12.75C18.6642 12.3358 18.6642 11.6642 18.25 11.25L12.7071 5.70711C12.3166 5.31658 11.6834 5.31658 11.2929 5.70711L5.75 11.25C5.33579 11.6642 5.33579 12.3358 5.75 12.75C6.16421 13.1642 6.83579 13.1642 7.25 12.75L11.4343 8.56569C11.7467 8.25327 12.2533 8.25327 12.5657 8.56569Z" fill="currentColor"></path>
                </svg>
            </span>
            <div class="d-flex flex-column">
                <h4 class="mb-1 text-warning">Toplam Destek Talebi Adedi</h4>
                <span id="ticketCount"></span>
            </div>
        </div>
        <div class="card mb-4">
            <div class="table-responsive">
                <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                    <thead>
                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                            <th class="text-center align-middle">#</th>
                            <th class="text-center align-middle">Sahip</th>
                            <th class="text-center align-middle">Başlık</th>
                            <th class="text-center align-middle">Durum</th>
                            <th class="text-center align-middle">Son Cevap</th>
                            <th class="text-center align-middle">Departman</th>
                            <th class="text-center align-middle">Sorumlu</th>
                            <th class="text-center align-middle">Etkilenen Hizmetler</th>
                            <th class="text-center align-middle">Oluşturulma Tarihi</th>
                            <th class="text-center align-middle">Düzenle</th>
                        </tr>
                    </thead>
                    <tbody id="ticketList">

                    </tbody>
                </table>
            </div>
        </div>
        <div class="card mb-4">
            <div class="card-body">
                <div class="row" id="paganation">
                    
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    $(".form-control-select").select2();
    var page = 1;
    $("#ticketList").on("click",".btnDelete",function(){
        var tid = $(this).data("tid");
        Swal.fire({
            html: "Bu talebi silmek istediğinize emin misiniz ?",
            icon: "info",
            buttonsStyling: false,
            showCancelButton: true,
            confirmButtonText: "Onaylıyorum",
            cancelButtonText: "Vazgeçtim",
            customClass: {
                confirmButton: "btn btn-primary",
                cancelButton: "btn btn-danger"
            }
        }).then((result) => {
            if(result.isConfirmed) {
                $.ajax({
                    url: "{{ beGetRoute('admin.ticket.delete.post') }}",
                    type: "post",
                    data: {tid:tid},
                    dataType: "json",
                    crossDomain: true,
                    success: function(response){
                        if(response.status){
                            $("#"+tid+"Row").remove();
                            Swal.fire("Başarılı",response.message,"success");
            
                        }
                        else{
                            Swal.fire("Bir Hata Oluştu",response.message,"error");
                        }
                    }
                });	
            }
        });
        return false;
    });
    $(".btnFind").on("click",function(){
        var name = $("#searchTicketName").val();
        var depertment = $("#searchTicketDepertment").val();
        if(depertment < 0){
            depertment = 0;
        }
        var user = $("#searchTicketUser").val();
        var admin = $("#searchTicketAdmin").val();
        var sort = $("#searchTicketSort").val();
        if(!sort){
            sort = 0;
        }
        beSearchTicket(name,depertment,admin,user,sort);
        return false;
    });
    $(".btnFindEmpty").on("click",function(){
        $("#searchTicketName").val("");
        $("#searchTicketDepertment option:first").attr("selected","selected");
        $("#searchTicketUser").val("");
        $("#searchTicketAdmin").val("");
        $("#searchTicketSort option:first").attr("selected","selected");
        beSearchTicket("",0,"","",0);
        return false;
    });
    $("#paganation").on("click",".goPaganation",function(){
        page = parseInt($(this).data("page"));
        $(".btnFind").trigger("click");
        return false;
    });
    $(document).ready(function(){
        beSearchTicket("",0,"","",0);
    });
    function beSearchTicket(name,depertment,admin,user,sort){
        $.ajax({
            url: "{{ beGetRoute('admin.ticket.search.post') }}",
            type: "post",
            data: {name:name,status:"{{ $status }}",depertment:depertment,admin:admin,user:user,sort:sort,page:page},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#paganation").empty().append(response.paganation);
                    $("#ticketList").empty().append(response.html);
                    $("#ticketCount").empty().append(response.ticketcount+" Adet");
                    $(".form-control-select").select2();
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
    }
</script>
@endsection