@extend('admin.layout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-7">
            <div class="card-header">
                <div class="card-title mt-5 d-block mb-0">
                    <div class="d-block">
                        Departman Bilgileri
                    </div>
                    <ul class="nav nav-stretch nav-line-tabs nav-line-tabs-2x border-transparent fs-5 fw-bold">
                        @foreach($languages as $language)
                        <li class="nav-item mt-2">
                            <a class="nav-link nav-language text-active-primary ms-0 me-10 py-5 {{ $language['lid'] == $systemlid ? 'active':'' }}" href="#" data-lang="{{ $language['lid'] }}">{{ $language['lname'] }}</a>
                        </li>
                        @endforeach
                    </ul>
                </div>
            </div>
            <div class="card-body">
                <form id="depertmentForm">
                    <div class="row">
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Sorumlular</label>
                            <select class="form-control form-control-select" name="users[]" multiple>
                                @foreach($ticketusers as $user)
                                <option value="{{ $user['uid'] }}"{{ in_array($user['uid'],$depertment['admins']) ? ' selected':'' }}>{{ $user['name'].' '.$user['surname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    @foreach($languages as $language)
                    @foreach($depertmenttranslations as $depertmenttranslation)
                        @php
                            if($depertmenttranslation['lid'] != $language['lid']){
                                continue;
                            }
                            break;
                        @endphp
                    @endforeach
                    <div class="row languageTab {{ $language['lid'] == $systemlid ? 'd-flex':'d-none' }} languageTab{{ $language['lid'] }}">
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Departman Adı</label>
                            <input type="text" class="form-control" name="tdname[{{ $language['lid'] }}]" value="{{ $depertmenttranslation['tdname'] }}">
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto editDepertment">Kaydet</button>
                        </div>
                    </div>
                    @endforeach
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    $(".form-control-select").select2();
    $(".nav-language").on("click",function(){
        var lang = $(this).data("lang");
        $(".nav-language.active").removeClass("active");
        $(this).addClass("active");
        $(".languageTab.d-flex").removeClass("d-flex").addClass("d-none");
        $(".languageTab"+lang).addClass("d-flex").removeClass("d-none");
        return false;
    });
    var wait = false;
    $(".editDepertment").on("click",function(){
        if(!wait){
            $(".editDepertment").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.ticket.depertment.edit.post') }}",
                type: "post",
                async: true,
                data: $("#depertmentForm").serialize()+"&tdid={{ $depertment['tdid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".editDepertment").html('Kaydet');
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection