@extend('admin.layout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="d-flex justify-content-end">
            <a href="{{ beGetRoute('admin.page.add') }}" class="d-inline-flex align-items-center btn btn-primary mb-5 mx-3">
                <span class="svg-icon svg-icon-muted d-flex align-items-center">
                    <svg width="23" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"/>
                        <rect x="10.8891" y="17.8033" width="12" height="2" rx="1" transform="rotate(-90 10.8891 17.8033)" fill="currentColor"/>
                        <rect x="6.01041" y="10.9247" width="12" height="2" rx="1" fill="currentColor"/>
                    </svg>
                </span>
                Yeni Ekle
            </a>
        </div>
        <div class="card mb-4">
            <div class="card-body">
                <div class="row">
                    <div class="col-4">
                        <label class="fs-6 fw-semibold mb-2">Tip</label>
                        <select class="form-control form-control-select" id="searchPageType">
                            <option value="0">Hepsi</option>
                            @foreach($pagetypes as $key => $pagetype)
                            <option value="{{ $key }}">{{ $pagetype }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-4">
                        <label class="fs-6 fw-semibold mb-2">Dil</label>
                        <select class="form-control form-control-select" id="searchPageLanguage">
                            <option value="0">Seçiniz</option>
                            @foreach($languages as $language)
                                <option value="{{ $language['lid'] }}">{{ $language['lname'] }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-4">
                        <label class="fs-6 fw-semibold mb-2">Sıralama Türü</label>
                        <select class="form-control form-control-select" id="searchPageSort">
                            <option value="1">Sondan Başa</option>
                            <option value="2">Baştan Sona</option>
                        </select>
                    </div>
                    <div class="col-12 d-flex justify-content-center mt-5">
                        <a data-bs-toggle="tooltip" href="#" class="btn btnFind btn-primary mx-2">
                            <i class="fonticon-equalizer fs-4 me-1"></i>
                            Ara
                        </a>
                        <a data-bs-toggle="tooltip" href="#" class="btn btnFindEmpty btn-warning mx-2">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor"><path fill="none" d="M0 0h24v24H0z"></path><path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"></path></svg>
                            Temizle
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="alert alert-warning d-flex align-items-center p-5">
            <span class="svg-icon svg-icon-2hx svg-icon-warning me-4">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect opacity="0.5" x="13" y="6" width="13" height="2" rx="1" transform="rotate(90 13 6)" fill="currentColor"></rect>
                    <path d="M12.5657 8.56569L16.75 12.75C17.1642 13.1642 17.8358 13.1642 18.25 12.75C18.6642 12.3358 18.6642 11.6642 18.25 11.25L12.7071 5.70711C12.3166 5.31658 11.6834 5.31658 11.2929 5.70711L5.75 11.25C5.33579 11.6642 5.33579 12.3358 5.75 12.75C6.16421 13.1642 6.83579 13.1642 7.25 12.75L11.4343 8.56569C11.7467 8.25327 12.2533 8.25327 12.5657 8.56569Z" fill="currentColor"></path>
                </svg>
            </span>
            <div class="d-flex flex-column">
                <h4 class="mb-1 text-warning">Toplam Sayfa Adedi</h4>
                <span id="pageCount"></span>
            </div>
        </div>
        <div class="card mb-4">
            <div class="table-responsive">
                <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                    <thead>
                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                            <th class="text-center align-middle">#</th>
                            <th class="text-center align-middle">Dil</th>
                            <th class="text-center align-middle">Sayfa</th>
                            <th class="text-center align-middle">Tip</th>
                            <th class="text-center align-middle">Görüntülenme(Kayıtlı,Ziyaretçi)</th>
                            <th class="text-center align-middle">Açılış Tarihi</th>
                            <th class="text-center align-middle">Düzenle</th>
                            <th class="text-center align-middle"></th>
                        </tr>
                    </thead>
                    <tbody id="pageList">

                    </tbody>
                </table>
            </div>
        </div>
        <div class="card mb-4">
            <div class="card-body">
                <div class="row" id="paganation">
                    
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    $(".form-control-select").select2();
    var page = 1;
    $(".btnFind").on("click",function(){
        var type = $("#searchPageType").val();
        var language = $("#searchPageLanguage").val();
        if(!language){
            language = 0;
        }
        var sort = $("#searchPageSort").val();
        if(!sort){
            sort = 0;
        }
        beSearchPage(type,language,sort);
        return false;
    });
    $(".btnFindEmpty").on("click",function(){
        $("#searchPageType option:first").attr("selected","selected");
        $("#searchPageLanguage option:first").attr("selected","selected");
        $("#searchPageSort option:first").attr("selected","selected");
        beSearchPage(0,0,0);
        return false;
    });
    $("#paganation").on("click",".goPaganation",function(){
        page = parseInt($(this).data("page"));
        $(".btnFind").trigger("click");
        return false;
    });
    $(document).ready(function(){
        beSearchPage(0,0,0);
    });
    function beSearchPage(type,language,sort){
        $.ajax({
            url: "{{ beGetRoute('admin.page.search.post') }}",
            type: "post",
            data: {type:type,language:language,sort:sort,page:page},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#paganation").empty().append(response.paganation);
                    $("#pageList").empty().append(response.html);
                    $("#pageCount").empty().append(response.itemcount+" Adet");
                    $(".form-control-select").select2();
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
    }
    $("#pageList").on("click",".btnDelete",function(){
        var pid = $(this).data("pid");
        Swal.fire({
            html: "Bu sayfayı silmek istediğinize emin misiniz ?",
            icon: "info",
            buttonsStyling: false,
            showCancelButton: true,
            confirmButtonText: "Onaylıyorum",
            cancelButtonText: "Vazgeçtim",
            customClass: {
                confirmButton: "btn btn-primary",
                cancelButton: "btn btn-danger"
            }
        }).then((result) => {
            if(result.isConfirmed) {
                $.ajax({
                    url: "{{ beGetRoute('admin.page.delete.post') }}",
                    type: "post",
                    data: {pid:pid},
                    dataType: "json",
                    crossDomain: true,
                    success: function(response){
                        if(response.status){
                            $("."+pid+"Row").remove();
                            Swal.fire("Başarılı",response.message,"success");
            
                        }
                        else{
                            Swal.fire("Bir Hata Oluştu",response.message,"error");
                        }
                    }
                });	
            }
        });
        return false;
    });
</script>
@endsection