<?php

    namespace App\System\Plugin;
    use App\System\Basic\beModel;
    use App\System\Basic\beRouter;
    use App\System\Controller\ConnectionController;
    use App\System\Model\SettingGroupsModel;
    use App\System\Model\SettingModel;
    use App\System\Vendor\Auth;
    use App\System\Vendor\beModule;
    use App\System\Vendor\bePlugin;

    class vallet_helper {
        public function plugin_info(){
            return [
                "name" => "Vallet Eklentisi",
                "description" => "Vallet modülününü çalışması için gerekli alt yapıyı sağlar",
                "version" => "1.0",
                "vercode" => 1,
                "author" => "ITenGriTR"
            ];
        }
        public function plugin_hooks(){
            return [];
        }
        public function plugin_settings(){
            $settinggroup = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","vallet")->beGet();
            return ["status" => true,"url" => beGetRoute("admin.settings.settinggroup.show",["sgid" => $settinggroup["sgid"]])];
        }
        public function plugin_install(){
            $sgid = bePlugin::beCreateSettingGroup("vallet","Vallet Ödeme Yöntemi","Vallet ödeme yöntemi için gerekli ayarları yükler");
            bePlugin::beCreateSetting($sgid,"vallet_status","Durum","Vallet ödeme yöntemi aktiflik durumu","select\n0=Kapalı\n1=Açık","0");
            bePlugin::beCreateSetting($sgid,"vallet_merchant_id","Üye İşyeri Numarası","Vallet paneli üzerinde firma ayarları alanında üye işyeri numarası","int");
            bePlugin::beCreateSetting($sgid,"vallet_merchant_key","API Anahtarı","Vallet paneli üzerinde firma ayarları alanındaki api anahtarı","str");
            bePlugin::beCreateSetting($sgid,"vallet_merchant_secret","API Güvenlik Anahtarı","Vallet paneli üzerinde firma ayarları alanındaki api güvenlik anahtarı","str");
            bePlugin::beCreateSetting($sgid,"vallet_merchant_username","Üye Kullanıcı Adı","Vallet paneli üzerinde firma ayarları alanındaki api güvenlik anahtarı","str");
            bePlugin::beCreateSetting($sgid,"vallet_methodfee","Komisyon Oranı","Vallet ödeme yöntemi için eklenecek olan ekstra komisyon","int");
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti kuruldu!"];
        }
        public function plugin_remove(){
            $sgid = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","vallet")->beGet()["sgid"];
            SettingGroupsModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            SettingModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti silindi!"];
        }
    }
?>