<?php

    namespace App\System\Plugin;
    use App\System\Model\SettingGroupsModel;
    use App\System\Model\SettingModel;
    use App\System\Vendor\bePlugin;

    class shopier_helper {
        public function plugin_info(){
            return [
                "name" => "Shopier Eklentisi",
                "description" => "Shopier modülününü çalışması için gerekli alt yapıyı sağlar",
                "version" => "1.0",
                "vercode" => 1,
                "author" => "ITenGriTR"
            ];
        }
        public function plugin_hooks(){
            return [];
        }
        public function plugin_settings(){
            $settinggroup = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","shopier")->beGet();
            return ["status" => true,"url" => beGetRoute("admin.settings.settinggroup.show",["sgid" => $settinggroup["sgid"]])];
        }
        public function plugin_install(){
            $sgid = bePlugin::beCreateSettingGroup("shopier","Shopier Ödeme Yöntemi","Shopier ödeme yöntemi için gerekli ayarları yükler");
            bePlugin::beCreateSetting($sgid,"shopier_status","Durum","Shopier ödeme yöntemi aktiflik durumu","select\n0=Kapalı\n1=Açık","0");
            bePlugin::beCreateSetting($sgid,"shopier_merchant_user","API Kullanıcı Adı","Shopier paneli üzerinde modül ayarları kısmında bulunan API KULLANICI değeri","str");
            bePlugin::beCreateSetting($sgid,"shopier_merchant_password","API Şifre","Shopier paneli üzerinde modül ayarları kısmında bulunan API ŞİFRE değeri","str");
            bePlugin::beCreateSetting($sgid,"shopier_methodfee","Komisyon Oranı","Shopier ödeme yöntemi için eklenecek olan ekstra komisyon","int");
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti kuruldu!"];
        }
        public function plugin_remove(){
            $sgid = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","shopier")->beGet()["sgid"];
            SettingGroupsModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            SettingModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti silindi!"];
        }
    }

?>