<?php

    namespace App\System\Plugin;

    use App\System\Model\SettingGroupsModel;
    use App\System\Vendor\bePlugin;
    use App\System\Model\SettingModel;

    class mutlucell_helper {
        public function plugin_info(){
            return [
                "name" => "MutluCell Sms Modülü",
                "description" => "SMS'leri MutluCell ile göndermenizi sağlar",
                "version" => "1.2",
                "vercode" => 12,
                "author" => "ITenGriTR",
            ];
        }
        public function plugin_hooks(){
            return [];
        }
        public function plugin_settings(){
            $settinggroup = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","mutlucell")->beGet();
            return ["status" => true,"url" => beGetRoute("admin.settings.settinggroup.show",["sgid" => $settinggroup["sgid"]])];
        }
        public function plugin_install(){
            $sgid = bePlugin::beCreateSettingGroup("mutlucell","Mutlucell Ayarları","Sms gönderimleri için mutlucell ayarlarını içerinin");
            bePlugin::beCreateSetting($sgid,"mutlucell_usercode","Kullanıcı Kodu","mutlucell tarafından sağlanan usercode değerini girin","str","");
            bePlugin::beCreateSetting($sgid,"mutlucell_password","Kullanıcı Şifrei","mutlucell tarafından sağlanan password değerini girin","str","");
            bePlugin::beCreateSetting($sgid,"mutlucell_header","Mesaj Başlığı","mutlucell tarafından sağlanan telefon numarası değerini girin(8503083156)","str","");
            return [
                "status" => true,
                "message" => "Başarılı bir şekilde eklenti kuruldu!",
                "data" => [
                    "sgid" => $sgid
                ]
            ];
        }
        public function plugin_remove(){
            $sgid = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","mutlucell")->beGet()["sgid"];
            SettingGroupsModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            SettingModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti silindi!"];
        }
    }
?>