<?php

namespace App\System\Module;

use App\System\Basic\beModel;
use App\System\Basic\beRouter;
use App\System\Controller\NavController;
use App\System\Model\CurrencieModel;
use App\System\Model\CurrencyModel;
use App\System\Model\InvoiceItemModel;
use App\System\Model\InvoiceModel;
use App\System\Model\ModuleLogModel;
use App\System\Model\ProductModel;
use App\System\Model\SettingModel;
use App\System\Model\UserProductExtensionsModel;
use App\System\Model\UserProductModel;
use App\System\Vendor\Auth;
use App\System\Vendor\Basic\beCookie;
use App\System\Vendor\beLanguage;

class teamspeak {
    public $options = [
        "isneedserver" => true
    ];
    public function pages(){
        return [
            "/" => [
                "showmenu" => true,
                "name" => beGetLang("teamspeak_menu_home"),
                "icon" => "<i class=\"ri-home-line\"></i>"
            ],
            "ayarlar" => [
                "showmenu" => true,
                "name" => beGetLang("teamspeak_menu_setting"),
                "icon" => "<i class=\"ri-tools-line\"></i>",
                "function" => "teamspeak_clientarea_setting"
            ],
            "toplu-islemler" => [
                "showmenu" => true,
                "name" => beGetLang("teamspeak_menu_transaction"),
                "icon" => "<i class=\"ri-at-line\"></i>",
                "function" => "teamspeak_clientarea_transaction"
            ],
            "yetki-yonetimi" => [
                "showmenu" => true,
                "name" => beGetLang("teamspeak_menu_permission"),
                "icon" => "<i class=\"ri-admin-line\"></i>",
                "function" => "teamspeak_clientarea_permission"
            ],
            "yedek-yonetimi" => [
                "showmenu" => true,
                "name" => beGetLang("teamspeak_menu_snapshot"),
                "icon" => "<i class=\"ri-archive-line\"></i>",
                "function" => "teamspeak_clientarea_snapshot"
            ],
            "kullanici-yonetimi" => [
                "showmenu" => true,
                "name" => beGetLang("teamspeak_menu_user"),
                "icon" => "<i class=\"ri-user-line\"></i>",
                "function" => "teamspeak_clientarea_user"
            ],
            "ban" => [
                "showmenu" => true,
                "name" => beGetLang("teamspeak_menu_ban"),
                "icon" => "<i class=\"ri-forbid-line\"></i>",
                "function" => "teamspeak_clientarea_ban"
            ],
        ];
    }
    public function teamspeak_info(){
        return [
            "name" => "TeamSpeak",
            "description" => "TeamSpeak YATQA ile gerekli bağlantıyı kurup otomasyon sağlar",
            "version" => "1.0",
            "vercode" => 10,
            "type" => "server",
            "author" => "ITenGriTR"
        ];
    }
    public function teamspeak_connection_test($params = []){
        $response = $this->beSendApiRequest([
            "apiurl" => $params["surl"],
            "method" => "checkuser",
            "data" => [
                "login_host" => $params["surl"],
                "login_password" => $params["spassword"],
                "login_port" => $params["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return ["status" => false,"message" => $response["message"]];
        }
        return ["status" => true];
    }
    public function teamspeak_order_config(){
        return [
            "port" => [
                "name" => "Port",
                "description" => "Kullanıcının yöneteceği port",
                "type" => "integer",
                "default" => ""
            ],
            "slot" => [
                "name" => "Slot",
                "description" => "Kullanıcının sahip olduğu sunucunun maksimum kişi kapasitesi",
                "type" => "integer",
                "default" => ""
            ],
            "snapshotcount" => [
                "name" => "Toplam Yedek Hakkı",
                "description" => "Kullanıcının toplam bulundurabileceği yedek sayısı",
                "type" => "integer",
                "default" => ""
            ]
        ];
    }
    public function teamspeak_product_config($params = []){
        $templates = [0 => "Temel Yedeği Kurma"];
        return [
            "slot" => [
                "name" => "Kişi Sayısı",
                "description" => "Sunucunun toplam kişi sayısını belirler",
                "type" => "integer",
                "default" => "128",
                "form-view" => [
                    "class" => "col-6" 
                ],
                "requirements" => [
                    "min" => 0
                ]
            ],
            "snapshot" => [
                "name" => "Makismum Alınabilecek Yedek",
                "description" => "Müşterinin panel üzerinden alabileceği maksimum yedek sayısını belirler",
                "type" => "integer",
                "default" => "3",
                "form-view" => [
                    "class" => "col-6" 
                ],
                "requirements" => [
                    "min" => 0
                ]
            ]
        ];
    }
    public function teamspeak_addon_config($params = []){
        return [        
            "slot" => [
                "name" => "Ekstra Slot",
                "description" => "Müşterinin sunucusunun giriş sayısına ek olan giriş kişi sayısı",
                "type" => "integer",
                "default" => "",
                "form-view" => [
                    "class" => "col-4" 
                ],
                "requirements" => [
                    "min" => 0
                ]
            ],
            "snapshot" => [
                "name" => "Esktra Yedek",
                "description" => "Müşterinin panel üzerinden alabileceği ekstra yedek sayısını belirler",
                "type" => "integer",
                "default" => "3",
                "form-view" => [
                    "class" => "col-4" 
                ],
                "requirements" => [
                    "min" => 0
                ]
            ],
            "autosnapshot" => [
                "name" => "Otomatik Yedekleme",
                "description" => "Müşterinin isterse otomatik yedekleme opsiyonunun durumunu belirler",
                "type" => "select",
                "status" => 1,
                "default" => 1,
                "form-view" => [
                    "class" => "col-4" 
                ],
                "values" => [
                    0 => "Seçim Yapınız",
                    1 => "Otomatik Yedekleme Yapabilir",
                ]
            ]
        ];
    }
    public function teamspeak_create($params = []){
        $userproduct = $params["userproduct"];
        $productmodules = $params["productmodules"];
        $addonmodules = $params["addonmodules"];
        $usercount = (int)$productmodules["slot"];
        if($addonmodules["slot"][0]){
            $usercount += (int)$addonmodules["slot"][0];
        }
        $snapshotcount = (int)$productmodules["snapshot"];
        if($addonmodules["slot"][0]){
            $snapshotcount += (int)$addonmodules["snapshot"][0];
        }
        $autosnapshot = 0;
        if($addonmodules["autosnapshot"][0]){
            $autosnapshot = 1;
        }
        $snapshotdata = "";
        $settings = SettingModel::beGetSettings("teamspeak_port_start,teamspeak_port_end,teamspeak_default_snapshot");
        if(!$settings["teamspeak_port_start"]){
            ModuleLogModel::beCreateModuleLog($userproduct["upid"],"teamspeak","Kurulum Hatası","Bu modülün çalışabilmesi için eklentisinin yüklenmiş olması gerekiyor!");
            return ["status" => false,"message" => "Bu modülün çalışabilmesi için eklentisinin yüklenmiş olması gerekiyor!"];
        }
        $portstart = $settings["teamspeak_port_start"];
        $portend = $settings["teamspeak_port_end"];
        $tsid = $settings["teamspeak_default_snapshot"];
        if($tsid){
            $snapshot = beModel::beTable("be_teamspeak3_snapshot_default")->beSelect("tsid,tsdata")->beWhere("tsid",$tsid)->beGet();
            if($snapshot){
                $snapshotdata = $snapshot["tsdata"];
            }
        }
        $sitename = beGetConfig("sitename");
        $server_data = [
            "VIRTUALSERVER_NAME" => $sitename." TeamSpeak3 Sunucu",
            "VIRTUALSERVER_MAXCLIENTS" => $usercount,
            "VIRTUALSERVER_WELCOMEMESSAGE" => $sitename." TeamSpeak3 Sunucu",
            "VIRTUALSERVER_HOSTMESSAGE" => $sitename." TeamSpeak3 Sunucu",
            "VIRTUALSERVER_HOSTBANNER_URL" => beGetConfig("siteurl"),
            "VIRTUALSERVER_HOSTBUTTON_TOOLTIP" => $sitename,
            "VIRTUALSERVER_HOSTBUTTON_URL" => beGetConfig("siteurl")
        ];
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "servercreate",
            "data" => [
                "portstart" => $portstart,
                "portend" => $portend,
                "serverdata" => $server_data,
                "snapshot" => $snapshotdata,
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            ModuleLogModel::beCreateModuleLog($userproduct["upid"],"teamspeak","Kurulum Hatası",$response["message"],[
                "data" => $server_data,
                "response" => $response
            ]);
            return ["status" => false,"message" => "Sunucu oluşturulurken bir şeyler ters gitti!"];
        }
        $updatedata = [];
        $updatedata["uptag"] = $params["server"]["surl"].":".$response["port"];
        $updata = [
            "port" => $response["port"],
            "slot" => $usercount,
            "snapshotcount" => $snapshotcount,
            "autosnapshot" => $autosnapshot,
        ];
        $updatedata["updata"] = json_encode($updata,JSON_UNESCAPED_UNICODE);
        UserProductModel::beUpdate($updatedata)->beWhere("upid",$userproduct["upid"])->beExecute();
        beCookie::beCreateCookie("be_upid",$userproduct["upid"],true,true);
        return ["status" => true,"message" => "Ürün yönetim paneline yönlendiliriliyorsunuz","url" => beGetRoute("client.userproduct.userproduct.show",["upid" => $userproduct["upid"]])];
    }
    public function teamspeak_manage($params = []){
        $userproduct = $params["userproduct"];
        beCookie::beCreateCookie("be_upid",$userproduct["upid"],true,true);
        return ["status" => true,"message" => "Ürün yönetim paneline yönlendiliriliyorsunuz","url" => beGetRoute("client.userproduct.userproduct.show",["upid" => $userproduct["upid"]])];
    }
    public function teamspeak_suspend($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "poweraction",
            "data" => [
                "process" => "stop",
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return ["status" => false,"message" => $response["message"]];
        }
        return ["status" => true,"message" => "Başarılı bir şekilde sipariş modül üzerinde askıya alındı!"];
    }
    public function teamspeak_unsuspend($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "poweraction",
            "data" => [
                "process" => "start",
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return ["status" => false,"message" => $response["message"]];
        }
        return ["status" => true,"message" => "Başarılı bir şekilde sipariş modül üzerinde askıya alındı!"];
    }
    public function teamspeak_terminate($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "serverdelete",
            "data" => [
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return ["status" => false,"message" => $response["message"]];
        }
        return ["status" => true,"message" => "Başarılı bir şekilde sipariş modül üzerinde silindi!"];
    }
    public function teamspeak_clientarea($params = []){
        global $be;
        $theme = $be->settings["system_themename"];
        $moduleurl = beGetConfig("siteurl")."/app/resources/views/".$theme."/modules/teamspeak";
        $userproduct = $params["userproduct"];
        $productmodules = $params["productmodules"];
        $updata = json_decode($userproduct["updata"],true);
        $url = $params["url"];
        $page = $params["page"];
        beLanguage::beReadLang("teamspeak");
        $pages = $this->pages();
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "serverinfo",
            "data" => [
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            beError(beGetLang("teamspeak"),$response["message"]);
        }
        $serverinfo = $response["serverinfo"];
        if($page){
            $pageinfo = $pages[$page];
            if($pageinfo){
                $params["title"] = $pageinfo["name"];
                NavController::beAddBreadcumb($pageinfo["name"]);
                $function = $pageinfo["function"];
                $content = $this->$function($params);
            }
            else{
                $found = false;
                foreach($pages as $key => $value){
                    if($value["altmenu"]){
                        foreach($value["altmenu"] as $altkey => $altvalue){
                            if($page == $altkey){
                                $found = true;
                                break 2;
                            }
                        }
                    }
                }
                if($found){
                    $pageinfo = $altvalue;
                    $params["title"] = $pageinfo["name"];
                    NavController::beAddBreadcumb($pageinfo["name"]);
                    $function = $pageinfo["function"];
                    $content = $this->$function($params);
                }
                else{
                    $content = "Bu sayfa bulunamadı!";
                }
            }
        }
        else{
            $upoptions = json_decode($userproduct["upoptions"],true);
            $currencie = CurrencyModel::beGetCurrencies("cicon",$userproduct["cid"]);
            $orderinfo = [
                "product" => $userproduct["pname"],
                "billingprice" => $upoptions["period"]["price"],
                "billingcycle" => ProductModel::beGetPeriods()[$upoptions["period"]["period"]],
                "regdate" => date("d.m.Y",$userproduct["upstime"]),
                "nextduedate" => date("d.m.Y",$userproduct["upntime"]),
                "amount" => $userproduct["upprice"],
                "currencie" => $currencie
            ];
            $onlineclients = $serverinfo["virtualserver_clientsonline"]-$serverinfo["virtualserver_queryclientsonline"];
            $serverdata = [
                "ip" => $params["server"]["surl"],
                "status" => $serverinfo["virtualserver_status"] == "online" ? true:false,
                "name" => htmlspecialchars($serverinfo["virtualserver_name"]),
                "onlineclients" => $onlineclients,
                "maxclients" => $serverinfo["virtualserver_maxclients"],
                "ping" => round($serverinfo["virtualserver_total_ping"]),
                "banner" => $serverinfo["virtualserver_hostbanner_gfx_url"],
                "uptime" => beConvertTime($serverinfo["virtualserver_uptime"]),
                "created" => $serverinfo["virtualserver_created"],
                "channelcount" => $serverinfo["virtualserver_channelsonline"],
                "port" => $serverinfo["virtualserver_port"],
                "percentclient" => round($onlineclients*100/$serverinfo["virtualserver_maxclients"]),
            ];
            $response = $this->beSendApiRequest([
                "apiurl" => $params["server"]["surl"],
                "method" => "channellist",
                "data" => [
                    "port" => $updata["port"],
                    "login_host" => $params["server"]["surl"],
                    "login_password" => $params["server"]["spassword"],
                    "login_port" => $params["server"]["stoken"]
                ]
            ]);
            if(!$response["status"]){
                beError(beGetLang("teamspeak"),$response["message"]);
            }
            $channellist = $response["channellist"];
            foreach($channellist as $key => $value){
                $channellist[$key]["channel_name"] = preg_replace("/\[(.*?)spacer(.*)\]/siU","",$value["channel_name"]);
                if($value["total_clients"]){
                    $response = $this->beSendApiRequest([
                        "apiurl" => $params["server"]["surl"],
                        "method" => "channelclientlist",
                        "data" => [
                            "channel_id" => $value["cid"],
                            "port" => $updata["port"],
                            "login_host" => $params["server"]["surl"],
                            "login_password" => $params["server"]["spassword"],
                            "login_port" => $params["server"]["stoken"]
                        ]
                    ]);
                    if(!$response["status"]){
                        beError(beGetLang("teamspeak"),$response["message"]);
                    }
                    $channelclientlist = $response["channelclientlist"];
                    foreach($channelclientlist as $channelclient){
                        $client = [];
                        $client["nickname"] = htmlspecialchars($channelclient["client_nickname"]);
                        if($channelclient["client_away"] == 1){
                            $client["prefiximage"] = $moduleurl."/away.png";
                        }
                        else if($client["client_output_muted"]){
                            $client["prefiximage"] = $moduleurl."/output_muted.png";
                        }	
                        else if($client["client_input_muted"]){
                            $client["prefiximage"] = $moduleurl."/input_muted.png";
                        }
                        else if($client["client_flag_talking"]){
                            $client["prefiximage"] = $moduleurl."/player_on.png";
                        }	
                        else{
                            $client["prefiximage"] = $moduleurl."/player_off.png";
                        }
                        $channellist[$key]["clients"][] = $client;
                    }
                }
            }
            $invoice = null;
            $invoiceitem = InvoiceItemModel::beSelect("iid")->beWhere("iiobjectid",$userproduct["upid"])->beWhere("iiobject","ExtendOrder")->beOrder("iiid","DESC")->beLimit(1)->beGet();
            if($invoiceitem){
                $invoice = InvoiceModel::beSelect("iid,cid,iname,iprice")->beWhere("iid",$invoiceitem["iid"])->beWhere("istatus","0")->beGet();
            }
            $content = beGetView("modules.teamspeak.show",[
                "url" => $url,
                "pages" => $pages,
                "userproduct" => $userproduct,
                "orderinfo" => $orderinfo,
                "invoice" => $invoice,
                "serverdata" => $serverdata,
                "channellist" => $channellist
            ]);
        }
        $altmenu = [];
        $menuitems = [];
        foreach($pages as $pageurl => $data){
            if(!$data["showmenu"]){
                continue;
            }
            if($data["altmenu"]){
                foreach($data["altmenu"] as $key => $value){
                    $texturl = "";
                    if($key == "/"){
                        $texturl = $url;
                    }
                    else{
                        $texturl = $url."/".$key;
                    }
                    $data["altmenu"][$key]["url"] = $texturl;
                }
            }
            $texturl = "";
            if($pageurl == "/"){
                $texturl = $url;
            }
            else{
                $texturl = $url."/".$pageurl;
            }
            $menuitems[] = [
                "name" => $data["name"],
                "icon" => $data["icon"],
                "altmenu" => $data["altmenu"],
                "url" => $texturl
            ];
        }
        $altmenu[] = [
            "name" => "Sunucu Yönetimi",
            "menuitems" => $menuitems
        ];
        if(isset($serverinfo) && $serverinfo["virtualserver_status"] == "online"){
            $altmenu[] = [
                "name" => beGetLang("teamspeak_server_process"),
                "menuitems" => [
                    [
                        "name" => beGetLang("manage_stop"),
                        "icon" => "<i class=\"ri-stop-circle-line\"></i>",
                        "url" => "#",
                        "class" => "beCallRequestx",
                        "extra" => "data-method=\"power_action\" data-data=\"process=stop\""
                    ],
                    [
                        "name" => beGetLang("manage_restart"),
                        "icon" => "<i class=\"ri-restart-line\"></i>",
                        "url" => "#",
                        "class" => "beCallRequestx",
                        "extra" => "data-method=\"power_action\" data-data=\"process=restart\""
                    ],
                ]
            ];
        }
        else{
            $altmenu[] = [
                "name" => beGetLang("teamspeak_server_process"),
                "menuitems" => [
                    [
                        "name" => beGetLang("manage_start"),
                        "icon" => "<i class=\"ri-play-line\"></i>",
                        "url" => "#",
                        "class" => "beCallRequestx",
                        "extra" => "data-method=\"power_action\" data-data=\"process=start\""
                    ]
                ]
            ];
        }
        return [
            "status" => true,
            "title" => beGetLang("teamspeak"),
            "content" => $content,
            "menus" => $altmenu
        ];
    }
    public function teamspeak_clientarea_setting($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "serverinfo",
            "data" => [
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            beError(beGetLang("teamspeak"),$response["message"]);
        }
        $serverinfo = $response["serverinfo"];
        return beGetView("modules.teamspeak.setting",["userproduct" => $userproduct,"serverinfo" => $serverinfo]); 
    }
    public function teamspeak_server_edit($params = []){
        beLanguage::beReadLang("teamspeak");
        beLanguage::beReadLang("form");
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $name = $_POST["name"];
        $welcomemessage = $_POST["welcomemessage"];
        $hostmessage = $_POST["hostmessage"];
        $bannerurl = $_POST["bannerurl"];
        $gfxurl = $_POST["gfxurl"];
        $hostbuttontooltip = $_POST["hostbuttontooltip"];
        $hostbuttontooltipurl = $_POST["hostbuttontooltipurl"];
        if(!$name){
            return beAjaxError(["message" => beGetLang("form_not_full")]);
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "serveredit",
            "data" => [
                "serverdata" => [
                    "VIRTUALSERVER_NAME" => $name,
                    "VIRTUALSERVER_WELCOMEMESSAGE" => $welcomemessage,
                    "VIRTUALSERVER_HOSTMESSAGE" => $hostmessage,
                    "VIRTUALSERVER_HOSTBANNER_URL" => $bannerurl,
                    "VIRTUALSERVER_HOSTBANNER_GFX_URL" => $gfxurl,
                    "VIRTUALSERVER_HOSTBUTTON_TOOLTIP" => $hostbuttontooltip,
                    "VIRTUALSERVER_HOSTBUTTON_URL" => $hostbuttontooltipurl
                ],
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        return beAjaxSuccess(["message" => beGetLang("teamspeak_setting_updated")]);
    }
    public function teamspeak_clientarea_transaction($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "channellist",
            "data" => [
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            beError(beGetLang("teamspeak"),$response["message"]);
        }
        $channellist = $response["channellist"];
        return beGetView("modules.teamspeak.transaction",["userproduct" => $userproduct,"channellist" => $channellist]); 
    }
    public function teamspeak_move_all($params = []){
        beLanguage::beReadLang("teamspeak");
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $cid = (int)$_POST["channel"];
        $password = $_POST["password"];
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "moveall",
            "data" => [
                "channel" => $cid,
                "password" => $password,
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        return beAjaxSuccess(["message" => beGetLang("teamspeak_transaction_moved")]);
    }
    public function teamspeak_poke_all($params = []){
        beLanguage::beReadLang("teamspeak");
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $count = (int)$_POST["count"];
        $message = $_POST["message"];
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "pokeall",
            "data" => [
                "count" => $count,
                "message" => $message,
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        return beAjaxSuccess(["message" => beGetLang("teamspeak_transaction_moved")]);
    }
    public function teamspeak_kick_all($params = []){
        beLanguage::beReadLang("teamspeak");
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $message = $_POST["message"];
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "kickall",
            "data" => [
                "message" => $message,
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        return beAjaxSuccess(["message" => beGetLang("teamspeak_transaction_moved")]);
    }
    public function teamspeak_message_all($params = []){
        beLanguage::beReadLang("teamspeak");
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $message = $_POST["message"];
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "messageall",
            "data" => [
                "message" => $message,
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        return beAjaxSuccess(["message" => beGetLang("teamspeak_transaction_moved")]);
    }
    public function teamspeak_ban_all($params = []){
        beLanguage::beReadLang("teamspeak");
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $duration = (int)$_POST["duration"];
        $message = $_POST["message"];
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "banall",
            "data" => [
                "duration" => $duration,
                "message" => $message,
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        return beAjaxSuccess(["message" => beGetLang("teamspeak_transaction_moved")]);
    }
    public function teamspeak_clientarea_permission($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "clientlist",
            "data" => [
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            beError(beGetLang("teamspeak"),$response["message"]);
        }
        $clientlist = $response["clientlist"];
        foreach($clientlist as $key => $value){
            if($value["client_type"] == 1){
                unset($clientlist[$key]);
            }
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "grouplist",
            "data" => [
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            beError(beGetLang("teamspeak"),$response["message"]);
        }
        $grouplist = $response["grouplist"];
        foreach($grouplist as $key => $value){
            if($value["sgid"] < 4){
                unset($grouplist[$key]);
            }
        }
        $grouplist = array_reverse($grouplist);
        return beGetView("modules.teamspeak.permission",["userproduct" => $userproduct,"clientlist" => $clientlist,"grouplist" => $grouplist]); 
    }
    public function teamspeak_permission_add($params = []){
        beLanguage::beReadLang("teamspeak");
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $clid = (int)$_POST["clid"];
        $sgid = (int)$_POST["group"];
        if(!$clid){
            return beAjaxError(["message" => beGetLang("teamspeak_permission_user_not_found")]);
        }
        if($sgid < 4){
            return beAjaxError(["message" => beGetLang("teamspeak_permission_blocked")]);
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "clientinfo",
            "data" => [
                "clid" => $clid,
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        $clientinfo = $response["clientinfo"];
        if(!$clientinfo["client_database_id"]){
            return beAjaxError(["message" => beGetLang("teamspeak_permission_user_not_found")]);
        }
        $clientinfo["client_servergroups"] = explode(",",$clientinfo["client_servergroups"]);
        if(in_array($sgid,$clientinfo["client_servergroups"])){
            return beAjaxError(["message" => beGetLang("teamspeak_permission_already_have")]);
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "grouplist",
            "data" => [
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        $grouplist = $response["grouplist"];
        $found = false;
        foreach($grouplist as $key => $value){
            if($value["sgid"] < 4){
                unset($grouplist[$key]);
                continue;
            }
            if($value["sgid"] == $sgid){
                $found = true;
                break;
            }
        }
        if(!$found){
            return beAjaxError(["message" => beGetLang("teamspeak_permission_group_not_found")]);
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "groupclient",
            "data" => [
                "addgroups" => [$sgid],
                "cldbid" => $clientinfo["client_database_id"],
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        return beAjaxSuccess(["message" => beGetLang("teamspeak_permission_update")]);
    }
    public function teamspeak_permission_del($params = []){
        beLanguage::beReadLang("teamspeak");
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $clid = (int)$_POST["clid"];
        $sgid = (int)$_POST["group"];
        if(!$clid){
            return beAjaxError(["message" => beGetLang("teamspeak_permission_user_not_found")]);
        }
        if($sgid < 4){
            return beAjaxError(["message" => beGetLang("teamspeak_permission_blocked")]);
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "clientinfo",
            "data" => [
                "clid" => $clid,
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        $clientinfo = $response["clientinfo"];
        if(!$clientinfo["client_database_id"]){
            return beAjaxError(["message" => beGetLang("teamspeak_permission_user_not_found")]);
        }
        $clientinfo["client_servergroups"] = explode(",",$clientinfo["client_servergroups"]);
        if(!in_array($sgid,$clientinfo["client_servergroups"])){
            return beAjaxError(["message" => beGetLang("teamspeak_permission_dont_have")]);
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "grouplist",
            "data" => [
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        $grouplist = $response["grouplist"];
        $found = false;
        foreach($grouplist as $key => $value){
            if($value["sgid"] < 4){
                unset($grouplist[$key]);
                continue;
            }
            if($value["sgid"] == $sgid){
                $found = true;
                break;
            }
        }
        if(!$found){
            return beAjaxError(["message" => beGetLang("teamspeak_permission_group_not_found")]);
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "groupclient",
            "data" => [
                "delgroups" => [$sgid],
                "cldbid" => $clientinfo["client_database_id"],
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        return beAjaxSuccess(["message" => beGetLang("teamspeak_permission_update")]);
    }
    public function teamspeak_clientarea_snapshot($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $snapshots = beModel::beTable("be_teamspeak3_snapshot")->beSelect("tsid,tsname,tsdateline")->beWhere("upid",$userproduct["upid"])->beGetAll();
        $defalutsnapshots = beModel::beTable("be_teamspeak3_snapshot_default")->beSelect("tsid,tsname")->beGetAll();
        return beGetView("modules.teamspeak.snapshot",["userproduct" => $userproduct,"updata" => $updata,"snapshots" => $snapshots,"defalutsnapshots" => $defalutsnapshots]);
    }
    public function teamspeak_snapshot_setting_save($params = []){
        beLanguage::beReadLang("teamspeak");
        beLanguage::beReadLang("form");
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        if(!$updata["autosnapshot"]){
            return beAjaxError(["message" => beGetLang("teamspeak_snapshot_automation_no_permission")]);
        }
        $auto_backup = (int)$_POST["auto_backup"];
        $backup_delete = (int)$_POST["backup_delete"];
        if(!in_array($auto_backup,[0,1])){
            return beAjaxError(["message" => beGetLang("form_not_full")]);
        }
        if(!in_array($backup_delete,[0,1])){
            return beAjaxError(["message" => beGetLang("form_not_full")]);
        }
        $updata["auto_backup"] = $auto_backup;
        $updata["backup_delete"] = $backup_delete;
        UserProductModel::beUpdate(["updata" => json_encode($updata,JSON_UNESCAPED_UNICODE)])->beWhere("upid",$userproduct["upid"])->beExecute();
        return beAjaxSuccess(["message" => beGetLang("teamspeak_snapshot_automation_updated")]);
    }
    public function teamspeak_snapshot_create($params = []){
        beLanguage::beReadLang("teamspeak");
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $snapshotcount = (int)beModel::beTable("be_teamspeak3_snapshot")->beSelect("COUNT(tsid) as total")->beWhere("upid",$userproduct["upid"])->beGet()["total"];
        if($snapshotcount >= $updata["snapshotcount"]){
            return beAjaxError(["message" => beGetLang("teamspeak_snapshot_maximum",["maxcount" => $updata["snapshotcount"]])]);
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "snapshotcreate",
            "data" => [
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        $snapshot = $response["snapshot"];
        beModel::beInsert([
            "upid" => $userproduct["upid"],
            "tsname" => $response["snapshotname"],
            "tsdata" => $snapshot,
            "tstype" => "user",
            "tsdateline" => BE_TIME
        ],"be_teamspeak3_snapshot");
        return beAjaxSuccess(["message" => beGetLang("teamspeak_snapshot_created"),"refresh" => 1]);
    }
    public function teamspeak_snapshot_deploy($params = []) {
        beLanguage::beReadLang("teamspeak");
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $tsid = (int)$_POST["tsid"];
        $snapshot = [];
        $default = false;
        if($tsid < 0){
            $tsid *= -1;
            $snapshot = beModel::beTable("be_teamspeak3_snapshot_default")->beSelect("tsid,tsdata")->beWhere("tsid",$tsid)->beGet();
            if(!$snapshot){
                return beAjaxError(["message" => beGetLang("teamspeak_snapshot_not_found")]);
            }
            $default = true;
        }
        else{
            $snapshot = beModel::beTable("be_teamspeak3_snapshot")->beSelect("tsid,tsdata")->beWhere("tsid",$tsid)->beWhere("upid",$userproduct["upid"])->beGet();
            if(!$snapshot){
                return beAjaxError(["message" => beGetLang("teamspeak_snapshot_not_found")]);
            }
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "snapshotdeploy",
            "data" => [
                "snapshot" => $snapshot["tsdata"],
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        if($default){
            $sitename = beGetConfig("sitename");
            $response = $this->beSendApiRequest([
                "apiurl" => $params["server"]["surl"],
                "method" => "serveredit",
                "data" => [
                    "serverdata" => [
                        "VIRTUALSERVER_NAME" => $sitename." TeamSpeak3 Sunucu",
                        "VIRTUALSERVER_MAXCLIENTS" => $updata["slot"],
                        "VIRTUALSERVER_WELCOMEMESSAGE" => $sitename." TeamSpeak3 Sunucu",
                        "VIRTUALSERVER_HOSTMESSAGE" => $sitename." TeamSpeak3 Sunucu",
                        "VIRTUALSERVER_HOSTBANNER_URL" => beGetConfig("siteurl"),
                        "VIRTUALSERVER_HOSTBUTTON_TOOLTIP" => $sitename,
                        "VIRTUALSERVER_HOSTBUTTON_URL" => beGetConfig("siteurl")
                    ],
                    "port" => $updata["port"],
                    "login_host" => $params["server"]["surl"],
                    "login_password" => $params["server"]["spassword"],
                    "login_port" => $params["server"]["stoken"]
                ]
            ]);
        }
        return beAjaxSuccess(["message" => beGetLang("teamspeak_snapshot_deployed")]);
    }
    public function teamspeak_snapshot_delete($params = []){
        beLanguage::beReadLang("teamspeak");
        $userproduct = $params["userproduct"];
        $tsid = (int)$_POST["tsid"];
        $snapshot = beModel::beTable("be_teamspeak3_snapshot")->beSelect("tsid")->beWhere("tsid",$tsid)->beWhere("upid",$userproduct["upid"])->beGet();
        if(!$snapshot){
            return beAjaxError(["message" => beGetLang("teamspeak_snapshot_not_found")]);
        }
        beModel::beDelete("be_teamspeak3_snapshot")->beWhere("tsid",$snapshot["tsid"])->beExecute();
        return beAjaxSuccess(["message" => beGetLang("teamspeak_snapshot_deleted"),"refresh" => 1]);
    }
    public function teamspeak_clientarea_user($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "clientlist",
            "data" => [
                "port" => $updata["port"],
                "params" => "-times -info -ip",
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            beError(beGetLang("teamspeak"),$response["message"]);
        }
        $clientlist = $response["clientlist"];
        foreach($clientlist as $key => $value){
            if($value["client_type"] == 1){
                unset($clientlist[$key]);
            }
        }
        return beGetView("modules.teamspeak.user",["userproduct" => $userproduct,"clientlist" => $clientlist]); 
    }
    public function teamspeak_kick($params = []){
        beLanguage::beReadLang("teamspeak");
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $clid = (int)$_POST["clid"];
        if(!$clid){
            return beAjaxError(["message" => beGetLang("teamspeak_permission_user_not_found")]);
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "clientinfo",
            "data" => [
                "clid" => $clid,
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        $clientinfo = $response["clientinfo"];
        if(!$clientinfo["client_database_id"]){
            return beAjaxError(["message" => beGetLang("teamspeak_permission_user_not_found")]);
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "clientkick",
            "data" => [
                "clid" => $clid,
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        return beAjaxSuccess(["message" => beGetLang("teamspeak_user_kicked")]);
    }
    public function teamspeak_ban($params = []){
        beLanguage::beReadLang("teamspeak");
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $clid = (int)$_POST["clid"];
        if(!$clid){
            return beAjaxError(["message" => beGetLang("teamspeak_permission_user_not_found")]);
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "clientinfo",
            "data" => [
                "clid" => $clid,
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        $clientinfo = $response["clientinfo"];
        if(!$clientinfo["client_database_id"]){
            return beAjaxError(["message" => beGetLang("teamspeak_permission_user_not_found")]);
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "clientban",
            "data" => [
                "clid" => $clid,
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        return beAjaxSuccess(["message" => beGetLang("teamspeak_user_banned")]);
    }
    public function teamspeak_clientarea_ban($params = []){
        beLanguage::beReadLang("teamspeak");
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "banlist",
            "data" => [
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        $banlist = $response["banlist"];
        return beGetView("modules.teamspeak.ban",["userproduct" => $userproduct,"banlist" => $banlist]); 
    }
    public function teamspeak_unban($params = []){
        beLanguage::beReadLang("teamspeak");
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $banid = (int)$_POST["banid"];
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "unban",
            "data" => [
                "banid" => $banid,
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        return beAjaxSuccess(["message" => beGetLang("teamspeak_ban_removed")]);
    }
    public function teamspeak_unban_all($params = []){
        beLanguage::beReadLang("teamspeak");
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "unbanall",
            "data" => [
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        return beAjaxSuccess(["message" => beGetLang("teamspeak_ban_removed_all"),"refresh" => 1]);
    }
    public function teamspeak_power_action($params = []){
        beLanguage::beReadLang("teamspeak");
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        if(!in_array($_POST["process"],["stop","start","restart"])){
            return beAjaxError(["message" => beGetLang("manage_method_not_found")]);
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "poweraction",
            "data" => [
                "process" => $_POST["process"],
                "port" => $updata["port"],
                "login_host" => $params["server"]["surl"],
                "login_password" => $params["server"]["spassword"],
                "login_port" => $params["server"]["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        return beAjaxSuccess(["message" => beGetLang("manage_process_complated"),"refresh" => 1]);
    }
    public function beSendApiRequest($data = []){
        global $be;
        $settings = $be->settings;
        $data["data"] = array_merge($data["data"],[
            "cid" => $settings["system_id"],
            "ctoken" => $settings["system_token"],
            "secret" => $settings["system_secret"],
            "acces_token" => substr(md5($settings["system_id"].BE_TIME),0,8),
            "time" => BE_TIME
        ]);
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,"https://{$settings['system_data']['api']['active']}/api/teamspeak/{$data['method']}");
        curl_setopt($ch,CURLOPT_POST,1);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
        curl_setopt($ch,CURLOPT_POSTFIELDS,http_build_query($data["data"]));
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
        $response = curl_exec($ch);
        curl_close($ch);
        return json_decode($response,true);
    }
}